/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.transform.stc.AbstractTypeCheckingExtension;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.trait.TraitASTTransformation;
import org.codehaus.groovy.transform.trait.Traits;

public class TraitTypeCheckingExtension
extends AbstractTypeCheckingExtension {
    public TraitTypeCheckingExtension(StaticTypeCheckingVisitor typeCheckingVisitor) {
        super(typeCheckingVisitor);
    }

    @Override
    public List<MethodNode> handleMissingMethod(ClassNode receiver, String name, ArgumentListExpression argumentList, ClassNode[] argumentTypes, MethodCall call) {
        String[] decomposed = Traits.decomposeSuperCallName(name);
        if (decomposed != null) {
            List<MethodNode> candidates;
            String traitName = decomposed[0];
            String methodName = decomposed[1];
            List<ClassNode> implementedTraits = Traits.findTraits(receiver);
            ClassNode nextTrait = null;
            for (int i = 0; i < implementedTraits.size() - 1; ++i) {
                ClassNode implementedTrait = implementedTraits.get(i);
                if (!implementedTrait.getName().equals(traitName)) continue;
                nextTrait = implementedTraits.get(i + 1);
            }
            ClassNode returnType = ClassHelper.OBJECT_TYPE;
            if (nextTrait != null && (candidates = this.typeCheckingVisitor.findMethod(nextTrait, methodName, argumentTypes)).size() == 1) {
                returnType = candidates.get(0).getReturnType();
            }
            return Collections.singletonList(this.makeDynamic(call, returnType));
        }
        if (call instanceof MethodCallExpression) {
            ClassNode targetClass;
            MethodCallExpression mce = (MethodCallExpression)call;
            ClassNode returnType = (ClassNode)mce.getNodeMetaData(TraitASTTransformation.DO_DYNAMIC);
            if (returnType != null) {
                return Collections.singletonList(this.makeDynamic(call, returnType));
            }
            ClassNode classNode = targetClass = StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType(receiver) ? receiver.getGenericsTypes()[0].getType() : receiver;
            if (Traits.isTrait(targetClass.getOuterClass()) && argumentTypes.length > 0 && ClassHelper.isClassType(argumentTypes[0])) {
                Parameter[] signature = (Parameter[])Arrays.stream(argumentTypes).map(t -> new Parameter((ClassNode)t, "")).toArray(Parameter[]::new);
                List<ClassNode> traits = Traits.findTraits(targetClass.getOuterClass());
                traits.remove(targetClass.getOuterClass());
                for (ClassNode trait : traits) {
                    MethodNode method = Traits.findHelper(trait).getDeclaredMethod(name, signature);
                    if (method == null || !method.isStatic()) continue;
                    return Collections.singletonList(this.makeDynamic(call, method.getReturnType()));
                }
            }
        }
        return Collections.emptyList();
    }
}

