/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.jaxrs2;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.ParameterProcessor;
import io.swagger.v3.jaxrs2.ResolvedParameter;
import io.swagger.v3.jaxrs2.ext.AbstractOpenAPIExtension;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtension;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtensions;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DefaultParameterExtension
extends AbstractOpenAPIExtension {
    private static final String QUERY_PARAM = "query";
    private static final String HEADER_PARAM = "header";
    private static final String COOKIE_PARAM = "cookie";
    private static final String PATH_PARAM = "path";
    final ObjectMapper mapper = Json.mapper();

    @Override
    public ResolvedParameter extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Components components, Consumes classConsumes, Consumes methodConsumes, boolean includeRequestBody, JsonView jsonViewAnnotation, Iterator<OpenAPIExtension> chain) {
        io.swagger.v3.oas.models.parameters.Parameter unknownParameter;
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ResolvedParameter();
        }
        io.swagger.v3.oas.models.parameters.Parameter parameter = null;
        for (Annotation annotation : annotations) {
            io.swagger.v3.oas.models.parameters.Parameter pp;
            QueryParam param;
            if (annotation instanceof QueryParam) {
                param = (QueryParam)annotation;
                io.swagger.v3.oas.models.parameters.Parameter qp = new io.swagger.v3.oas.models.parameters.Parameter();
                qp.setIn(QUERY_PARAM);
                qp.setName(param.value());
                parameter = qp;
                continue;
            }
            if (annotation instanceof PathParam) {
                param = (PathParam)annotation;
                pp = new io.swagger.v3.oas.models.parameters.Parameter();
                pp.setIn(PATH_PARAM);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof MatrixParam) {
                param = (MatrixParam)annotation;
                pp = new io.swagger.v3.oas.models.parameters.Parameter();
                pp.setIn(PATH_PARAM);
                pp.setStyle(Parameter.StyleEnum.MATRIX);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof HeaderParam) {
                param = (HeaderParam)annotation;
                pp = new io.swagger.v3.oas.models.parameters.Parameter();
                pp.setIn(HEADER_PARAM);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof CookieParam) {
                param = (CookieParam)annotation;
                pp = new io.swagger.v3.oas.models.parameters.Parameter();
                pp.setIn(COOKIE_PARAM);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof Parameter) {
                if (((Parameter)annotation).hidden()) {
                    return new ResolvedParameter();
                }
                if (parameter == null) {
                    parameter = new io.swagger.v3.oas.models.parameters.Parameter();
                }
                if (!StringUtils.isNotBlank((CharSequence)((Parameter)annotation).ref())) continue;
                parameter.$ref(((Parameter)annotation).ref());
                continue;
            }
            ArrayList<io.swagger.v3.oas.models.parameters.Parameter> parameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
            ArrayList<io.swagger.v3.oas.models.parameters.Parameter> formParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
            if (!this.handleAdditionalAnnotation(parameters, formParameters, annotation, type, typesToSkip, classConsumes, methodConsumes, components, includeRequestBody, jsonViewAnnotation)) continue;
            ResolvedParameter extractParametersResult = new ResolvedParameter();
            extractParametersResult.parameters.addAll(parameters);
            extractParametersResult.formParameters.addAll(formParameters);
            return extractParametersResult;
        }
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> parameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        ResolvedParameter extractParametersResult = new ResolvedParameter();
        if (parameter != null && (StringUtils.isNotBlank((CharSequence)parameter.getIn()) || StringUtils.isNotBlank((CharSequence)parameter.get$ref()))) {
            parameters.add(parameter);
        } else if (includeRequestBody && (unknownParameter = ParameterProcessor.applyAnnotations(null, (Type)type, annotations, (Components)components, (String[])(classConsumes == null ? new String[]{} : classConsumes.value()), (String[])(methodConsumes == null ? new String[]{} : methodConsumes.value()), (JsonView)jsonViewAnnotation, (boolean)this.openapi31, (Schema.SchemaResolution)this.schemaResolution)) != null) {
            if (StringUtils.isNotBlank((CharSequence)unknownParameter.getIn()) && !"form".equals(unknownParameter.getIn())) {
                extractParametersResult.parameters.add(unknownParameter);
            } else if ("form".equals(unknownParameter.getIn())) {
                unknownParameter.setIn(null);
                extractParametersResult.formParameters.add(unknownParameter);
            } else {
                extractParametersResult.requestBody = unknownParameter;
            }
        }
        for (io.swagger.v3.oas.models.parameters.Parameter p : parameters) {
            io.swagger.v3.oas.models.parameters.Parameter processedParameter = ParameterProcessor.applyAnnotations((io.swagger.v3.oas.models.parameters.Parameter)p, (Type)type, annotations, (Components)components, (String[])(classConsumes == null ? new String[]{} : classConsumes.value()), (String[])(methodConsumes == null ? new String[]{} : methodConsumes.value()), (JsonView)jsonViewAnnotation, (boolean)this.openapi31, (Schema.SchemaResolution)this.schemaResolution);
            if (processedParameter == null) continue;
            extractParametersResult.parameters.add(processedParameter);
        }
        return extractParametersResult;
    }

    private boolean handleAdditionalAnnotation(List<io.swagger.v3.oas.models.parameters.Parameter> parameters, List<io.swagger.v3.oas.models.parameters.Parameter> formParameters, Annotation annotation, Type type, Set<Type> typesToSkip, Consumes classConsumes, Consumes methodConsumes, Components components, boolean includeRequestBody, JsonView jsonViewAnnotation) {
        boolean processed = false;
        if (BeanParam.class.isAssignableFrom(annotation.getClass())) {
            BeanDescription beanDesc = this.mapper.getSerializationConfig().introspect(this.constructType(type));
            List properties = beanDesc.findProperties();
            for (BeanPropertyDefinition propDef : properties) {
                AnnotationMap annotationMap;
                AnnotatedField field = propDef.getField();
                AnnotatedMethod setter = propDef.getSetter();
                AnnotatedMethod getter = propDef.getGetter();
                ArrayList<Annotation> paramAnnotations = new ArrayList<Annotation>();
                Iterator<OpenAPIExtension> extensions = OpenAPIExtensions.chain();
                JavaType paramType = null;
                if (field != null) {
                    paramType = field.getType();
                    annotationMap = field.getAllAnnotations();
                    if (annotationMap != null) {
                        for (Annotation fieldAnnotation : annotationMap.annotations()) {
                            if (paramAnnotations.contains(fieldAnnotation)) continue;
                            paramAnnotations.add(fieldAnnotation);
                        }
                    }
                }
                if (setter != null) {
                    if (paramType == null) {
                        paramType = setter.getParameterType(0);
                    }
                    if ((annotationMap = setter.getAllAnnotations()) != null) {
                        for (Annotation fieldAnnotation : annotationMap.annotations()) {
                            if (paramAnnotations.contains(fieldAnnotation)) continue;
                            paramAnnotations.add(fieldAnnotation);
                        }
                    }
                }
                if (getter != null) {
                    if (paramType == null) {
                        paramType = getter.getType();
                    }
                    if ((annotationMap = getter.getAllAnnotations()) != null) {
                        for (Annotation fieldAnnotation : annotationMap.annotations()) {
                            if (paramAnnotations.contains(fieldAnnotation)) continue;
                            paramAnnotations.add(fieldAnnotation);
                        }
                    }
                }
                if (paramType == null) continue;
                boolean hidden = false;
                for (Annotation a : paramAnnotations) {
                    if (a instanceof Schema) {
                        if (!((Schema)a).hidden()) continue;
                        hidden = true;
                        break;
                    }
                    if (!(a instanceof Hidden)) continue;
                    hidden = true;
                    break;
                }
                if (hidden) continue;
                ResolvedParameter resolvedParameter = extensions.next().extractParameters(paramAnnotations, (Type)paramType, typesToSkip, components, classConsumes, methodConsumes, includeRequestBody, jsonViewAnnotation, extensions);
                List<io.swagger.v3.oas.models.parameters.Parameter> extractedParameters = resolvedParameter.parameters;
                for (io.swagger.v3.oas.models.parameters.Parameter p : extractedParameters) {
                    io.swagger.v3.oas.models.parameters.Parameter processedParam = ParameterProcessor.applyAnnotations((io.swagger.v3.oas.models.parameters.Parameter)p, (Type)paramType, paramAnnotations, (Components)components, (String[])(classConsumes == null ? new String[]{} : classConsumes.value()), (String[])(methodConsumes == null ? new String[]{} : methodConsumes.value()), (JsonView)jsonViewAnnotation, (boolean)this.openapi31, (Schema.SchemaResolution)this.schemaResolution);
                    if (processedParam == null) continue;
                    parameters.add(processedParam);
                }
                List<io.swagger.v3.oas.models.parameters.Parameter> extractedFormParameters = resolvedParameter.formParameters;
                for (io.swagger.v3.oas.models.parameters.Parameter p : extractedFormParameters) {
                    io.swagger.v3.oas.models.parameters.Parameter processedParam = ParameterProcessor.applyAnnotations((io.swagger.v3.oas.models.parameters.Parameter)p, (Type)paramType, paramAnnotations, (Components)components, (String[])(classConsumes == null ? new String[]{} : classConsumes.value()), (String[])(methodConsumes == null ? new String[]{} : methodConsumes.value()), (JsonView)jsonViewAnnotation, (boolean)this.openapi31, (Schema.SchemaResolution)this.schemaResolution);
                    if (processedParam == null) continue;
                    formParameters.add(processedParam);
                }
                processed = true;
            }
        }
        return processed;
    }

    @Override
    protected boolean shouldIgnoreClass(Class<?> cls) {
        return cls.getName().startsWith("jakarta.ws.rs.");
    }
}

