/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.attribute.AbstractAggregatingDefaultQueryPersonAttributeDao;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.attribute.AttributeRepositoryResolver;
import org.apereo.cas.authentication.attribute.MergingPersonAttributeDaoImpl;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolutionExecutionPlanConfigurer;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.merger.AttributeMerger;
import org.apereo.cas.authentication.principal.resolvers.PersonDirectoryPrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.core.authentication.StubPrincipalAttributesProperties;
import org.apereo.cas.persondir.CascadingPersonAttributeDao;
import org.apereo.cas.persondir.DefaultAttributeRepositoryResolver;
import org.apereo.cas.persondir.DefaultPersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryCustomizer;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.persondir.cache.CachingPersonAttributeDaoImpl;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.report.CasPersonDirectoryEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory})
@Configuration(value="CasPersonDirectoryConfiguration", proxyBeanMethods=false)
class CasPersonDirectoryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryConfiguration.class);

    CasPersonDirectoryConfiguration() {
    }

    @Configuration(value="CasPersonDirectoryAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasPersonDirectoryAttributeRepositoryConfiguration {
        CasPersonDirectoryAttributeRepositoryConfiguration() {
        }

        private static AbstractAggregatingDefaultQueryPersonAttributeDao getAggregateAttributeRepository(CasConfigurationProperties casProperties) {
            PrincipalAttributesProperties properties = casProperties.getAuthn().getAttributeRepository();
            if (properties.getCore().getAggregation() == PrincipalAttributesCoreProperties.AggregationStrategyTypes.CASCADE) {
                CascadingPersonAttributeDao dao = new CascadingPersonAttributeDao();
                dao.setAddOriginalAttributesToQuery(true);
                dao.setStopIfFirstDaoReturnsNull(properties.getCore().isStopCascadingWhenNoInitialResults());
                return dao;
            }
            return new MergingPersonAttributeDaoImpl();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"attributeRepositoryResolver"})
        public AttributeRepositoryResolver attributeRepositoryResolver(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultAttributeRepositoryResolver(servicesManager, casProperties);
        }

        @Bean(name={"cachingAttributeRepository", "attributeRepository"})
        @ConditionalOnMissingBean(name={"cachingAttributeRepository", "attributeRepository"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PersonAttributeDao cachingAttributeRepository(CasConfigurationProperties casProperties, @Qualifier(value="aggregatingAttributeRepository") PersonAttributeDao aggregatingAttributeRepository) {
            PrincipalAttributesCoreProperties props = casProperties.getAuthn().getAttributeRepository().getCore();
            if (props.getExpirationTime() <= 0) {
                LOGGER.warn("Attribute repository caching is disabled");
                return aggregatingAttributeRepository;
            }
            CachingPersonAttributeDaoImpl impl = new CachingPersonAttributeDaoImpl();
            impl.setCacheNullResults(false);
            Cache userinfoCache = Caffeine.newBuilder().maximumSize((long)props.getMaximumCacheSize()).expireAfterWrite((long)props.getExpirationTime(), TimeUnit.valueOf(props.getExpirationTimeUnit().toUpperCase(Locale.ENGLISH))).build();
            impl.setUserInfoCache((Map)userinfoCache.asMap());
            impl.setCachedPersonAttributesDao(aggregatingAttributeRepository);
            LOGGER.trace("Configured cache expiration policy for attribute sources to be [{}] minute(s)", (Object)props.getExpirationTime());
            return impl;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"attributeRepositoryAttributeMerger"})
        public AttributeMerger attributeRepositoryAttributeMerger(CasConfigurationProperties casProperties) {
            return CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger());
        }

        @Bean
        @ConditionalOnMissingBean(name={"aggregatingAttributeRepository"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PersonAttributeDao aggregatingAttributeRepository(@Qualifier(value="attributeRepositoryAttributeMerger") AttributeMerger attributeRepositoryAttributeMerger, CasConfigurationProperties casProperties, @Qualifier(value="personDirectoryAttributeRepositoryPlan") PersonDirectoryAttributeRepositoryPlan personDirectoryAttributeRepositoryPlan) {
            AbstractAggregatingDefaultQueryPersonAttributeDao aggregate = CasPersonDirectoryAttributeRepositoryConfiguration.getAggregateAttributeRepository(casProperties);
            aggregate.setAttributeMerger(attributeRepositoryAttributeMerger);
            List list = personDirectoryAttributeRepositoryPlan.getAttributeRepositories();
            aggregate.setPersonAttributeDaos(list);
            PrincipalAttributesProperties properties = casProperties.getAuthn().getAttributeRepository();
            aggregate.setRequireAll(properties.getCore().isRequireAllRepositorySources());
            if (list.isEmpty()) {
                LOGGER.debug("No attribute repository sources are available/defined to merge together.");
            } else {
                String names = list.stream().map(p -> Arrays.toString(p.getId())).collect(Collectors.joining(","));
                LOGGER.debug("Configured attribute repository sources to merge together: [{}]", (Object)names);
            }
            boolean recoverExceptions = properties.getCore().isRecoverExceptions();
            aggregate.setRecoverExceptions(recoverExceptions);
            LOGGER.trace("Configured attribute repository to recover from exceptions: [{}]", (Object)recoverExceptions);
            return aggregate;
        }

        @Bean
        @Lazy(value=false)
        public InitializingBean casPersonDirectoryInitializer(CasConfigurationProperties casProperties) {
            return () -> FunctionUtils.doIf((boolean)LOGGER.isInfoEnabled(), value -> {
                StubPrincipalAttributesProperties stub = casProperties.getAuthn().getAttributeRepository().getStub();
                Map attrs = stub.getAttributes();
                if (!attrs.isEmpty()) {
                    LOGGER.info("Found and added static attributes [{}] to the list of candidate attribute repositories", attrs.keySet());
                }
            }).accept(null);
        }
    }

    @Configuration(value="CasPersonDirectoryAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasPersonDirectoryAttributeRepositoryPlanConfiguration {
        CasPersonDirectoryAttributeRepositoryPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"personDirectoryAttributeRepositoryPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PersonDirectoryAttributeRepositoryPlan personDirectoryAttributeRepositoryPlan(List<PersonDirectoryAttributeRepositoryPlanConfigurer> configurers, ObjectProvider<List<PersonDirectoryAttributeRepositoryCustomizer>> customizers) {
            DefaultPersonDirectoryAttributeRepositoryPlan plan = new DefaultPersonDirectoryAttributeRepositoryPlan(Optional.ofNullable((List)customizers.getIfAvailable()).orElseGet(ArrayList::new));
            configurers.forEach(cfg -> cfg.configureAttributeRepositoryPlan((PersonDirectoryAttributeRepositoryPlan)plan));
            AnnotationAwareOrderComparator.sort((List)plan.getAttributeRepositories());
            LOGGER.trace("Final list of attribute repositories is [{}]", (Object)plan.getAttributeRepositories());
            return plan;
        }
    }

    @Configuration(value="CasPersonDirectoryPrincipalResolutionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasPersonDirectoryPrincipalResolutionConfiguration {
        CasPersonDirectoryPrincipalResolutionConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasPersonDirectoryEndpoint casPersonDirectoryEndpoint(@Autowired @Qualifier(value="cachingAttributeRepository") ObjectProvider<PersonAttributeDao> cachingAttributeRepository, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return new CasPersonDirectoryEndpoint(casProperties, applicationContext, cachingAttributeRepository);
        }

        @ConditionalOnMissingBean(name={"personDirectoryPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory personDirectoryPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"personDirectoryAttributeRepositoryPrincipalResolver"})
        public PrincipalResolver personDirectoryAttributeRepositoryPrincipalResolver(@Qualifier(value="attributeRepositoryResolver") AttributeRepositoryResolver attributeRepositoryResolver, ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="attributeRepositoryAttributeMerger") AttributeMerger attributeRepositoryAttributeMerger, CasConfigurationProperties casProperties, @Qualifier(value="personDirectoryPrincipalFactory") PrincipalFactory personDirectoryPrincipalFactory, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository) {
            PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
            return PersonDirectoryPrincipalResolver.newPersonDirectoryPrincipalResolver((ConfigurableApplicationContext)applicationContext, (PrincipalFactory)personDirectoryPrincipalFactory, (PersonAttributeDao)attributeRepository, (AttributeMerger)attributeRepositoryAttributeMerger, (ServicesManager)servicesManager, (AttributeDefinitionStore)attributeDefinitionStore, (AttributeRepositoryResolver)attributeRepositoryResolver, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{personDirectory});
        }

        @ConditionalOnMissingBean(name={"principalResolutionExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalResolutionExecutionPlanConfigurer principalResolutionExecutionPlanConfigurer(@Qualifier(value="personDirectoryAttributeRepositoryPlan") PersonDirectoryAttributeRepositoryPlan personDirectoryAttributeRepositoryPlan, @Qualifier(value="personDirectoryAttributeRepositoryPrincipalResolver") PrincipalResolver personDirectoryAttributeRepositoryPrincipalResolver) {
            return plan -> {
                if (personDirectoryAttributeRepositoryPlan.isEmpty()) {
                    LOGGER.debug("Attribute repository sources are not available for person-directory principal resolution");
                } else {
                    LOGGER.trace("Attribute repository sources are defined and available for person-directory principal resolution chain. ");
                    plan.registerPrincipalResolver(personDirectoryAttributeRepositoryPrincipalResolver);
                }
            };
        }
    }
}

