/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.api.CasConfigurationPropertiesSourceLocator;
import org.apereo.cas.configuration.loader.CasConfigurationPropertiesLoader;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class DefaultCasConfigurationPropertiesSourceLocator
implements CasConfigurationPropertiesSourceLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasConfigurationPropertiesSourceLocator.class);
    private static final List<String> EXTENSIONS = Arrays.asList("yml", "yaml", "properties");
    private static final List<String> PROFILE_PATTERNS = Arrays.asList("application-%s.%s", "%s.%s");
    private final CipherExecutor<String, String> casConfigurationCipherExecutor;

    private static PropertySource<?> loadEnvironmentAndSystemProperties() {
        CompositePropertySource source = new CompositePropertySource("environmentAndSystemProperties");
        source.addPropertySource((PropertySource)new PropertiesPropertySource("systemProperties", System.getProperties()));
        source.addPropertySource((PropertySource)new SystemEnvironmentPropertySource("systemEnvironment", System.getenv()));
        return source;
    }

    @Override
    public Optional<PropertySource<?>> locate(Environment environment, ResourceLoader resourceLoader) {
        CompositePropertySource compositePropertySource = new CompositePropertySource("casCompositePropertySource");
        compositePropertySource.addPropertySource(DefaultCasConfigurationPropertiesSourceLocator.loadEnvironmentAndSystemProperties());
        File config = CasConfigurationPropertiesSourceLocator.getStandaloneProfileConfigurationDirectory(environment);
        LOGGER.debug("Located CAS standalone configuration directory at [{}]", (Object)config);
        if (config != null && config.isDirectory() && config.exists()) {
            CompositePropertySource sourceProfiles = this.loadSettingsByApplicationProfiles(environment, config);
            if (!sourceProfiles.getPropertySources().isEmpty()) {
                compositePropertySource.addPropertySource((PropertySource)sourceProfiles);
            }
        } else {
            LOGGER.info("Configuration directory [{}] is not a directory or cannot be found at the specific path", FunctionUtils.doIfNotNull((Object)config, () -> config, () -> "unspecified").get());
        }
        PropertySource<?> embeddedProperties = this.loadEmbeddedProperties(resourceLoader, environment);
        compositePropertySource.addPropertySource(embeddedProperties);
        return Optional.of(compositePropertySource);
    }

    private static List<File> getAllPossibleExternalConfigDirFilenames(Environment environment, File configDirectory, List<String> profiles) {
        String applicationName = CasConfigurationPropertiesSourceLocator.getApplicationName(environment);
        String configName = CasConfigurationPropertiesSourceLocator.getConfigurationName(environment);
        String appNameLowerCase = applicationName.toLowerCase(Locale.ENGLISH);
        List appConfigNames = CollectionUtils.wrapList((Object[])new String[]{"application", appNameLowerCase, applicationName, configName});
        List<File> fileNames = appConfigNames.stream().distinct().flatMap(appName -> EXTENSIONS.stream().map(ext -> new File(configDirectory, String.format("%s.%s", appName, ext)))).filter(File::exists).collect(Collectors.toList());
        fileNames.addAll(profiles.stream().flatMap(profile -> EXTENSIONS.stream().flatMap(ext -> PROFILE_PATTERNS.stream().map(pattern -> new File(configDirectory, String.format(pattern, profile, ext))))).filter(File::exists).toList());
        fileNames.addAll(profiles.stream().map(profile -> EXTENSIONS.stream().map(ext -> appConfigNames.stream().map(appName -> new File(configDirectory, String.format("%s-%s.%s", appName, profile, ext))).filter(File::exists).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).flatMap(Collection::stream).toList());
        File groovyFile = new File(configDirectory, appNameLowerCase.concat(".groovy"));
        FunctionUtils.doIf((boolean)groovyFile.exists(), o -> fileNames.add(groovyFile)).accept(groovyFile);
        return fileNames;
    }

    private static List<Resource> scanForConfigurationResources(Environment environment, File config, List<String> profiles) {
        List<File> possibleFiles = DefaultCasConfigurationPropertiesSourceLocator.getAllPossibleExternalConfigDirFilenames(environment, config, profiles);
        return possibleFiles.stream().filter(File::exists).filter(File::isFile).map(FileSystemResource::new).collect(Collectors.toList());
    }

    private CompositePropertySource loadSettingsByApplicationProfiles(Environment environment, File config) {
        List<String> profiles = Arrays.stream(environment.getActiveProfiles()).toList();
        List<Resource> resources = DefaultCasConfigurationPropertiesSourceLocator.scanForConfigurationResources(environment, config, profiles);
        CompositePropertySource composite = new CompositePropertySource("applicationProfilesCompositeProperties");
        LOGGER.info("Configuration files found at [{}] are [{}] under profile(s) [{}]", new Object[]{config, resources, profiles});
        resources.forEach(Unchecked.consumer(resource -> {
            LOGGER.debug("Loading configuration file [{}]", resource);
            List<CasConfigurationPropertiesLoader> configurationLoaders = CasConfigurationPropertiesSourceLocator.getConfigurationPropertiesLoaders();
            CasConfigurationPropertiesLoader foundLoader = configurationLoaders.stream().filter(loader -> loader.supports((Resource)resource)).findFirst().orElseThrow();
            PropertySource source = foundLoader.load((Resource)resource, environment, "applicationProfilesProperties-" + resource.getFilename(), this.casConfigurationCipherExecutor);
            composite.addFirstPropertySource(source);
        }));
        return composite;
    }

    protected PropertySource<?> loadEmbeddedProperties(ResourceLoader resourceLoader, Environment environment) {
        List<String> profiles = Arrays.stream(environment.getActiveProfiles()).toList();
        List configFiles = profiles.stream().map(profile -> EXTENSIONS.stream().map(ext -> String.format("classpath:/application-%s.%s", profile, ext)).collect(Collectors.toList())).flatMap(Collection::stream).map(arg_0 -> ((ResourceLoader)resourceLoader).getResource(arg_0)).collect(Collectors.toList());
        configFiles.addAll(EXTENSIONS.stream().map(ext -> String.format("classpath:/application.%s", ext)).map(arg_0 -> ((ResourceLoader)resourceLoader).getResource(arg_0)).toList());
        LOGGER.debug("Loading embedded configuration files [{}]", configFiles);
        CompositePropertySource composite = new CompositePropertySource("embeddedCompositeProperties");
        List<CasConfigurationPropertiesLoader> configurationLoaders = CasConfigurationPropertiesSourceLocator.getConfigurationPropertiesLoaders();
        configFiles.stream().filter(Resource::exists).forEach(resource -> {
            LOGGER.trace("Loading properties from [{}]", resource);
            CasConfigurationPropertiesLoader foundLoader = configurationLoaders.stream().filter(loader -> loader.supports((Resource)resource)).findFirst().orElseThrow();
            String sourceName = String.format("embeddedProperties-%s", resource.getFilename());
            PropertySource source = foundLoader.load((Resource)resource, environment, sourceName, this.casConfigurationCipherExecutor);
            composite.addPropertySource(source);
        });
        return composite;
    }

    @Generated
    public DefaultCasConfigurationPropertiesSourceLocator(CipherExecutor<String, String> casConfigurationCipherExecutor) {
        this.casConfigurationCipherExecutor = casConfigurationCipherExecutor;
    }
}

