/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.BeanPanel;
import org.apache.syncope.client.console.rest.AuthModuleRestClient;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.mapping.AuthModuleMappingPanel;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.AbstractLDAPConf;
import org.apache.syncope.common.lib.auth.AuthModuleConf;
import org.apache.syncope.common.lib.auth.LDAPDependantAuthModuleConf;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.common.lib.types.AuthModuleState;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.springframework.util.ClassUtils;

public class AuthModuleWizardBuilder
extends BaseAjaxWizardBuilder<AuthModuleTO> {
    private static final long serialVersionUID = -6163230263062920394L;
    protected final LoadableDetachableModel<List<String>> authModuleConfs = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return SyncopeWebApplication.get().getLookup().getClasses(AuthModuleConf.class).stream().map(Class::getName).sorted().collect(Collectors.toList());
        }
    };
    protected final AuthModuleRestClient authModuleRestClient;
    protected final Model<Class<? extends AuthModuleConf>> authModuleConfClass = Model.of();

    public AuthModuleWizardBuilder(AuthModuleTO defaultItem, AuthModuleRestClient authModuleRestClient, PageReference pageRef) {
        super((Serializable)defaultItem, pageRef);
        this.authModuleRestClient = authModuleRestClient;
    }

    protected Serializable onApplyInternal(AuthModuleTO modelObject) {
        if (this.mode == AjaxWizard.Mode.CREATE) {
            this.authModuleRestClient.create(modelObject);
        } else {
            this.authModuleRestClient.update(modelObject);
        }
        return modelObject;
    }

    protected WizardModel buildModelSteps(AuthModuleTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject, this.authModuleConfs, this.authModuleConfClass));
        wizardModel.add((IWizardStep)new Configuration(modelObject));
        wizardModel.add((IWizardStep)new AuthModuleConfLDAP(modelObject, this.authModuleConfClass));
        wizardModel.add((IWizardStep)new Mapping(modelObject));
        return wizardModel;
    }

    protected static class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;

        Profile(final AuthModuleTO authModule, LoadableDetachableModel<List<String>> authModuleConfs, final Model<Class<? extends AuthModuleConf>> authModuleConfClass) {
            boolean isNew;
            boolean bl = isNew = authModule.getConf() == null;
            if (!isNew) {
                authModuleConfClass.setObject((Serializable)authModule.getConf().getClass());
            }
            AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)authModule, "key"));
            key.addRequiredLabel();
            key.setEnabled(isNew);
            this.add(new Component[]{key});
            AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", this.getString("description"), (IModel)new PropertyModel((Object)authModule, "description"));
            this.add(new Component[]{description});
            AjaxDropDownChoicePanel state = new AjaxDropDownChoicePanel("state", this.getString("state"), (IModel)new PropertyModel((Object)authModule, "state"));
            state.setChoices(List.of(AuthModuleState.values()));
            state.addRequiredLabel();
            state.setNullValid(false);
            this.add(new Component[]{state});
            this.add(new Component[]{new AjaxNumberFieldPanel.Builder().build("order", "order", Integer.class, (IModel)new PropertyModel((Object)authModule, "order")).addRequiredLabel()});
            final AjaxDropDownChoicePanel conf = new AjaxDropDownChoicePanel("conf", this.getString("type"), (IModel)(isNew ? Model.of() : Model.of((Serializable)((Object)authModule.getConf().getClass().getName()))));
            conf.setChoices((List)authModuleConfs.getObject());
            conf.addRequiredLabel();
            conf.setNullValid(false);
            conf.setEnabled(isNew);
            conf.add(new Behavior[]{new AjaxEventBehavior("change"){
                private static final long serialVersionUID = -7133385027739964990L;

                protected void onEvent(AjaxRequestTarget target) {
                    try {
                        Class clazz = ClassUtils.resolveClassName((String)((String)((Object)conf.getModelObject())), (ClassLoader)ClassUtils.getDefaultClassLoader());
                        authModule.setConf((AuthModuleConf)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        authModuleConfClass.setObject((Serializable)clazz);
                    }
                    catch (Exception e) {
                        LOG.error("Cannot instantiate {}", (Object)conf.getModelObject(), (Object)e);
                    }
                }
            }});
            this.add(new Component[]{conf});
        }
    }

    protected class Configuration
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        Configuration(AuthModuleTO authModule) {
            this.add(new Component[]{new BeanPanel("bean", (IModel)new PropertyModel((Object)authModule, "conf"), AuthModuleWizardBuilder.this.pageRef, new String[]{"ldap"}).setRenderBodyOnly(true)});
        }
    }

    protected class AuthModuleConfLDAP
    extends WizardStep
    implements WizardModel.ICondition {
        private static final long serialVersionUID = 5328049907748683944L;
        private final Model<Class<? extends AuthModuleConf>> authModuleConfClass;

        AuthModuleConfLDAP(final AuthModuleTO authModule, final Model<Class<? extends AuthModuleConf>> authModuleConfClass) {
            this.authModuleConfClass = authModuleConfClass;
            final PropertyModel beanPanelModel = new PropertyModel((Object)authModule, "conf.ldap");
            AjaxCheckBoxPanel enable = new AjaxCheckBoxPanel("enable", "enableLDAP", (IModel)new IModel<Boolean>(){
                private static final long serialVersionUID = -7126718045816207110L;

                public Boolean getObject() {
                    return beanPanelModel.getObject() != null;
                }

                public void setObject(Boolean object) {
                }
            });
            enable.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    if (beanPanelModel.getObject() == null) {
                        try {
                            beanPanelModel.setObject((Object)((AbstractLDAPConf)((Class)authModuleConfClass.getObject()).getMethod("ldapInstance", new Class[0]).invoke((Object)authModule.getConf(), new Object[0])));
                        }
                        catch (Exception e) {
                            LOG.warn("Error instantiating beanPanel model object", (Throwable)e);
                        }
                    } else {
                        beanPanelModel.setObject(null);
                    }
                    target.add(new Component[]{AuthModuleConfLDAP.this});
                }
            }});
            this.add(new Component[]{enable});
            this.add(new Component[]{new BeanPanel("bean", (IModel)beanPanelModel, AuthModuleWizardBuilder.this.pageRef, new String[0]).setRenderBodyOnly(true)});
            this.setOutputMarkupId(true);
        }

        public boolean evaluate() {
            return LDAPDependantAuthModuleConf.class.isAssignableFrom((Class)this.authModuleConfClass.getObject());
        }
    }

    protected static final class Mapping
    extends WizardStep {
        private static final long serialVersionUID = 3454904947720856253L;

        Mapping(AuthModuleTO authModule) {
            this.setTitleModel((IModel)Model.of((Serializable)((Object)"Mapping")));
            this.setSummaryModel((IModel)Model.of((Serializable)((Object)"")));
            this.add(new Component[]{new AuthModuleMappingPanel("mapping", authModule)});
        }
    }
}

