/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.saml2.SAML2LoginResponse;
import org.apache.syncope.common.lib.saml2.SAML2Request;
import org.apache.syncope.common.lib.saml2.SAML2Response;
import org.apache.syncope.common.rest.api.service.SAML2SP4UIService;
import org.apache.syncope.core.logic.SAML2SP4UILogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.stereotype.Service;

@Service
public class SAML2SP4UIServiceImpl
extends AbstractService
implements SAML2SP4UIService {
    protected final SAML2SP4UILogic logic;

    public SAML2SP4UIServiceImpl(SAML2SP4UILogic logic) {
        this.logic = logic;
    }

    public Response getMetadata(String spEntityID, String urlContext) {
        StreamingOutput sout = os -> this.logic.getMetadata(StringUtils.appendIfMissing((String)spEntityID, (CharSequence)"/", (CharSequence[])new CharSequence[0]), urlContext, os);
        return Response.ok((Object)sout).type("application/xml").build();
    }

    public SAML2Request createLoginRequest(String spEntityID, String urlContext, String idpEntityID) {
        return this.logic.createLoginRequest(StringUtils.appendIfMissing((String)spEntityID, (CharSequence)"/", (CharSequence[])new CharSequence[0]), urlContext, idpEntityID);
    }

    public SAML2LoginResponse validateLoginResponse(SAML2Response reponse) {
        return this.logic.validateLoginResponse(reponse);
    }

    public SAML2Request createLogoutRequest(String spEntityID, String urlContext) {
        return this.logic.createLogoutRequest(this.getAccessToken(), StringUtils.appendIfMissing((String)spEntityID, (CharSequence)"/", (CharSequence[])new CharSequence[0]), urlContext);
    }

    public void validateLogoutResponse(SAML2Response response) {
        this.logic.validateLogoutResponse(response);
    }

    private String getAccessToken() {
        String auth = this.messageContext.getHttpHeaders().getHeaderString("Authorization");
        String[] parts = Optional.ofNullable(auth).map(s -> s.split(" ")).orElse(null);
        if (parts == null || parts.length != 2 || !"Bearer".equals(parts[0])) {
            return null;
        }
        return parts[1];
    }
}

