/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Optional;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.DefaultCasConfigurationPropertiesSourceLocator;
import org.apereo.cas.configuration.api.CasConfigurationPropertiesSourceLocator;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Profile;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.io.ResourceLoader;

@Configuration(value="CasCoreBaseStandaloneConfiguration", proxyBeanMethods=false)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.CasConfiguration})
class CasCoreBaseStandaloneConfiguration {
    CasCoreBaseStandaloneConfiguration() {
    }

    @Configuration(value="CasCoreBootstrapStandaloneLocatorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Profile(value={"standalone", "native", "embedded"})
    @Lazy(value=false)
    static class CasCoreBootstrapStandaloneLocatorConfiguration {
        CasCoreBootstrapStandaloneLocatorConfiguration() {
        }

        @ConditionalOnMissingBean(name={"casConfigurationPropertiesSourceLocator"})
        @Bean
        public static CasConfigurationPropertiesSourceLocator casConfigurationPropertiesSourceLocator(@Qualifier(value="casConfigurationCipherExecutor") CipherExecutor<String, String> casConfigurationCipherExecutor) {
            return new DefaultCasConfigurationPropertiesSourceLocator(casConfigurationCipherExecutor);
        }
    }

    @Configuration(value="CasCoreBootstrapStandaloneSourcesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Lazy(value=false)
    static class CasCoreBootstrapStandaloneSourcesConfiguration
    implements PriorityOrdered {
        CasCoreBootstrapStandaloneSourcesConfiguration() {
        }

        @Bean
        public static PropertySourceLocator casCoreBootstrapPropertySourceLocator(List<CasConfigurationPropertiesSourceLocator> locatorList, ResourceLoader resourceLoader) {
            AnnotationAwareOrderComparator.sortIfNecessary(locatorList);
            return environment -> {
                CompositePropertySource composite = new CompositePropertySource("casCoreBootstrapPropertySourceLocator");
                locatorList.stream().map(locator -> locator.locate(environment, resourceLoader)).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((CompositePropertySource)composite).addPropertySource(arg_0));
                return composite;
            };
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }
}

