/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.logout.handler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.factory.ProfileManagerFactory;
import org.pac4j.core.store.GuavaStore;
import org.pac4j.core.store.Store;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSessionLogoutHandler
implements SessionLogoutHandler {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSessionLogoutHandler.class);
    private Store<String, Object> store = new GuavaStore<String, Object>(10000, 30, TimeUnit.MINUTES);
    private boolean destroySession;

    public DefaultSessionLogoutHandler() {
    }

    public DefaultSessionLogoutHandler(Store<String, Object> store) {
        this.store = store;
    }

    @Override
    public void recordSession(CallContext ctx, String key) {
        WebContext webContext = ctx.webContext();
        SessionStore sessionStore = ctx.sessionStore();
        if (sessionStore == null) {
            LOGGER.error("No session store available for this web context");
        } else {
            Optional<String> optSessionId = sessionStore.getSessionId(webContext, true);
            if (optSessionId.isEmpty()) {
                LOGGER.error("No session identifier retrieved although the session creation has been requested");
            } else {
                String sessionId = optSessionId.get();
                Optional<Object> optTrackableSession = sessionStore.getTrackableSession(webContext);
                if (optTrackableSession.isPresent()) {
                    Object trackableSession = optTrackableSession.get();
                    LOGGER.debug("key: {} -> trackableSession: {}", (Object)key, trackableSession);
                    LOGGER.debug("sessionId: {}", (Object)sessionId);
                    this.store.set(key, trackableSession);
                    this.store.set(sessionId, key);
                } else {
                    LOGGER.debug("No trackable session for the current session store: {}", (Object)sessionStore);
                }
            }
        }
    }

    @Override
    public void destroySession(CallContext ctx, String key) {
        WebContext webContext = ctx.webContext();
        SessionStore sessionStore = ctx.sessionStore();
        Optional<Object> optTrackableSession = this.store.get(key);
        if (optTrackableSession.isPresent()) {
            this.store.remove(key);
        }
        if (sessionStore == null) {
            LOGGER.warn("No session store. Cannot destroy session");
            return;
        }
        Optional<String> optCurrentSessionId = sessionStore.getSessionId(ctx.webContext(), false);
        if (optCurrentSessionId.isPresent()) {
            String currentSessionId = optCurrentSessionId.get();
            LOGGER.debug("current sessionId: {}", (Object)currentSessionId);
            String keyForCurrentSession = this.store.get(currentSessionId).orElse(null);
            LOGGER.debug("key associated to the current session: {}", (Object)key);
            this.store.remove(currentSessionId);
            if (CommonHelper.areEquals(key, keyForCurrentSession)) {
                this.destroy(webContext, sessionStore, ctx.profileManagerFactory(), "front");
                return;
            }
            LOGGER.debug("Unknown/new web session: cannot perform front channel logout");
        } else {
            LOGGER.debug("No web session: cannot perform front channel logout");
        }
        LOGGER.debug("TrackableSession: {} for key: {}", optTrackableSession, (Object)key);
        if (optTrackableSession.isEmpty()) {
            LOGGER.debug("No trackable session: cannot perform back channel logout");
        } else {
            Optional<SessionStore> optNewSessionStore = sessionStore.buildFromTrackableSession(webContext, optTrackableSession.get());
            if (optNewSessionStore.isPresent()) {
                SessionStore newSessionStore = optNewSessionStore.get();
                LOGGER.debug("newSesionStore: {}", (Object)newSessionStore);
                String sessionId = newSessionStore.getSessionId(webContext, true).get();
                LOGGER.debug("new sessionId: {}", (Object)sessionId);
                this.store.remove(sessionId);
                this.destroy(webContext, newSessionStore, ctx.profileManagerFactory(), "back");
                return;
            }
            LOGGER.warn("Cannot build new session store from tracked session: cannot perform back channel logout");
        }
    }

    protected void destroy(WebContext webContext, SessionStore sessionStore, ProfileManagerFactory profileManagerFactory, String channel) {
        ProfileManager manager = (ProfileManager)profileManagerFactory.apply(webContext, sessionStore);
        manager.removeProfiles();
        LOGGER.debug("{} channel logout call: destroy the user profiles", (Object)channel);
        if (this.destroySession) {
            LOGGER.debug("destroy the whole session");
            boolean invalidated = sessionStore.destroySession(webContext);
            if (!invalidated) {
                LOGGER.error("The session has not been invalidated");
            }
        }
    }

    @Override
    public void renewSession(CallContext ctx, String oldSessionId) {
        Optional<String> optKey = this.cleanRecord(oldSessionId);
        if (optKey.isPresent()) {
            this.recordSession(ctx, optKey.get());
        }
    }

    @Override
    public Optional<String> cleanRecord(String sessionId) {
        String key = this.store.get(sessionId).orElse(null);
        this.store.remove(sessionId);
        LOGGER.debug("cleaning sessionId: {} -> key: {}", (Object)sessionId, (Object)key);
        if (key != null) {
            this.store.remove(key);
        }
        return Optional.ofNullable(key);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DefaultSessionLogoutHandler(store=" + this.store + ", destroySession=" + this.destroySession + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Store<String, Object> getStore() {
        return this.store;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDestroySession() {
        return this.destroySession;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStore(Store<String, Object> store) {
        this.store = store;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDestroySession(boolean destroySession) {
        this.destroySession = destroySession;
    }
}

