/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.service;

import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.DirectoryObjectGetMemberGroupsParameterSet;
import com.microsoft.graph.models.DirectoryObjectGetMemberObjectsParameterSet;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.SubscribedSku;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.UserAssignLicenseParameterSet;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.DirectoryObjectCollectionReferenceRequest;
import com.microsoft.graph.requests.DirectoryObjectCollectionReferenceRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectCollectionWithReferencesPage;
import com.microsoft.graph.requests.DirectoryObjectGetMemberGroupsCollectionPage;
import com.microsoft.graph.requests.DirectoryObjectGetMemberGroupsCollectionRequest;
import com.microsoft.graph.requests.DirectoryObjectGetMemberObjectsCollectionPage;
import com.microsoft.graph.requests.DirectoryObjectGetMemberObjectsCollectionRequest;
import com.microsoft.graph.requests.DirectoryObjectReferenceRequest;
import com.microsoft.graph.requests.DirectoryObjectReferenceRequestBuilder;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.GroupCollectionPage;
import com.microsoft.graph.requests.GroupCollectionRequest;
import com.microsoft.graph.requests.SubscribedSkuCollectionPage;
import com.microsoft.graph.requests.SubscribedSkuCollectionRequest;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.tirasa.connid.bundles.azure.AzureConnectorConfiguration;
import net.tirasa.connid.bundles.azure.service.AzureService;
import net.tirasa.connid.bundles.azure.service.NoSuchEntityException;
import net.tirasa.connid.bundles.azure.utils.AzureFilter;
import net.tirasa.connid.bundles.azure.utils.AzureUtils;
import org.identityconnectors.common.logging.Log;

public class AzureClient
extends AzureService {
    private static final Log LOG = Log.getLog(AzureClient.class);

    public AzureClient(AzureConnectorConfiguration config) {
        super(config);
    }

    public AzureClient getAuthenticated() {
        this.checkAuth();
        return this;
    }

    public List<User> getAllUsers() {
        LOG.ok("Get all users", new Object[0]);
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        UserCollectionPage userCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(new Option[0])).orderBy("displayName").get();
        List<Object> users = new ArrayList<User>();
        if (userCollectionPage != null) {
            users = userCollectionPage.getCurrentPage();
        }
        return users;
    }

    public List<User> getAllUsers(int pageSize) {
        LOG.ok("Get all users with page size {0}", new Object[]{pageSize});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        UserCollectionPage userCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(new Option[0])).top(pageSize).orderBy("displayName").get();
        List<Object> users = new ArrayList<User>();
        if (userCollectionPage != null) {
            users = userCollectionPage.getCurrentPage();
        }
        return users;
    }

    public UserCollectionPage getAllUsersNextPage(int pageSize, String skipToken) {
        LOG.ok("Get all users next page with page size {0}", new Object[]{pageSize});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        return (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(new Option[0])).top(pageSize).skipToken(skipToken).orderBy("displayName").get();
    }

    public User getUser(String userId) {
        LOG.ok("Getting user {0}", new Object[]{userId});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        return graphClient.users(userId).buildRequest(new Option[0]).select(String.join((CharSequence)",", this.config.getUserAttributesToGet())).get();
    }

    public List<User> getUsersFilteredBy(AzureFilter filters) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        LinkedList<HeaderOption> requestOptions = new LinkedList<HeaderOption>();
        requestOptions.add(new HeaderOption("ConsistencyLevel", "eventual"));
        StringBuilder queryFilter = new StringBuilder();
        queryFilter.append(AzureUtils.getFilter(filters));
        LOG.ok("Searching users with filter {0}", new Object[]{queryFilter});
        UserCollectionPage userCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).select(String.join((CharSequence)",", this.config.getUserAttributesToGet())).filter(queryFilter.toString()).get();
        List users = null;
        if (userCollectionPage != null) {
            users = userCollectionPage.getCurrentPage();
        }
        return users;
    }

    public List<User> getAllMembersOfGroup(String groupId) {
        LOG.ok("Get all members of group {0}", new Object[]{groupId});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        DirectoryObjectCollectionWithReferencesPage group = (DirectoryObjectCollectionWithReferencesPage)((DirectoryObjectCollectionReferenceRequest)graphClient.groups(groupId).members().buildRequest(new Option[0])).get();
        ArrayList<User> users = new ArrayList<User>();
        if (group != null) {
            group.getCurrentPage().stream().filter(directoryObject -> directoryObject instanceof User).forEach(directoryObject -> users.add((User)directoryObject));
        }
        return users;
    }

    public void addUserToGroup(String userId, String groupId) {
        LOG.ok("Adding user {0} to group {1}", new Object[]{userId, groupId});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        try {
            ((DirectoryObjectCollectionReferenceRequest)((DirectoryObjectCollectionReferenceRequestBuilder)graphClient.groups(groupId).members().references()).buildRequest(new Option[0])).post((DirectoryObject)graphClient.users(userId).buildRequest(new Option[0]).get());
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While adding User to Group", ex);
        }
    }

    public void deleteUserFromGroup(String userId, String groupId) {
        LOG.ok("Deleting user {0} from group {1}", new Object[]{userId, groupId});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        DirectoryObject deletedObject = null;
        try {
            deletedObject = (DirectoryObject)((DirectoryObjectReferenceRequest)((DirectoryObjectReferenceRequestBuilder)graphClient.groups(groupId).members(userId).reference()).buildRequest(new Option[0])).delete();
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While deleting User from Group", ex);
        }
        if (deletedObject == null) {
            throw new NoSuchEntityException(userId);
        }
    }

    public List<Group> getAllGroups() {
        LOG.ok("Get all groups", new Object[0]);
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        GroupCollectionPage groupCollectionPage = (GroupCollectionPage)((GroupCollectionRequest)graphClient.groups().buildRequest(new Option[0])).get();
        List<Object> groups = new ArrayList<Group>();
        if (groupCollectionPage != null) {
            groups = groupCollectionPage.getCurrentPage();
        }
        return groups;
    }

    public List<Group> getAllGroups(int pageSize) {
        LOG.ok("Get all groups with page size {0}", new Object[]{pageSize});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        GroupCollectionPage groupCollectionPage = (GroupCollectionPage)((GroupCollectionRequest)graphClient.groups().buildRequest(new Option[0])).top(pageSize).orderBy("displayName").get();
        List<Object> groups = new ArrayList<Group>();
        if (groupCollectionPage != null) {
            groups = groupCollectionPage.getCurrentPage();
        }
        return groups;
    }

    public GroupCollectionPage getAllGroupsNextPage(int pageSize, String skipToken) {
        LOG.ok("Get all groups next page with page size {0}", new Object[]{pageSize});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        return (GroupCollectionPage)((GroupCollectionRequest)graphClient.groups().buildRequest(new Option[0])).top(pageSize).skipToken(skipToken).orderBy("displayName").get();
    }

    public List<Group> getAllGroupsForUser(String userId) {
        LOG.ok("Get all groups user {0} is member", new Object[]{userId});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            ((DirectoryObjectCollectionWithReferencesPage)((DirectoryObjectCollectionReferenceRequest)graphClient.users(userId).memberOf().buildRequest(new Option[0])).get()).getCurrentPage().stream().filter(directoryObject -> directoryObject instanceof Group).forEach(directoryObject -> groups.add((Group)directoryObject));
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While getting groups for User " + userId, ex);
        }
        return groups;
    }

    public Group getGroup(String groupId) {
        LOG.ok("Getting group {0}", new Object[]{groupId});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        return graphClient.groups(groupId).buildRequest(new Option[0]).select(String.join((CharSequence)",", this.config.getGroupAttributesToGet())).get();
    }

    public List<Group> getGroupsFilteredBy(AzureFilter filters) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        LinkedList<HeaderOption> requestOptions = new LinkedList<HeaderOption>();
        requestOptions.add(new HeaderOption("ConsistencyLevel", "eventual"));
        StringBuilder queryFilter = new StringBuilder();
        queryFilter.append(AzureUtils.getFilter(filters));
        LOG.ok("Searching groups with filter {0}", new Object[]{queryFilter});
        GroupCollectionPage groupCollectionPage = (GroupCollectionPage)((GroupCollectionRequest)graphClient.groups().buildRequest(requestOptions)).select(String.join((CharSequence)",", this.config.getGroupAttributesToGet())).filter(queryFilter.toString()).get();
        List groups = null;
        if (groupCollectionPage != null) {
            groups = groupCollectionPage.getCurrentPage();
        }
        return groups;
    }

    public DirectoryObject getDeletedDirectoryObject(String id) {
        LOG.ok("Get deleted directory object {0} if exists", new Object[]{id});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        return graphClient.directory().deletedItems(id).buildRequest(new Option[0]).get();
    }

    public User createUser(User user) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        return ((UserCollectionRequest)graphClient.users().buildRequest(new Option[0])).post(user);
    }

    public Group createGroup(Group group) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        return ((GroupCollectionRequest)graphClient.groups().buildRequest(new Option[0])).post(group);
    }

    public User updateUser(User user) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        graphClient.users(user.id).buildRequest(new Option[0]).patch(user);
        return this.getUser(user.id);
    }

    public Group updateGroup(Group group) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        return graphClient.groups(group.id).buildRequest(new Option[0]).patch(group);
    }

    public void deleteUser(String userId) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        graphClient.users(userId).buildRequest(new Option[0]).delete();
    }

    public void deleteGroup(String groupId) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        graphClient.groups(groupId).buildRequest(new Option[0]).delete();
    }

    public DirectoryObject restoreDirectoryObject(String id) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        return graphClient.directory().deletedItems(id).restore().buildRequest(new Option[0]).post();
    }

    public List<SubscribedSku> getCurrentTenantSubscriptions() {
        LOG.ok("Get all subscriptions", new Object[0]);
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        SubscribedSkuCollectionPage subscribedSkuCollectionPage = (SubscribedSkuCollectionPage)((SubscribedSkuCollectionRequest)graphClient.subscribedSkus().buildRequest(new Option[0])).get();
        List results = null;
        if (subscribedSkuCollectionPage != null) {
            results = subscribedSkuCollectionPage.getCurrentPage();
        }
        return results;
    }

    public List<String> getCurrentTenantSkuIds(boolean onlyEnabled) {
        LOG.ok("Get all enabled subscriptions", new Object[0]);
        ArrayList<String> result = new ArrayList<String>();
        List<SubscribedSku> subscriptions = this.getCurrentTenantSubscriptions();
        try {
            for (SubscribedSku subscription : subscriptions) {
                if (onlyEnabled && subscription.capabilityStatus.equalsIgnoreCase("enabled")) {
                    result.add(subscription.skuId.toString());
                    continue;
                }
                if (onlyEnabled) continue;
                result.add(subscription.skuId.toString());
            }
        }
        catch (Exception ex) {
            AzureUtils.handleGeneralError("While getting current tenant available licenses", ex);
        }
        return result;
    }

    public void assignLicense(String userId, UserAssignLicenseParameterSet assignedLicense) {
        LOG.ok("Assigning licenses to user {0}", new Object[]{userId});
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        graphClient.users(userId).assignLicense(assignedLicense).buildRequest(new Option[0]).post();
    }

    public Boolean isMemberOf(String memberId, String groupId) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        ArrayList<QueryOption> queryOptions = new ArrayList<QueryOption>();
        queryOptions.add(new QueryOption("$filter", (Object)("id eq '" + memberId + "'")));
        try {
            DirectoryObjectCollectionWithReferencesPage result = (DirectoryObjectCollectionWithReferencesPage)((DirectoryObjectCollectionReferenceRequest)graphClient.groups(groupId).members().buildRequest(queryOptions)).get();
            return result != null;
        }
        catch (GraphServiceException ex) {
            return false;
        }
    }

    public List<String> getMemberGroups(String resourceId, boolean securityEnabledOnly) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        DirectoryObjectGetMemberGroupsParameterSet securityEnabled = new DirectoryObjectGetMemberGroupsParameterSet();
        securityEnabled.securityEnabledOnly = securityEnabledOnly;
        return ((DirectoryObjectGetMemberGroupsCollectionPage)((DirectoryObjectGetMemberGroupsCollectionRequest)graphClient.directoryObjects(resourceId).getMemberGroups(securityEnabled).buildRequest(new Option[0])).post()).getCurrentPage();
    }

    public List<String> getMemberObjects(String resourceId, boolean securityEnabledOnly) {
        GraphServiceClient<?> graphClient = this.getGraphServiceClient();
        DirectoryObjectGetMemberObjectsParameterSet securityEnabled = new DirectoryObjectGetMemberObjectsParameterSet();
        securityEnabled.securityEnabledOnly = securityEnabledOnly;
        return ((DirectoryObjectGetMemberObjectsCollectionPage)((DirectoryObjectGetMemberObjectsCollectionRequest)graphClient.directoryObjects(resourceId).getMemberObjects(securityEnabled).buildRequest(new Option[0])).post()).getCurrentPage();
    }
}

