/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.WebflowExceptionTranslator;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DefaultCasDelegatingWebflowEventResolver
extends AbstractCasWebflowEventResolver
implements CasDelegatingWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasDelegatingWebflowEventResolver.class);
    private final List<CasWebflowEventResolver> orderedResolvers = new ArrayList<CasWebflowEventResolver>(0);
    private final CasWebflowEventResolver selectiveResolver;

    public DefaultCasDelegatingWebflowEventResolver(CasWebflowEventResolutionConfigurationContext configurationContext, CasWebflowEventResolver selectiveResolver) {
        super(configurationContext);
        this.selectiveResolver = selectiveResolver;
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) throws Throwable {
        List<Credential> credentials = this.getCredentialFromContext(context);
        Service service = this.locateServiceForRequest(context);
        LOGGER.trace("Resolved service [{}]", (Object)service);
        try {
            if (credentials != null && !credentials.isEmpty()) {
                String agent = WebUtils.getHttpServletRequestUserAgentFromRequestContext((RequestContext)context);
                GeoLocationRequest geoLocation = WebUtils.getHttpServletRequestGeoLocationFromRequestContext((RequestContext)context);
                Map properties = CollectionUtils.wrap((String)"UserAgent", (Object)agent, (String)"GeoLocation", (Object)geoLocation);
                credentials.forEach(cred -> cred.getCredentialMetadata().putProperties(properties));
                AuthenticationResultBuilder builder = this.getConfigurationContext().getAuthenticationSystemSupport().handleInitialAuthenticationTransaction(service, credentials.toArray(new Credential[0]));
                builder.collect(credentials.toArray(new Credential[0]));
                builder.getInitialAuthentication().ifPresent(authn -> {
                    WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)context);
                    WebUtils.putAuthentication((Authentication)authn, (RequestContext)context);
                });
            }
            RegisteredService registeredService = this.determineRegisteredServiceForEvent(context, service);
            LOGGER.trace("Attempting to resolve candidate authentication events for service [{}]", (Object)service);
            Collection<Event> resolvedEvents = this.resolveCandidateAuthenticationEvents(context, service, registeredService);
            if (resolvedEvents.isEmpty()) {
                LOGGER.trace("No candidate authentication events were resolved for service [{}]", (Object)service);
            } else {
                LOGGER.trace("Authentication events resolved for [{}] are [{}]. Selecting final event...", (Object)service, resolvedEvents);
                WebUtils.putResolvedEventsAsAttribute((RequestContext)context, resolvedEvents);
                Event finalResolvedEvent = this.selectiveResolver.resolveSingle(context);
                LOGGER.debug("The final authentication event resolved for [{}] is [{}]", (Object)service, (Object)finalResolvedEvent);
                if (finalResolvedEvent != null) {
                    return CollectionUtils.wrapSet((Object)finalResolvedEvent);
                }
            }
            AuthenticationResultBuilder builder = WebUtils.getAuthenticationResultBuilder((RequestContext)context);
            if (builder == null) {
                String msg = "Unable to locate authentication object in the webflow context";
                throw new IllegalArgumentException((Throwable)new AuthenticationException("Unable to locate authentication object in the webflow context"));
            }
            return CollectionUtils.wrapSet((Object)this.grantTicketGrantingTicketToAuthenticationResult(context, builder, service));
        }
        catch (Throwable exception) {
            Event event = this.buildEventFromException(exception, context, credentials, service);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            LOGGER.debug("Authentication request failed with [{}], resulting in event [{}]", (Object)response.getStatus(), (Object)event);
            return CollectionUtils.wrapSet((Object)event);
        }
    }

    @Override
    public void addDelegate(CasWebflowEventResolver resolver) {
        if (BeanSupplier.isNotProxy((Object)resolver)) {
            this.orderedResolvers.add(resolver);
        }
    }

    @Override
    public void addDelegate(CasWebflowEventResolver resolver, int index) {
        if (BeanSupplier.isNotProxy((Object)resolver)) {
            this.orderedResolvers.add(index, resolver);
        }
    }

    protected Collection<Event> resolveCandidateAuthenticationEvents(RequestContext context, Service service, RegisteredService registeredService) {
        return this.orderedResolvers.stream().filter(BeanSupplier::isNotProxy).map(Unchecked.function(resolver -> {
            LOGGER.debug("Resolving candidate authentication event for service [{}] using [{}]", (Object)service, (Object)resolver.getName());
            return resolver.resolveSingle(context);
        })).filter(Objects::nonNull).sorted(Comparator.comparing(Event::getId)).collect(Collectors.toList());
    }

    protected Event buildEventFromException(Throwable exception, RequestContext requestContext, List<Credential> credential, Service service) {
        Event event = WebflowExceptionTranslator.from(exception, requestContext);
        LoggingUtils.warn((Logger)LOGGER, (Throwable)exception);
        LocalAttributeMap attributes = new LocalAttributeMap();
        attributes.put("error", event.getSource());
        if (!credential.isEmpty()) {
            attributes.put(Credential.class.getName(), (Object)credential.getFirst());
        }
        attributes.put(WebApplicationService.class.getName(), (Object)service);
        attributes.putAll(event.getAttributes());
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        attributes.put("url", (Object)HttpRequestUtils.getFullRequestUrl((HttpServletRequest)request));
        return this.newEvent(event.getId(), (AttributeMap)attributes);
    }

    private RegisteredService determineRegisteredServiceForEvent(RequestContext context, Service service) throws Throwable {
        if (service == null) {
            return null;
        }
        LOGGER.trace("Locating authentication event in the request context...");
        Authentication authn = WebUtils.getAuthentication((RequestContext)context);
        if (authn == null) {
            String msg = "Unable to locate authentication object in the webflow context";
            throw new IllegalArgumentException((Throwable)new AuthenticationException("Unable to locate authentication object in the webflow context"));
        }
        LOGGER.trace("Locating service [{}] in service registry to determine authentication policy", (Object)service);
        RegisteredService registeredService = this.getConfigurationContext().getServicesManager().findServiceBy(service);
        LOGGER.trace("Enforcing access strategy policies for registered service [{}] and principal [{}]", (Object)registeredService, (Object)authn.getPrincipal());
        URI unauthorizedRedirectUrl = registeredService.getAccessStrategy().getUnauthorizedRedirectUrl();
        if (unauthorizedRedirectUrl != null) {
            WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)unauthorizedRedirectUrl);
        }
        RegisteredServiceAttributeReleasePolicyContext attributeReleaseContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(service).principal(authn.getPrincipal()).applicationContext((ApplicationContext)this.getConfigurationContext().getApplicationContext()).build();
        Map releasingAttributes = registeredService.getAttributeReleasePolicy().getAttributes(attributeReleaseContext);
        releasingAttributes.putAll(authn.getAttributes());
        Map accessStrategyAttributes = CoreAuthenticationUtils.mergeAttributes((Map)authn.getPrincipal().getAttributes(), (Map)releasingAttributes);
        Principal accessStrategyPrincipal = this.getConfigurationContext().getPrincipalFactory().createPrincipal(authn.getPrincipal().getId(), accessStrategyAttributes);
        AuditableContext audit = AuditableContext.builder().service(service).principal(accessStrategyPrincipal).registeredService(registeredService).build();
        AuditableExecutionResult result = this.getConfigurationContext().getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        result.throwExceptionIfNeeded();
        return registeredService;
    }

    protected Service locateServiceForRequest(RequestContext context) throws Throwable {
        AuthenticationServiceSelectionPlan strategies = this.getConfigurationContext().getAuthenticationRequestServiceSelectionStrategies();
        WebApplicationService serviceFromFlow = WebUtils.getService((RequestContext)context);
        WebApplicationService serviceFromRequest = WebUtils.getService(this.getConfigurationContext().getArgumentExtractors(), (RequestContext)context);
        if (serviceFromFlow == null) {
            return strategies.resolveService((Service)serviceFromRequest);
        }
        if (serviceFromRequest != null) {
            serviceFromFlow.setFragment(serviceFromRequest.getFragment());
        }
        return strategies.resolveService((Service)serviceFromFlow);
    }
}

