/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer.acct;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.binding.expression.Expression;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.ExternalRedirectAction;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ViewFactory;

public class AccountProfileWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public AccountProfileWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry mainFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, mainFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(casProperties.getAuthn().getPm().getWebflow().getOrder());
    }

    @Override
    protected void doInitialize() {
        Flow accountFlow = this.buildFlow("account");
        accountFlow.getStartActionList().add((Action)this.createEvaluateAction("fetchTicketGrantingTicketAction"));
        ViewState myAccountView = this.createViewState(accountFlow, "myAccountProfile", "acct/casMyAccountProfile");
        myAccountView.getRenderActionList().add((Action)this.createEvaluateAction("prepareAccountProfileViewAction"));
        this.createTransitionForState((TransitionableState)myAccountView, "resetPassword", "passwordChangeRequest");
        this.createTransitionForState((TransitionableState)myAccountView, "updateSecurityQuestions", "updateSecurityQuestions");
        this.createTransitionForState((TransitionableState)myAccountView, "deleteSession", "removeSingleSignOnSession");
        this.createTransitionForState((TransitionableState)myAccountView, "revokeAccessToken", "oidcRevokeAccessToken");
        ActionState updateQuestions = this.createActionState(accountFlow, "updateSecurityQuestions", "accountProfileUpdateSecurityQuestionsAction");
        this.createTransitionForState((TransitionableState)updateQuestions, "success", "myAccountProfile");
        this.createTransitionForState((TransitionableState)updateQuestions, "error", "myAccountProfile");
        ActionState passwordChangeRequest = this.createActionState(accountFlow, "passwordChangeRequest", "accountProfilePasswordChangeRequestAction");
        this.createTransitionForState((TransitionableState)passwordChangeRequest, "success", "redirectToPasswordReset");
        this.createEndState(accountFlow, "redirectToPasswordReset", "requestScope.url", true);
        ActionState validate = this.createActionState(accountFlow, "ticketGrantingTicketCheck", "fetchTicketGrantingTicketAction", "ticketGrantingTicketCheckAction");
        this.createTransitionForState((TransitionableState)validate, "readFromBrowserStorage", "casBrowserStorageReadView");
        this.createTransitionForState((TransitionableState)validate, "valid", myAccountView.getId());
        this.createStateDefaultTransition((TransitionableState)validate, "redirectToLogin");
        Flow loginFlow = this.getLoginFlow();
        String serviceUrl = StringUtils.appendIfMissing((String)this.casProperties.getServer().getPrefix(), (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat(accountFlow.getId());
        ViewFactory view = this.createExternalRedirectViewFactory(String.format("'%s?%s=%s'", loginFlow.getId(), "service", serviceUrl));
        this.createEndState(accountFlow, "redirectToLogin", view);
        accountFlow.setStartState((State)validate);
        this.mainFlowDefinitionRegistry.registerFlowDefinition((FlowDefinition)accountFlow);
        ActionState removeSession = this.createActionState(accountFlow, "removeSingleSignOnSession", "accountProfileRemoveSingleSignOnSessionAction");
        this.createTransitionForState((TransitionableState)removeSession, "success", "myAccountProfile");
        this.createTransitionForState((TransitionableState)removeSession, "validate", accountFlow.getStartState().getId());
        EndState successView = this.getState(loginFlow, "viewGenericLoginSuccess", EndState.class);
        Expression expression = this.createExpression(String.format("'%s'", accountFlow.getId()));
        successView.getEntryActionList().add((Action)new ExternalRedirectAction(expression));
        ViewState readStorage = this.createViewState(accountFlow, "casBrowserStorageReadView", "storage/casBrowserStorageReadView");
        readStorage.getEntryActionList().add((Action)this.createEvaluateAction("readBrowserStorageAction"));
        this.createStateDefaultTransition((TransitionableState)readStorage, accountFlow.getStartState());
        ActionState revokeSession = this.createActionState(accountFlow, "oidcRevokeAccessToken", "accountProfileOidcRemoveAccessTokenAction");
        this.createTransitionForState((TransitionableState)revokeSession, "success", "myAccountProfile");
        this.createTransitionForState((TransitionableState)revokeSession, "error", accountFlow.getStartState().getId());
    }
}

