/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.storage;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.BrowserStorage;
import org.apereo.cas.web.DefaultBrowserStorage;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.actions.storage.BaseBrowserStorageAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WriteBrowserStorageAction
extends BaseBrowserStorageAction {
    public WriteBrowserStorageAction(CasCookieBuilder ticketGrantingCookieBuilder) {
        super(ticketGrantingCookieBuilder);
    }

    @Override
    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String ticketGrantingTicket = (String)requestContext.getCurrentEvent().getAttributes().get(TicketGrantingTicket.class.getName());
        Map payload = CollectionUtils.wrap((String)this.ticketGrantingCookieBuilder.getCookieName(), (Object)this.ticketGrantingCookieBuilder.getCasCookieValueManager().buildCookieValue(ticketGrantingTicket, request));
        BrowserStorage sessionStorage = DefaultBrowserStorage.builder().context(this.browserStorageContextKey).storageType(this.determineStorageType(requestContext)).build().setPayloadJson((Object)payload);
        WebUtils.putBrowserStorage((RequestContext)requestContext, (BrowserStorage)sessionStorage);
        return this.success(sessionStorage);
    }
}

