/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.utils;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.RealmMember;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.springframework.transaction.annotation.Transactional;

public class TemplateUtils {
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;

    public static void check(Map<String, AnyTO> templates, ClientExceptionType clientExceptionType) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)clientExceptionType);
        templates.values().forEach(value -> {
            value.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty() && !JexlUtils.isExpressionValid((String)((String)attrTO.getValues().get(0)))).forEachOrdered(attrTO -> sce.getElements().add("Invalid JEXL: " + (String)attrTO.getValues().get(0)));
            value.getVirAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty() && !JexlUtils.isExpressionValid((String)((String)attrTO.getValues().get(0)))).forEachOrdered(attrTO -> sce.getElements().add("Invalid JEXL: " + (String)attrTO.getValues().get(0)));
            AnyTO anyTO = value;
            Objects.requireNonNull(anyTO);
            AnyTO selector0$temp = anyTO;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UserTO.class, GroupTO.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    UserTO template = (UserTO)selector0$temp;
                    if (StringUtils.isNotBlank((CharSequence)template.getUsername()) && !JexlUtils.isExpressionValid((String)template.getUsername())) {
                        sce.getElements().add("Invalid JEXL: " + template.getUsername());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)template.getPassword()) || JexlUtils.isExpressionValid((String)template.getPassword())) break;
                    sce.getElements().add("Invalid JEXL: " + template.getPassword());
                    break;
                }
                case 1: {
                    GroupTO template = (GroupTO)selector0$temp;
                    if (!StringUtils.isNotBlank((CharSequence)template.getName()) || JexlUtils.isExpressionValid((String)template.getName())) break;
                    sce.getElements().add("Invalid JEXL: " + template.getName());
                    break;
                }
            }
        });
        if (!sce.isEmpty()) {
            throw sce;
        }
    }

    protected static Attr evaluateAttr(Attr template, MapContext jexlContext) {
        Attr result = new Attr();
        result.setSchema(template.getSchema());
        if (template.getValues() != null && !template.getValues().isEmpty()) {
            template.getValues().forEach(value -> {
                String evaluated = JexlUtils.evaluateExpr((String)value, (JexlContext)jexlContext).toString();
                if (StringUtils.isNotBlank((CharSequence)evaluated)) {
                    result.getValues().add(evaluated);
                }
            });
        }
        return result;
    }

    protected static void fill(RealmMember realmMember, RealmMember template) {
        Attr evaluated;
        String evaluated2;
        MapContext jexlContext = new MapContext();
        JexlUtils.addFieldsToContext((Object)realmMember, (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getDerAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getVirAttrs(), (JexlContext)jexlContext);
        if (template.getRealm() != null && StringUtils.isNotBlank((CharSequence)(evaluated2 = JexlUtils.evaluateExpr((String)template.getRealm(), (JexlContext)jexlContext).toString()))) {
            realmMember.setRealm(evaluated2);
        }
        Map currentAttrMap = EntityTOUtils.buildAttrMap((Collection)realmMember.getPlainAttrs());
        for (Attr templatePlainAttr : template.getPlainAttrs()) {
            if (templatePlainAttr.getValues().isEmpty() || currentAttrMap.containsKey(templatePlainAttr.getSchema()) && !((Attr)currentAttrMap.get(templatePlainAttr.getSchema())).getValues().isEmpty() || (evaluated = TemplateUtils.evaluateAttr(templatePlainAttr, jexlContext)).getValues().isEmpty()) continue;
            realmMember.getPlainAttrs().add(evaluated);
            jexlContext.set(evaluated.getSchema(), evaluated.getValues().get(0));
        }
        currentAttrMap = EntityTOUtils.buildAttrMap((Collection)realmMember.getDerAttrs());
        for (Attr templateDerAttr : template.getDerAttrs()) {
            if (currentAttrMap.containsKey(templateDerAttr.getSchema())) continue;
            realmMember.getDerAttrs().add(templateDerAttr);
        }
        currentAttrMap = EntityTOUtils.buildAttrMap((Collection)realmMember.getVirAttrs());
        for (Attr templateVirAttr : template.getVirAttrs()) {
            if (templateVirAttr.getValues().isEmpty() || currentAttrMap.containsKey(templateVirAttr.getSchema()) && !((Attr)currentAttrMap.get(templateVirAttr.getSchema())).getValues().isEmpty() || (evaluated = TemplateUtils.evaluateAttr(templateVirAttr, jexlContext)).getValues().isEmpty()) continue;
            realmMember.getVirAttrs().add(evaluated);
            jexlContext.set(evaluated.getSchema(), evaluated.getValues().get(0));
        }
        realmMember.getResources().addAll(template.getResources());
        realmMember.getAuxClasses().addAll(template.getAuxClasses());
    }

    protected static void fillRelationships(GroupableRelatableTO any, GroupableRelatableTO template) {
        template.getRelationships().stream().filter(relationship -> any.getRelationship(relationship.getOtherEndKey(), relationship.getOtherEndKey()).isEmpty()).forEachOrdered(relationship -> any.getRelationships().add(relationship));
    }

    protected static void fillMemberships(GroupableRelatableTO any, GroupableRelatableTO template) {
        template.getMemberships().stream().filter(membership -> any.getMembership(membership.getGroupKey()).isEmpty()).forEachOrdered(membership -> any.getMemberships().add(membership));
    }

    public TemplateUtils(UserDAO userDAO, GroupDAO groupDAO) {
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
    }

    @Transactional(readOnly=true)
    public void apply(RealmMember realmMember, AnyTO template) {
        TemplateUtils.fill(realmMember, (RealmMember)template);
        MapContext jexlContext = new MapContext();
        JexlUtils.addFieldsToContext((Object)realmMember, (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getDerAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrsToContext((Collection)realmMember.getVirAttrs(), (JexlContext)jexlContext);
        AnyTO anyTO = template;
        Objects.requireNonNull(anyTO);
        AnyTO anyTO2 = anyTO;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnyObjectTO.class, UserTO.class, GroupTO.class}, (Object)anyTO2, n)) {
            case 0: {
                AnyObjectTO anyObjectTO = (AnyObjectTO)anyTO2;
                TemplateUtils.fillRelationships((GroupableRelatableTO)realmMember, (GroupableRelatableTO)anyObjectTO);
                TemplateUtils.fillMemberships((GroupableRelatableTO)realmMember, (GroupableRelatableTO)anyObjectTO);
                break;
            }
            case 1: {
                UserCR urm;
                UserCR urm2;
                int n2;
                RealmMember realmMember2;
                String evaluated;
                UserTO userTO = (UserTO)anyTO2;
                if (StringUtils.isNotBlank((CharSequence)userTO.getUsername()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluateExpr((String)userTO.getUsername(), (JexlContext)jexlContext).toString()))) {
                    RealmMember realmMember3 = realmMember;
                    Objects.requireNonNull(realmMember3);
                    realmMember2 = realmMember3;
                    n2 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UserTO.class, UserCR.class}, (Object)realmMember2, n2)) {
                        case 0: {
                            urm2 = (UserTO)realmMember2;
                            urm2.setUsername(evaluated);
                            break;
                        }
                        case 1: {
                            urm = (UserCR)realmMember2;
                            urm.setUsername(evaluated);
                            break;
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)userTO.getPassword()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluateExpr((String)userTO.getPassword(), (JexlContext)jexlContext).toString()))) {
                    RealmMember realmMember4 = realmMember;
                    Objects.requireNonNull(realmMember4);
                    realmMember2 = realmMember4;
                    n2 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UserTO.class, UserCR.class}, (Object)realmMember2, n2)) {
                        case 0: {
                            urm2 = (UserTO)realmMember2;
                            urm2.setPassword(evaluated);
                            break;
                        }
                        case 1: {
                            urm = (UserCR)realmMember2;
                            urm.setPassword(evaluated);
                            break;
                        }
                    }
                }
                if (userTO.isMustChangePassword()) {
                    RealmMember realmMember5 = realmMember;
                    Objects.requireNonNull(realmMember5);
                    evaluated = realmMember5;
                    int n3 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UserTO.class, UserCR.class}, (Object)evaluated, n3)) {
                        case 0: {
                            UserTO urm3 = (UserTO)evaluated;
                            urm3.setMustChangePassword(true);
                            break;
                        }
                        case 1: {
                            urm2 = (UserCR)evaluated;
                            urm2.setMustChangePassword(true);
                            break;
                        }
                    }
                }
                TemplateUtils.fillRelationships((GroupableRelatableTO)realmMember, (GroupableRelatableTO)template);
                TemplateUtils.fillMemberships((GroupableRelatableTO)realmMember, (GroupableRelatableTO)template);
                userTO.getRoles().forEach(role -> {
                    UserCR urm;
                    UserTO urm2;
                    if (realmMember instanceof UserTO && !(urm2 = (UserTO)realmMember).getRoles().contains(role)) {
                        urm2.getRoles().add(role);
                    } else if (realmMember instanceof UserCR && !(urm = (UserCR)realmMember).getRoles().contains(role)) {
                        urm.getRoles().add(role);
                    }
                });
                userTO.getLinkedAccounts().forEach(account -> {
                    UserCR urm;
                    UserTO urm2;
                    if (realmMember instanceof UserTO && (urm2 = (UserTO)realmMember).getLinkedAccounts().stream().noneMatch(a -> Objects.equals(account.getConnObjectKeyValue(), a.getConnObjectKeyValue()) && Objects.equals(account.getResource(), a.getResource()))) {
                        urm2.getLinkedAccounts().add(account);
                    } else if (realmMember instanceof UserCR && (urm = (UserCR)realmMember).getLinkedAccounts().stream().noneMatch(a -> Objects.equals(account.getConnObjectKeyValue(), a.getConnObjectKeyValue()) && Objects.equals(account.getResource(), a.getResource()))) {
                        urm.getLinkedAccounts().add(account);
                    }
                });
                break;
            }
            case 2: {
                String evaluated;
                GroupTO groupTO = (GroupTO)anyTO2;
                if (StringUtils.isNotBlank((CharSequence)groupTO.getName()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluateExpr((String)groupTO.getName(), (JexlContext)jexlContext).toString()))) {
                    RealmMember realmMember6 = realmMember;
                    Objects.requireNonNull(realmMember6);
                    RealmMember realmMember7 = realmMember6;
                    int n4 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupTO.class, GroupCR.class}, (Object)realmMember7, n4)) {
                        case 0: {
                            GroupTO grm = (GroupTO)realmMember7;
                            grm.setName(evaluated);
                            break;
                        }
                        case 1: {
                            GroupCR grm = (GroupCR)realmMember7;
                            grm.setName(evaluated);
                            break;
                        }
                    }
                }
                Optional.ofNullable(groupTO.getUserOwner()).flatMap(arg_0 -> ((UserDAO)this.userDAO).findById(arg_0)).ifPresent(userOwner -> {
                    RealmMember realmMember2 = realmMember;
                    Objects.requireNonNull(realmMember2);
                    RealmMember selector0$temp = realmMember2;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupTO.class, GroupCR.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            GroupTO grm = (GroupTO)selector0$temp;
                            grm.setUserOwner(userOwner.getKey());
                            break;
                        }
                        case 1: {
                            GroupCR grm = (GroupCR)selector0$temp;
                            grm.setUserOwner(userOwner.getKey());
                            break;
                        }
                    }
                });
                Optional.ofNullable(groupTO.getGroupOwner()).flatMap(arg_0 -> ((GroupDAO)this.groupDAO).findById(arg_0)).ifPresent(groupOwner -> {
                    RealmMember realmMember2 = realmMember;
                    Objects.requireNonNull(realmMember2);
                    RealmMember selector0$temp = realmMember2;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupTO.class, GroupCR.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            GroupTO grm = (GroupTO)selector0$temp;
                            grm.setGroupOwner(groupOwner.getKey());
                            break;
                        }
                        case 1: {
                            GroupCR grm = (GroupCR)selector0$temp;
                            grm.setGroupOwner(groupOwner.getKey());
                            break;
                        }
                    }
                });
                Optional.ofNullable(groupTO.getUDynMembershipCond()).ifPresent(udynMembershipCond -> {
                    RealmMember realmMember2 = realmMember;
                    Objects.requireNonNull(realmMember2);
                    RealmMember selector0$temp = realmMember2;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupTO.class, GroupCR.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            GroupTO grm = (GroupTO)selector0$temp;
                            grm.setUDynMembershipCond(udynMembershipCond);
                            break;
                        }
                        case 1: {
                            GroupCR grm = (GroupCR)selector0$temp;
                            grm.setUDynMembershipCond(udynMembershipCond);
                            break;
                        }
                    }
                });
                groupTO.getADynMembershipConds().forEach((anyType, cond) -> {
                    GroupCR grm;
                    GroupTO grm2;
                    if (realmMember instanceof GroupTO && (grm2 = (GroupTO)realmMember).getADynMembershipConds().containsKey(anyType)) {
                        grm2.getADynMembershipConds().put(anyType, cond);
                    } else if (realmMember instanceof GroupCR && !(grm = (GroupCR)realmMember).getADynMembershipConds().containsKey(anyType)) {
                        grm.getADynMembershipConds().put(anyType, cond);
                    }
                });
                groupTO.getTypeExtensions().forEach(typeExt -> {
                    GroupCR grm;
                    GroupTO grm2;
                    if (realmMember instanceof GroupTO && !(grm2 = (GroupTO)realmMember).getTypeExtensions().contains(typeExt)) {
                        grm2.getTypeExtensions().add(typeExt);
                    } else if (realmMember instanceof GroupCR && !(grm = (GroupCR)realmMember).getTypeExtensions().contains(typeExt)) {
                        grm.getTypeExtensions().add(typeExt);
                    }
                });
                break;
            }
        }
    }
}

