/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull.stream;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Mapping;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.policy.InboundCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.policy.InboundPolicy;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PullResultHandlerDispatcher;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class StreamPullJobDelegate
extends PullJobDelegate
implements SyncopeStreamPullExecutor {
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private RealmSearchDAO realmSearchDAO;

    private InboundPolicy inboundPolicy(AnyType anyType, ConflictResolutionAction conflictResolutionAction, String inboundCorrelationRule) {
        InboundCorrelationRuleEntity inboundCorrelationRuleEntity = null;
        if (inboundCorrelationRule != null) {
            Implementation impl = this.implementationDAO.findById(inboundCorrelationRule).orElse(null);
            if (impl == null || !"INBOUND_CORRELATION_RULE".equals(impl.getType())) {
                LOG.debug("Invalid  {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), (Object)inboundCorrelationRule);
            } else {
                inboundCorrelationRuleEntity = (InboundCorrelationRuleEntity)this.entityFactory.newEntity(InboundCorrelationRuleEntity.class);
                inboundCorrelationRuleEntity.setAnyType(anyType);
                inboundCorrelationRuleEntity.setImplementation(impl);
            }
        }
        InboundPolicy inboundPolicy = (InboundPolicy)this.entityFactory.newEntity(InboundPolicy.class);
        inboundPolicy.setConflictResolutionAction(conflictResolutionAction);
        if (inboundCorrelationRuleEntity != null) {
            inboundPolicy.add(inboundCorrelationRuleEntity);
            inboundCorrelationRuleEntity.setInboundPolicy(inboundPolicy);
        }
        return inboundPolicy;
    }

    private Provision provision(AnyType anyType, String keyColumn, List<String> columns) throws JobExecutionException {
        Provision provision = new Provision();
        provision.setAnyType(anyType.getKey());
        provision.setObjectClass(anyType.getKey());
        Mapping mapping = new Mapping();
        provision.setMapping(mapping);
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
        if (anyUtils.getField(keyColumn).isEmpty()) {
            this.plainSchemaDAO.findById(keyColumn).orElseThrow(() -> new JobExecutionException("Plain Schema for key column not found: " + keyColumn));
        }
        Item connObjectKeyItem = new Item();
        connObjectKeyItem.setExtAttrName(keyColumn);
        connObjectKeyItem.setIntAttrName(keyColumn);
        connObjectKeyItem.setPurpose(MappingPurpose.PULL);
        mapping.setConnObjectKeyItem(connObjectKeyItem);
        columns.stream().filter(column -> anyUtils.getField(column).isPresent() || this.plainSchemaDAO.existsById(column) || this.virSchemaDAO.existsById(column)).map(column -> {
            Item item = new Item();
            item.setExtAttrName(column);
            item.setIntAttrName(column);
            item.setPurpose(MappingPurpose.PULL);
            mapping.add(item);
            return item;
        }).forEach(arg_0 -> ((Mapping)mapping).add(arg_0));
        return provision;
    }

    private ExternalResource externalResource(AnyType anyType, String keyColumn, List<String> columns, ConflictResolutionAction conflictResolutionAction, String inboundCorrelationRule) throws JobExecutionException {
        Provision provision = this.provision(anyType, keyColumn, columns);
        ExternalResource resource = (ExternalResource)this.entityFactory.newEntity(ExternalResource.class);
        resource.setKey("StreamPull_" + SecureRandomUtils.generateRandomUUID().toString());
        resource.getProvisions().add(provision);
        resource.setInboundPolicy(this.inboundPolicy(anyType, conflictResolutionAction, inboundCorrelationRule));
        return resource;
    }

    public List<ProvisioningReport> pull(AnyType anyType, String keyColumn, List<String> columns, ConflictResolutionAction conflictResolutionAction, String inboundCorrelationRule, Connector connector, PullTaskTO pullTaskTO, String executor) throws JobExecutionException {
        LOG.debug("Executing stream pull");
        this.taskType = TaskType.PULL;
        try {
            ExternalResource resource = this.externalResource(anyType, keyColumn, columns, conflictResolutionAction, inboundCorrelationRule);
            Provision provision = (Provision)resource.getProvisions().get(0);
            this.task = (SchedTask)this.entityFactory.newEntity(PullTask.class);
            ((PullTask)this.task).setName(pullTaskTO.getName());
            ((PullTask)this.task).setResource(resource);
            ((PullTask)this.task).setMatchingRule(pullTaskTO.getMatchingRule());
            ((PullTask)this.task).setUnmatchingRule(pullTaskTO.getUnmatchingRule());
            ((PullTask)this.task).setPullMode(PullMode.FULL_RECONCILIATION);
            ((PullTask)this.task).setPerformCreate(true);
            ((PullTask)this.task).setPerformUpdate(true);
            ((PullTask)this.task).setPerformDelete(false);
            ((PullTask)this.task).setSyncStatus(false);
            ((PullTask)this.task).setDestinationRealm((Realm)this.realmSearchDAO.findByFullPath(pullTaskTO.getDestinationRealm()).orElseThrow(() -> new NotFoundException("Realm " + pullTaskTO.getDestinationRealm())));
            ((PullTask)this.task).setRemediation(pullTaskTO.isRemediation());
            this.profile = new ProvisioningProfile(connector, this.taskType, (ProvisioningTask)((PullTask)this.task), conflictResolutionAction, this.getInboundActions(pullTaskTO.getActions().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).findById(arg_0)).flatMap(Optional::stream).toList()), executor, false);
            this.dispatcher = new PullResultHandlerDispatcher((ProvisioningProfile<PullTask, InboundActions>)this.profile, this);
            for (InboundActions action : this.profile.getActions()) {
                action.beforeAll(this.profile);
            }
            GroupPullResultHandler ghandler = this.buildGroupHandler();
            this.dispatcher.addHandlerSupplier(provision.getObjectClass(), () -> {
                GroupPullResultHandler handler = switch (anyType.getKind()) {
                    case AnyTypeKind.USER -> this.buildUserHandler();
                    case AnyTypeKind.GROUP -> ghandler;
                    default -> this.buildAnyObjectHandler();
                };
                handler.setProfile(this.profile);
                return handler;
            });
            HashSet moreAttrsToGet = new HashSet();
            this.profile.getActions().forEach(a -> moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, provision)));
            Stream<Item> mapItems = Stream.concat(MappingUtils.getInboundItems(provision.getMapping().getItems().stream()), this.virSchemaDAO.findByResourceAndAnyType(resource.getKey(), anyType.getKey()).stream().map(VirSchema::asLinkingMappingItem));
            connector.fullReconciliation(new ObjectClass(provision.getObjectClass()), (SyncResultsHandler)this.dispatcher, MappingUtils.buildOperationOptions(mapItems, (String[])moreAttrsToGet.toArray(String[]::new)));
            try {
                StreamPullJobDelegate.setGroupOwners(ghandler, this.groupDAO, this.anyTypeDAO, this.inboundMatcher, (ProvisioningProfile<PullTask, InboundActions>)this.profile);
            }
            catch (Exception e) {
                LOG.error("While setting group owners", (Throwable)e);
            }
            for (InboundActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While stream pulling", (Throwable)e);
        }
    }
}

