/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull.stream;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.rest.api.beans.CSVPullSpec;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.provisioning.api.Connector;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.LiveSyncResultsHandler;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CSVStreamConnector
implements Connector,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CSVStreamConnector.class);
    private final String keyColumn;
    private final String arrayElementsSeparator;
    private final CsvSchema.Builder schemaBuilder;
    private final InputStream in;
    private final OutputStream out;
    private final List<String> columns;
    private MappingIterator<Map<String, String>> reader;
    private SequenceWriter writer;

    public CSVStreamConnector(String keyColumn, String arrayElementsSeparator, CsvSchema.Builder schemaBuilder, InputStream in, OutputStream out, String ... columns) {
        this.keyColumn = keyColumn;
        this.arrayElementsSeparator = arrayElementsSeparator;
        this.schemaBuilder = schemaBuilder;
        this.in = in;
        this.out = out;
        this.columns = List.of(columns);
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingIterator<Map<String, String>> reader() throws IOException {
        CSVStreamConnector cSVStreamConnector = this;
        synchronized (cSVStreamConnector) {
            if (this.reader == null) {
                this.reader = new CsvMapper().enable(CsvParser.Feature.SKIP_EMPTY_LINES).readerFor(Map.class).with((FormatSchema)this.schemaBuilder.build()).readValues(this.in);
            }
        }
        return this.reader;
    }

    public List<String> getColumns(CSVPullSpec spec) throws IOException {
        ArrayList<String> fromSpec = new ArrayList<String>();
        ((CsvSchema)this.reader().getParserSchema()).forEach(column -> {
            if (!spec.getIgnoreColumns().contains(column.getName())) {
                fromSpec.add(column.getName());
            }
        });
        return fromSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceWriter writer() throws IOException {
        CSVStreamConnector cSVStreamConnector = this;
        synchronized (cSVStreamConnector) {
            if (this.writer == null) {
                this.writer = new CsvMapper().writerFor(Map.class).with((FormatSchema)this.schemaBuilder.build()).writeValues(this.out);
            }
        }
        return this.writer;
    }

    public Uid authenticate(String username, String password, OperationOptions options) {
        return null;
    }

    public ConnInstance getConnInstance() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uid create(ObjectClass objectClass, Set<Attribute> attrs, OperationOptions options, AtomicReference<Boolean> propagationAttempted) {
        CsvSchema.Builder builder = this.schemaBuilder;
        synchronized (builder) {
            if (this.schemaBuilder.size() == 0) {
                attrs.stream().filter(attr -> !AttributeUtil.isSpecial((Attribute)attr)).map(Attribute::getName).sorted((c1, c2) -> {
                    int index2;
                    int index1 = this.columns.indexOf(c1);
                    if (index1 == -1) {
                        index1 = Integer.MAX_VALUE;
                    }
                    if ((index2 = this.columns.indexOf(c2)) == -1) {
                        index2 = Integer.MAX_VALUE;
                    }
                    return Integer.compare(index1, index2);
                }).forEachOrdered(arg_0 -> ((CsvSchema.Builder)this.schemaBuilder).addColumn(arg_0));
            }
        }
        LinkedHashMap row = new LinkedHashMap();
        attrs.stream().filter(attr -> !AttributeUtil.isSpecial((Attribute)attr)).forEach(attr -> {
            if (CollectionUtils.isEmpty((Collection)attr.getValue()) || attr.getValue().get(0) == null) {
                row.put(attr.getName(), null);
            } else if (attr.getValue().size() == 1) {
                row.put(attr.getName(), attr.getValue().get(0).toString());
            } else if (this.arrayElementsSeparator == null) {
                row.put(attr.getName(), attr.getValue().toString());
            } else {
                row.put(attr.getName(), attr.getValue().stream().map(Object::toString).collect(Collectors.joining(this.arrayElementsSeparator)));
            }
        });
        try {
            this.writer().write(row);
        }
        catch (IOException e) {
            throw new ConnectorException("Could not write object " + String.valueOf(row), (Throwable)e);
        }
        propagationAttempted.set(Boolean.TRUE);
        return null;
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> attrs, OperationOptions options, AtomicReference<Boolean> propagationAttempted) {
        return null;
    }

    public Set<AttributeDelta> updateDelta(ObjectClass objectClass, Uid uid, Set<AttributeDelta> modifications, OperationOptions options, AtomicReference<Boolean> propagationAttempted) {
        return Set.of();
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options, AtomicReference<Boolean> propagationAttempted) {
    }

    public void sync(ObjectClass objectClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    public SyncToken getLatestSyncToken(ObjectClass objectClass) {
        throw new UnsupportedOperationException();
    }

    public void livesync(ObjectClass objectClass, LiveSyncResultsHandler handler, OperationOptions options) {
        throw new UnsupportedOperationException();
    }

    public ConnectorObject getObject(ObjectClass objectClass, Attribute connObjectKey, boolean ignoreCaseMatch, OperationOptions options) {
        return null;
    }

    public SearchResult search(ObjectClass objectClass, Filter filter, SearchResultsHandler handler, OperationOptions options) {
        SearchResult result = new SearchResult();
        try {
            int record = 1;
            while (this.reader().hasNext()) {
                Map row = (Map)this.reader().next();
                Object keyValue = (String)row.get(this.keyColumn);
                if (StringUtils.isBlank((CharSequence)keyValue)) {
                    keyValue = "Record " + record;
                }
                ConnectorObjectBuilder builder = new ConnectorObjectBuilder().setObjectClass(objectClass).setUid((String)keyValue).setName((String)keyValue);
                row.forEach((key, value) -> builder.addAttribute(new Attribute[]{this.arrayElementsSeparator == null ? AttributeBuilder.build((String)key, (Object[])new Object[]{value}) : AttributeBuilder.build((String)key, (Object[])StringUtils.splitByWholeSeparator((String)value, (String)this.arrayElementsSeparator))}));
                ConnectorObject obj = builder.build();
                if (filter == null || filter.accept(obj)) {
                    handler.handle(obj);
                } else {
                    LOG.debug("Found but not passing the provided filter {}: {}", (Object)filter, (Object)obj);
                }
                ++record;
            }
        }
        catch (IOException e) {
            LOG.error("Could not read CSV from provided stream", (Throwable)e);
            throw new ConnectorException((Throwable)e);
        }
        return result;
    }

    public Set<ObjectClassInfo> getObjectClassInfo() {
        return Set.of();
    }

    public void validate() {
    }

    public void test() {
    }

    public void dispose() {
    }
}

