/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.policy.ProvisioningPolicy;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.job.StoppableSchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.UserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultAnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultGroupPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultRealmPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultUserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.PullResultHandlerDispatcher;
import org.apache.syncope.core.provisioning.java.pushpull.SyncopeResultHandlerDispatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.springframework.beans.factory.annotation.Autowired;

public class PullJobDelegate
extends AbstractProvisioningJobDelegate<PullTask>
implements SyncopePullExecutor,
StoppableSchedTaskJobDelegate {
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected PlainSchemaDAO plainSchemaDAO;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected PlainAttrValidationManager validator;
    protected final Map<String, SyncToken> latestSyncTokens = Collections.synchronizedMap(new HashMap());
    protected ProvisioningProfile<PullTask, InboundActions> profile;
    protected final Map<String, MutablePair<Integer, String>> handled = new HashMap<String, MutablePair<Integer, String>>();
    protected final Map<String, InboundActions> perContextActions = new ConcurrentHashMap<String, InboundActions>();
    protected Optional<ReconFilterBuilder> perContextReconFilterBuilder = Optional.empty();
    protected PullResultHandlerDispatcher dispatcher;

    public static void setGroupOwners(GroupPullResultHandler ghandler, GroupDAO groupDAO, AnyTypeDAO anyTypeDAO, InboundMatcher inboundMatcher, ProvisioningProfile<PullTask, InboundActions> profile) {
        ghandler.getGroupOwnerMap().forEach((groupKey, ownerKey) -> {
            Group group = (Group)groupDAO.findById(groupKey).orElseThrow(() -> new NotFoundException("Group " + groupKey));
            if (StringUtils.isBlank((CharSequence)ownerKey)) {
                group.setGroupOwner(null);
                group.setUserOwner(null);
            } else {
                inboundMatcher.match(anyTypeDAO.getUser(), (String)ownerKey, ((PullTask)profile.getTask()).getResource(), profile.getConnector()).ifPresentOrElse(userMatch -> group.setUserOwner((User)userMatch.getAny()), () -> inboundMatcher.match(anyTypeDAO.getGroup(), (String)ownerKey, ((PullTask)profile.getTask()).getResource(), profile.getConnector()).ifPresent(groupMatch -> group.setGroupOwner((Group)groupMatch.getAny())));
            }
            groupDAO.save((Entity)group);
        });
    }

    public void setLatestSyncToken(String objectClass, SyncToken latestSyncToken) {
        this.latestSyncTokens.put(objectClass, latestSyncToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportHandled(String objectClass, Name name) {
        Map<String, MutablePair<Integer, String>> map = this.handled;
        synchronized (map) {
            MutablePair pair = Optional.ofNullable(this.handled.get(objectClass)).orElseGet(() -> {
                MutablePair p = MutablePair.of((Object)0, null);
                this.handled.put(objectClass, (MutablePair<Integer, String>)p);
                return p;
            });
            pair.setLeft((Object)((Integer)pair.getLeft() + 1));
            pair.setRight((Object)name.getNameValue());
            if (!this.handled.isEmpty()) {
                StringBuilder builder = new StringBuilder("Processed:\n");
                this.handled.forEach((k, v) -> builder.append(' ').append(v.getLeft()).append('\t').append((String)k).append(" / latest: ").append((String)v.getRight()).append('\n'));
                this.setStatus(builder.toString());
            }
        }
    }

    protected List<InboundActions> getInboundActions(List<? extends Implementation> impls) {
        ArrayList<InboundActions> result = new ArrayList<InboundActions>();
        impls.forEach(impl -> {
            try {
                result.add((InboundActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (InboundActions)instance)));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    protected ReconFilterBuilder getReconFilterBuilder(PullTask task) throws ClassNotFoundException {
        return (ReconFilterBuilder)ImplementationManager.build((Implementation)task.getReconFilterBuilder(), () -> this.perContextReconFilterBuilder.orElse(null), instance -> {
            this.perContextReconFilterBuilder = Optional.of(instance);
        });
    }

    protected RealmPullResultHandler buildRealmHandler() {
        return (RealmPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultRealmPullResultHandler.class);
    }

    protected AnyObjectPullResultHandler buildAnyObjectHandler() {
        return (AnyObjectPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultAnyObjectPullResultHandler.class);
    }

    protected UserPullResultHandler buildUserHandler() {
        return (UserPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultUserPullResultHandler.class);
    }

    protected GroupPullResultHandler buildGroupHandler() {
        return (GroupPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultGroupPullResultHandler.class);
    }

    @Override
    protected void init(TaskType taskType, String taskKey, JobExecutionContext context) throws JobExecutionException {
        super.init(taskType, taskKey, context);
        this.profile = new ProvisioningProfile(this.connector, taskType, (ProvisioningTask)((PullTask)this.task), Optional.ofNullable(((PullTask)this.task).getResource().getInboundPolicy()).map(ProvisioningPolicy::getConflictResolutionAction).orElse(ConflictResolutionAction.IGNORE), this.getInboundActions(((PullTask)this.task).getActions()), this.executor, context.isDryRun());
        this.latestSyncTokens.clear();
    }

    public void stop() {
        Optional.ofNullable(this.dispatcher).ifPresent(SyncopeResultHandlerDispatcher::stop);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected String doExecute(JobExecutionContext context) throws JobExecutionException {
        PullJobDelegate.LOG.debug("Executing pull on {}", (Object)((PullTask)this.task).getResource());
        this.dispatcher = new PullResultHandlerDispatcher(this.profile, this);
        this.latestSyncTokens.clear();
        if (!this.profile.isDryRun()) {
            for (InboundActions action : this.profile.getActions()) {
                action.beforeAll(this.profile);
            }
        }
        if (((PullTask)this.task).getResource().getOrgUnit() != null) {
            this.setStatus("Pulling " + ((PullTask)this.task).getResource().getOrgUnit().getObjectClass());
            orgUnit = ((PullTask)this.task).getResource().getOrgUnit();
            moreAttrsToGet = new HashSet<E>();
            this.profile.getActions().forEach((Consumer<InboundActions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doExecute$12(java.util.Set org.apache.syncope.common.lib.to.OrgUnit org.apache.syncope.core.provisioning.api.pushpull.InboundActions ), (Lorg/apache/syncope/core/provisioning/api/pushpull/InboundActions;)V)((PullJobDelegate)this, moreAttrsToGet, (OrgUnit)orgUnit));
            options = MappingUtils.buildOperationOptions(MappingUtils.getInboundItems(orgUnit.getItems().stream()), (String[])moreAttrsToGet.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doExecute$13(int ), (I)[Ljava/lang/String;)()));
            this.dispatcher.addHandlerSupplier(orgUnit.getObjectClass(), (Supplier<SyncopePullResultHandler>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doExecute$14(), ()Lorg/apache/syncope/core/provisioning/api/pushpull/SyncopePullResultHandler;)((PullJobDelegate)this));
            try {
                switch (1.$SwitchMap$org$apache$syncope$common$lib$types$PullMode[((PullTask)this.task).getPullMode().ordinal()]) {
                    case 1: {
                        if (!context.isDryRun()) {
                            this.latestSyncTokens.put(orgUnit.getObjectClass(), ConnObjectUtils.toSyncToken(orgUnit.getSyncToken()));
                        }
                        this.connector.sync(new ObjectClass(orgUnit.getObjectClass()), ConnObjectUtils.toSyncToken(orgUnit.getSyncToken()), (SyncResultsHandler)this.dispatcher, options);
                        if (!context.isDryRun()) {
                            orgUnit.setSyncToken(ConnObjectUtils.toString(this.latestSyncTokens.get(orgUnit.getObjectClass())));
                            this.resourceDAO.save((Entity)((PullTask)this.task).getResource());
                        }
                        break;
                    }
                    case 2: {
                        this.connector.filteredReconciliation(new ObjectClass(orgUnit.getObjectClass()), this.getReconFilterBuilder((PullTask)this.task), (SyncResultsHandler)this.dispatcher, options);
                        break;
                    }
                    default: {
                        this.connector.fullReconciliation(new ObjectClass(orgUnit.getObjectClass()), (SyncResultsHandler)this.dispatcher, options);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                throw new JobExecutionException("While pulling from connector", t);
            }
        }
        provisionSorter = this.getProvisionSorter((PullTask)this.task);
        ghandler = this.buildGroupHandler();
lbl40:
        // 7 sources

        block20: for (Provision provision : ((PullTask)this.task).getResource().getProvisions().stream().filter((Predicate<Provision>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doExecute$15(org.apache.syncope.common.lib.to.Provision ), (Lorg/apache/syncope/common/lib/to/Provision;)Z)()).sorted((Comparator<Provision>)provisionSorter).toList()) {
            this.setStatus("Pulling " + provision.getObjectClass());
            anyType = (AnyType)this.anyTypeDAO.findById(provision.getAnyType()).orElseThrow((Supplier<NotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doExecute$16(org.apache.syncope.common.lib.to.Provision ), ()Lorg/apache/syncope/core/persistence/api/dao/NotFoundException;)((Provision)provision));
            this.dispatcher.addHandlerSupplier(provision.getObjectClass(), (Supplier<SyncopePullResultHandler>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doExecute$17(org.apache.syncope.core.persistence.api.entity.AnyType org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler ), ()Lorg/apache/syncope/core/provisioning/api/pushpull/SyncopePullResultHandler;)((PullJobDelegate)this, (AnyType)anyType, (GroupPullResultHandler)ghandler));
            setSyncTokens = false;
            try {
                moreAttrsToGet = new HashSet<E>();
                this.profile.getActions().forEach((Consumer<InboundActions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doExecute$18(java.util.Set org.apache.syncope.common.lib.to.Provision org.apache.syncope.core.provisioning.api.pushpull.InboundActions ), (Lorg/apache/syncope/core/provisioning/api/pushpull/InboundActions;)V)((PullJobDelegate)this, moreAttrsToGet, (Provision)provision));
                mapItems = Stream.concat(MappingUtils.getInboundItems(provision.getMapping().getItems().stream()), this.virSchemaDAO.findByResourceAndAnyType(((PullTask)this.task).getResource().getKey(), anyType.getKey()).stream().map((Function<VirSchema, Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, asLinkingMappingItem(), (Lorg/apache/syncope/core/persistence/api/entity/VirSchema;)Lorg/apache/syncope/common/lib/to/Item;)()));
                options = MappingUtils.buildOperationOptions(mapItems, (String[])moreAttrsToGet.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doExecute$19(int ), (I)[Ljava/lang/String;)()));
                switch (1.$SwitchMap$org$apache$syncope$common$lib$types$PullMode[((PullTask)this.task).getPullMode().ordinal()]) {
                    case 1: {
                        if (!context.isDryRun()) {
                            this.latestSyncTokens.put(provision.getObjectClass(), ConnObjectUtils.toSyncToken(provision.getSyncToken()));
                        }
                        this.connector.sync(new ObjectClass(provision.getObjectClass()), ConnObjectUtils.toSyncToken(provision.getSyncToken()), (SyncResultsHandler)this.dispatcher, options);
                        if (context.isDryRun()) continue block20;
                        setSyncTokens = true;
                        ** break;
                    }
                    case 2: {
                        this.connector.filteredReconciliation(new ObjectClass(provision.getObjectClass()), this.getReconFilterBuilder((PullTask)this.task), (SyncResultsHandler)this.dispatcher, options);
                        ** break;
                    }
                    default: {
                        this.connector.fullReconciliation(new ObjectClass(provision.getObjectClass()), (SyncResultsHandler)this.dispatcher, options);
                        continue block20;
                    }
                }
            }
            catch (Throwable t) {
                throw new JobExecutionException("While pulling from connector", t);
            }
            finally {
                if (!setSyncTokens) continue;
                this.latestSyncTokens.forEach((BiConsumer<String, SyncToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$doExecute$21(java.lang.String org.identityconnectors.framework.common.objects.SyncToken ), (Ljava/lang/String;Lorg/identityconnectors/framework/common/objects/SyncToken;)V)((PullJobDelegate)this));
                this.resourceDAO.save((Entity)((PullTask)this.task).getResource());
            }
        }
        this.dispatcher.shutdown();
        for (Provision provision : ((PullTask)this.task).getResource().getProvisions().stream().filter((Predicate<Provision>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doExecute$22(org.apache.syncope.common.lib.to.Provision ), (Lorg/apache/syncope/common/lib/to/Provision;)Z)()).sorted((Comparator<Provision>)provisionSorter).toList()) {
            try {
                anyType = (AnyType)this.anyTypeDAO.findById(provision.getAnyType()).orElseThrow((Supplier<NotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doExecute$23(org.apache.syncope.common.lib.to.Provision ), ()Lorg/apache/syncope/core/persistence/api/dao/NotFoundException;)((Provision)provision));
                anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
                this.profile.getResults().stream().filter((Predicate<ProvisioningReport>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doExecute$24(org.apache.syncope.common.lib.to.Provision org.apache.syncope.common.lib.to.ProvisioningReport ), (Lorg/apache/syncope/common/lib/to/ProvisioningReport;)Z)((Provision)provision)).forEach((Consumer<ProvisioningReport>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doExecute$26(org.apache.syncope.core.persistence.api.entity.AnyUtils org.apache.syncope.common.lib.to.Provision org.apache.syncope.common.lib.to.ProvisioningReport ), (Lorg/apache/syncope/common/lib/to/ProvisioningReport;)V)((PullJobDelegate)this, (AnyUtils)anyUtils, (Provision)provision));
            }
            catch (Throwable t) {
                PullJobDelegate.LOG.error("While setting UID on create", t);
            }
        }
        try {
            PullJobDelegate.setGroupOwners(ghandler, this.groupDAO, this.anyTypeDAO, this.inboundMatcher, this.profile);
        }
        catch (Exception e) {
            PullJobDelegate.LOG.error("While setting group owners", (Throwable)e);
        }
        if (!this.profile.isDryRun()) {
            for (InboundActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
        }
        this.setStatus("Pull done");
        result = this.createReport(this.profile.getResults(), ((PullTask)this.task).getResource(), context.isDryRun());
        PullJobDelegate.LOG.debug("Pull result: {}", (Object)result);
        return result;
    }

    private /* synthetic */ void lambda$doExecute$26(AnyUtils anyUtils, Provision provision, ProvisioningReport result) {
        anyUtils.addAttr(this.validator, result.getKey(), (PlainSchema)this.plainSchemaDAO.findById(provision.getUidOnCreate()).orElseThrow(() -> new NotFoundException("PlainSchema " + provision.getUidOnCreate())), result.getUidValue());
    }

    private static /* synthetic */ boolean lambda$doExecute$24(Provision provision, ProvisioningReport result) {
        return result.getUidValue() != null && result.getKey() != null && result.getOperation() == ResourceOperation.CREATE && result.getAnyType().equals(provision.getAnyType());
    }

    private static /* synthetic */ NotFoundException lambda$doExecute$23(Provision provision) {
        return new NotFoundException("AnyType" + provision.getAnyType());
    }

    private static /* synthetic */ boolean lambda$doExecute$22(Provision provision) {
        return provision.getMapping() != null && provision.getUidOnCreate() != null;
    }

    private /* synthetic */ void lambda$doExecute$21(String objectClass, SyncToken syncToken) {
        ((PullTask)this.task).getResource().getProvisionByObjectClass(objectClass).ifPresent(p -> p.setSyncToken(ConnObjectUtils.toString(syncToken)));
    }

    private static /* synthetic */ String[] lambda$doExecute$19(int x$0) {
        return new String[x$0];
    }

    private /* synthetic */ void lambda$doExecute$18(Set moreAttrsToGet, Provision provision, InboundActions a) {
        moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, provision));
    }

    private /* synthetic */ SyncopePullResultHandler lambda$doExecute$17(AnyType anyType, GroupPullResultHandler ghandler) {
        GroupPullResultHandler handler = switch (anyType.getKind()) {
            case AnyTypeKind.USER -> this.buildUserHandler();
            case AnyTypeKind.GROUP -> ghandler;
            default -> this.buildAnyObjectHandler();
        };
        handler.setProfile(this.profile);
        return handler;
    }

    private static /* synthetic */ NotFoundException lambda$doExecute$16(Provision provision) {
        return new NotFoundException("AnyType" + provision.getAnyType());
    }

    private static /* synthetic */ boolean lambda$doExecute$15(Provision provision) {
        return provision.getMapping() != null;
    }

    private /* synthetic */ SyncopePullResultHandler lambda$doExecute$14() {
        RealmPullResultHandler handler = this.buildRealmHandler();
        handler.setProfile(this.profile);
        return handler;
    }

    private static /* synthetic */ String[] lambda$doExecute$13(int x$0) {
        return new String[x$0];
    }

    private /* synthetic */ void lambda$doExecute$12(Set moreAttrsToGet, OrgUnit orgUnit, InboundActions a) {
        moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, orgUnit));
    }
}

