/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.policy.PushCorrelationRuleEntity;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.api.rules.PushCorrelationRule;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class OutboundMatcher {
    protected static final Logger LOG = LoggerFactory.getLogger(OutboundMatcher.class);
    protected final MappingManager mappingManager;
    protected final UserDAO userDAO;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final VirSchemaDAO virSchemaDAO;
    protected final VirAttrHandler virAttrHandler;
    protected final Map<String, PropagationActions> perContextActions = new ConcurrentHashMap<String, PropagationActions>();
    protected final Map<String, PushCorrelationRule> perContextPushCorrelationRules = new ConcurrentHashMap<String, PushCorrelationRule>();

    public OutboundMatcher(MappingManager mappingManager, UserDAO userDAO, AnyUtilsFactory anyUtilsFactory, VirSchemaDAO virSchemaDAO, VirAttrHandler virAttrHandler) {
        this.mappingManager = mappingManager;
        this.userDAO = userDAO;
        this.anyUtilsFactory = anyUtilsFactory;
        this.virSchemaDAO = virSchemaDAO;
        this.virAttrHandler = virAttrHandler;
    }

    protected Optional<PushCorrelationRule> rule(ExternalResource resource, Provision provision) {
        Optional correlationRule = resource.getPushPolicy() == null ? Optional.empty() : resource.getPushPolicy().getCorrelationRule(provision.getAnyType());
        Optional rule = Optional.empty();
        if (correlationRule.isPresent()) {
            Implementation impl = ((PushCorrelationRuleEntity)correlationRule.get()).getImplementation();
            try {
                rule = ImplementationManager.buildPushCorrelationRule((Implementation)impl, () -> this.perContextPushCorrelationRules.get(impl.getKey()), instance -> this.perContextPushCorrelationRules.put(impl.getKey(), (PushCorrelationRule)instance));
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)impl, (Object)e);
            }
        }
        return rule;
    }

    public String getFIQL(ConnectorObject connectorObject, ExternalResource resource, Provision provision) {
        return this.rule(resource, provision).map(rule -> rule.getFIQL(connectorObject, provision)).orElseGet(() -> (String)PushCorrelationRule.DEFAULT_FIQL_BUILDER.apply(connectorObject, provision));
    }

    public List<ConnectorObject> match(PropagationTaskInfo taskInfo, Connector connector, Provision provision, List<PropagationActions> actions, String connObjectKeyValue) {
        Optional<PushCorrelationRule> rule = this.rule(taskInfo.getResource(), provision);
        boolean isLinkedAccount = taskInfo.getAnyTypeKind() == AnyTypeKind.USER && this.userDAO.linkedAccountExists(taskInfo.getEntityKey(), connObjectKeyValue);
        Any any = null;
        if (!isLinkedAccount) {
            any = this.anyUtilsFactory.getInstance(taskInfo.getAnyTypeKind()).dao().findById(taskInfo.getEntityKey()).orElse(null);
        }
        HashSet moreAttrsToGet = new HashSet();
        actions.forEach(action -> moreAttrsToGet.addAll(action.moreAttrsToGet(Optional.of(taskInfo), provision)));
        ArrayList<ConnectorObject> result = new ArrayList<ConnectorObject>();
        try {
            if (any != null && rule.isPresent()) {
                result.addAll(this.matchByCorrelationRule(connector, rule.get().getFilter(any, taskInfo.getResource(), provision), taskInfo.getResource(), provision, Optional.of((String[])moreAttrsToGet.toArray(String[]::new)), Optional.empty()));
            } else {
                MappingUtils.getConnObjectKeyItem(provision).flatMap(connObjectKeyItem -> this.matchByConnObjectKeyValue(connector, (Item)connObjectKeyItem, connObjectKeyValue, taskInfo.getResource(), provision, Optional.of((String[])moreAttrsToGet.toArray(String[]::new)), Optional.empty())).ifPresent(result::add);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Could not match {} with any existing {}", new Object[]{any, provision.getObjectClass(), e});
        }
        if (any != null && result.size() == 1) {
            this.virAttrHandler.setValues(any, (ConnectorObject)result.get(0));
        }
        return result;
    }

    protected List<PropagationActions> getPropagationActions(ExternalResource resource) {
        ArrayList<PropagationActions> result = new ArrayList<PropagationActions>();
        resource.getPropagationActions().forEach(impl -> {
            try {
                result.add((PropagationActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (PropagationActions)instance)));
            }
            catch (Exception e) {
                LOG.error("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    @Transactional(readOnly=true)
    public List<ConnectorObject> match(Connector connector, Any<?> any, ExternalResource resource, Provision provision, Optional<String[]> moreAttrsToGet, Item ... linkingItems) {
        Stream matgFromPropagationActions = this.getPropagationActions(resource).stream().flatMap(a -> a.moreAttrsToGet(Optional.empty(), provision).stream());
        Optional<String[]> effectiveMATG = Optional.of((String[])Stream.concat(moreAttrsToGet.stream().flatMap(Stream::of), matgFromPropagationActions).toArray(String[]::new));
        Optional<PushCorrelationRule> rule = this.rule(resource, provision);
        ArrayList<ConnectorObject> result = new ArrayList<ConnectorObject>();
        try {
            if (rule.isPresent()) {
                result.addAll(this.matchByCorrelationRule(connector, rule.get().getFilter(any, resource, provision), resource, provision, effectiveMATG, ArrayUtils.isEmpty((Object[])linkingItems) ? Optional.empty() : Optional.of(List.of(linkingItems))));
            } else {
                Optional<Item> connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
                Optional connObjectKeyValue = this.mappingManager.getConnObjectKeyValue(any, resource, provision);
                if (connObjectKeyItem.isPresent() && connObjectKeyValue.isPresent()) {
                    this.matchByConnObjectKeyValue(connector, connObjectKeyItem.get(), (String)connObjectKeyValue.get(), resource, provision, effectiveMATG, ArrayUtils.isEmpty((Object[])linkingItems) ? Optional.empty() : Optional.of(List.of(linkingItems))).ifPresent(result::add);
                }
            }
        }
        catch (RuntimeException e) {
            LOG.error("Could not match {} with any existing {}", new Object[]{any, provision.getObjectClass(), e});
        }
        if (any != null && result.size() == 1) {
            this.virAttrHandler.setValues(any, (ConnectorObject)result.get(0));
        }
        return result;
    }

    protected List<ConnectorObject> matchByCorrelationRule(Connector connector, Filter filter, ExternalResource resource, Provision provision, Optional<String[]> moreAttrsToGet, Optional<Collection<Item>> linkingItems) {
        Stream<Item> items = Stream.concat(provision.getMapping().getItems().stream(), linkingItems.isPresent() ? linkingItems.get().stream() : this.virSchemaDAO.findByResourceAndAnyType(resource.getKey(), provision.getAnyType()).stream().map(VirSchema::asLinkingMappingItem));
        final ArrayList<ConnectorObject> objs = new ArrayList<ConnectorObject>();
        try {
            connector.search(new ObjectClass(provision.getObjectClass()), filter, new SearchResultsHandler(){

                public void handleResult(SearchResult result) {
                }

                public boolean handle(ConnectorObject connectorObject) {
                    objs.add(connectorObject);
                    return true;
                }
            }, MappingUtils.buildOperationOptions(items, moreAttrsToGet.orElse(null)));
        }
        catch (TimeoutException toe) {
            LOG.debug("Request timeout", (Throwable)toe);
            throw toe;
        }
        catch (RuntimeException ignore) {
            LOG.debug("Unexpected exception", (Throwable)ignore);
        }
        return objs;
    }

    @Transactional(readOnly=true)
    public Optional<ConnectorObject> matchByConnObjectKeyValue(Connector connector, Item connObjectKeyItem, String connObjectKeyValue, ExternalResource resource, Provision provision, Optional<String[]> moreAttrsToGet, Optional<Collection<Item>> linkingItems) {
        Stream<Item> items = Stream.concat(provision.getMapping().getItems().stream(), linkingItems.isPresent() ? linkingItems.get().stream() : this.virSchemaDAO.findByResourceAndAnyType(resource.getKey(), provision.getAnyType()).stream().map(VirSchema::asLinkingMappingItem));
        ConnectorObject obj = null;
        try {
            obj = connector.getObject(new ObjectClass(provision.getObjectClass()), AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKeyValue}), provision.isIgnoreCaseMatch(), MappingUtils.buildOperationOptions(items, moreAttrsToGet.orElse(null)));
        }
        catch (TimeoutException toe) {
            LOG.debug("Request timeout", (Throwable)toe);
            throw toe;
        }
        catch (RuntimeException ignore) {
            LOG.debug("While resolving {}", (Object)connObjectKeyValue, (Object)ignore);
        }
        return Optional.ofNullable(obj);
    }
}

