/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.policy.ProvisioningPolicy;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.LiveSyncTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.api.LiveSyncDeltaMapper;
import org.apache.syncope.core.provisioning.api.ProvisionSorter;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.job.StoppableSchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.UserPullResultHandler;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultAnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultGroupPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultRealmPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultUserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.LiveSyncTaskExecSaver;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class LiveSyncJobDelegate
extends AbstractProvisioningJobDelegate<LiveSyncTask>
implements StoppableSchedTaskJobDelegate {
    @Autowired
    protected PlainSchemaDAO plainSchemaDAO;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected PlainAttrValidationManager validator;
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected LiveSyncTaskExecSaver liveSyncTaskExecSaver;
    protected ProvisioningProfile<PullTask, InboundActions> profile;
    protected LiveSyncDeltaMapper mapper;
    protected List<LiveSyncInfo> infos;
    protected final Map<String, InboundActions> perContextActions = new ConcurrentHashMap<String, InboundActions>();
    protected volatile boolean stopRequested = false;

    protected RealmPullResultHandler buildRealmHandler() {
        return (RealmPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultRealmPullResultHandler.class);
    }

    protected AnyObjectPullResultHandler buildAnyObjectHandler() {
        return (AnyObjectPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultAnyObjectPullResultHandler.class);
    }

    protected UserPullResultHandler buildUserHandler() {
        return (UserPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultUserPullResultHandler.class);
    }

    protected GroupPullResultHandler buildGroupHandler() {
        return (GroupPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultGroupPullResultHandler.class);
    }

    @Override
    protected void init(final TaskType taskType, final String taskKey, JobExecutionContext context) throws JobExecutionException {
        super.init(taskType, taskKey, context);
        Implementation impl = Optional.ofNullable(((LiveSyncTask)this.task).getLiveSyncDeltaMapper()).orElseThrow(() -> new JobExecutionException("No " + LiveSyncDeltaMapper.class.getSimpleName() + " provided, aborting"));
        try {
            this.mapper = (LiveSyncDeltaMapper)ImplementationManager.build((Implementation)impl);
        }
        catch (Exception e) {
            throw new JobExecutionException("Could not build LIVE_SYNC_DELTA_MAPPER " + impl.getKey(), (Throwable)e);
        }
        PullTask pullTask = (PullTask)this.entityFactory.newEntity(PullTask.class);
        pullTask.setName(((LiveSyncTask)this.task).getName());
        pullTask.setResource(((LiveSyncTask)this.task).getResource());
        pullTask.setMatchingRule(((LiveSyncTask)this.task).getMatchingRule());
        pullTask.setUnmatchingRule(((LiveSyncTask)this.task).getUnmatchingRule());
        pullTask.setPullMode(PullMode.INCREMENTAL);
        pullTask.setPerformCreate(((LiveSyncTask)this.task).isPerformCreate());
        pullTask.setPerformUpdate(((LiveSyncTask)this.task).isPerformUpdate());
        pullTask.setPerformDelete(((LiveSyncTask)this.task).isPerformDelete());
        pullTask.setSyncStatus(((LiveSyncTask)this.task).isSyncStatus());
        pullTask.setDestinationRealm(((LiveSyncTask)this.task).getDestinationRealm());
        pullTask.setRemediation(((LiveSyncTask)this.task).isRemediation());
        ((LiveSyncTask)this.task).getTemplates().forEach(atlst -> {
            AnyTemplatePullTask atpt = (AnyTemplatePullTask)this.entityFactory.newEntity(AnyTemplatePullTask.class);
            atpt.setAnyType(atlst.getAnyType());
            atpt.setPullTask(pullTask);
            pullTask.add(atpt);
            atpt.set(atlst.get());
        });
        ArrayList actions = new ArrayList();
        ((LiveSyncTask)this.task).getActions().forEach(action -> {
            try {
                actions.add((InboundActions)ImplementationManager.build((Implementation)action, () -> this.perContextActions.get(action.getKey()), instance -> this.perContextActions.put(action.getKey(), (InboundActions)instance)));
            }
            catch (Exception e) {
                LOG.warn("While building {}", action, (Object)e);
            }
        });
        this.profile = new ProvisioningProfile<PullTask, InboundActions>(this.connector, taskType, pullTask, Optional.ofNullable(((LiveSyncTask)this.task).getResource().getInboundPolicy()).map(ProvisioningPolicy::getConflictResolutionAction).orElse(ConflictResolutionAction.IGNORE), actions, this.executor, context.isDryRun()){

            public String getContext() {
                return String.valueOf(taskType) + " Task " + taskKey + " '" + ((LiveSyncTask)LiveSyncJobDelegate.this.task).getName() + "'";
            }
        };
        this.infos = new ArrayList<LiveSyncInfo>();
        if (((LiveSyncTask)this.task).getResource().getOrgUnit() != null) {
            this.setStatus("Pulling " + ((LiveSyncTask)this.task).getResource().getOrgUnit().getObjectClass());
            OrgUnit orgUnit = ((LiveSyncTask)this.task).getResource().getOrgUnit();
            HashSet moreAttrsToGet = new HashSet();
            this.profile.getActions().forEach(a -> moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, orgUnit)));
            OperationOptions options = MappingUtils.buildOperationOptions(MappingUtils.getInboundItems(orgUnit.getItems().stream()), (String[])moreAttrsToGet.toArray(String[]::new));
            RealmPullResultHandler handler = this.buildRealmHandler();
            handler.setProfile(this.profile);
            this.infos.add(new LiveSyncInfo(null, orgUnit, new ObjectClass(orgUnit.getObjectClass()), null, null, (SyncopePullResultHandler)handler, options));
        }
        ProvisionSorter provisionSorter = this.getProvisionSorter((LiveSyncTask)this.task);
        for (Provision provision2 : ((LiveSyncTask)this.task).getResource().getProvisions().stream().filter(provision -> provision.getMapping() != null).sorted((Comparator<Provision>)provisionSorter).toList()) {
            AnyType anyType = (AnyType)this.anyTypeDAO.findById(provision2.getAnyType()).orElseThrow(() -> new NotFoundException("AnyType" + provision2.getAnyType()));
            PlainSchema uidOnCreate = null;
            if (provision2.getUidOnCreate() != null) {
                uidOnCreate = (PlainSchema)this.plainSchemaDAO.findById(provision2.getUidOnCreate()).orElseThrow(() -> new NotFoundException("PlainSchema " + provision2.getUidOnCreate()));
            }
            UserPullResultHandler handler = switch (anyType.getKind()) {
                case AnyTypeKind.USER -> this.buildUserHandler();
                case AnyTypeKind.GROUP -> this.buildGroupHandler();
                default -> this.buildAnyObjectHandler();
            };
            handler.setProfile(this.profile);
            HashSet moreAttrsToGet = new HashSet();
            this.profile.getActions().forEach(a -> moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, provision2)));
            Stream<Item> mapItems = Stream.concat(MappingUtils.getInboundItems(provision2.getMapping().getItems().stream()), this.virSchemaDAO.findByResourceAndAnyType(((LiveSyncTask)this.task).getResource().getKey(), anyType.getKey()).stream().map(VirSchema::asLinkingMappingItem));
            OperationOptions options = MappingUtils.buildOperationOptions(mapItems, (String[])moreAttrsToGet.toArray(String[]::new));
            this.infos.add(new LiveSyncInfo(provision2, null, new ObjectClass(provision2.getObjectClass()), anyType.getKind(), uidOnCreate, (SyncopePullResultHandler)handler, options));
        }
        this.setStatus("Initialization completed");
    }

    public void stop() {
        this.stopRequested = true;
    }

    @Override
    @Transactional
    public void execute(TaskType taskType, String taskKey, JobExecutionContext context) throws JobExecutionException {
        this.init(taskType, taskKey, context);
        this.setStatus("Initialization completed");
        this.doExecute(context);
        this.end();
    }

    @Override
    protected String doExecute(JobExecutionContext context) throws JobExecutionException {
        if (this.infos.isEmpty()) {
            LOG.info("Nothing to live sync on, aborting...");
            return "";
        }
        LOG.debug("Executing live sync on {}", (Object)((LiveSyncTask)this.task).getResource());
        while (!this.stopRequested) {
            OpEvent.Outcome result;
            String status;
            String message;
            this.profile.getResults().clear();
            TaskExec<SchedTask> execution = this.initExecution();
            execution.setTask(null);
            try {
                this.infos.forEach(info -> {
                    this.setStatus("Live syncing " + info.objectClass().getObjectClassValue());
                    this.profile.getConnector().livesync(info.objectClass(), liveSyncDelta -> {
                        try {
                            LOG.debug("LiveSyncDelta: {}", (Object)liveSyncDelta);
                            SyncDelta syncDelta = info.provision() == null ? this.mapper.map(liveSyncDelta, info.orgUnit()) : this.mapper.map(liveSyncDelta, info.provision());
                            LOG.debug("Mapped SyncDelta: {}", (Object)syncDelta);
                            return info.handler().handle(syncDelta);
                        }
                        catch (Exception e) {
                            LOG.error("While live syncing from {} with {}", new Object[]{((LiveSyncTask)this.task).getResource().getKey(), liveSyncDelta, e});
                            return false;
                        }
                    }, info.options());
                    if (info.uidOnCreate() != null) {
                        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(info.anyTypeKind());
                        this.profile.getResults().stream().filter(r -> r.getUidValue() != null && r.getKey() != null && r.getOperation() == ResourceOperation.CREATE && r.getAnyType().equals(info.provision().getAnyType())).forEach(r -> anyUtils.addAttr(this.validator, r.getKey(), info.uidOnCreate(), r.getUidValue()));
                    }
                    if (info.anyTypeKind() == AnyTypeKind.GROUP) {
                        try {
                            PullJobDelegate.setGroupOwners((GroupPullResultHandler)info.handler(), this.groupDAO, this.anyTypeDAO, this.inboundMatcher, this.profile);
                        }
                        catch (Exception e) {
                            LOG.error("While setting group owners", (Throwable)e);
                        }
                    }
                });
                message = this.createReport(this.profile.getResults(), ((LiveSyncTask)this.task).getResource(), context.isDryRun());
                status = TaskJob.Status.SUCCESS.name();
                result = OpEvent.Outcome.SUCCESS;
            }
            catch (Throwable t) {
                LOG.error("While executing task {}", (Object)((LiveSyncTask)this.task).getKey(), (Object)t);
                message = ExceptionUtils2.getFullStackTrace((Throwable)t);
                status = TaskJob.Status.FAILURE.name();
                result = OpEvent.Outcome.FAILURE;
            }
            if (this.profile.getResults().isEmpty()) continue;
            this.liveSyncTaskExecSaver.save(((LiveSyncTask)this.task).getKey(), execution, message, status, result, this::hasToBeRegistered);
        }
        return "";
    }

    protected record LiveSyncInfo(Provision provision, OrgUnit orgUnit, ObjectClass objectClass, AnyTypeKind anyTypeKind, PlainSchema uidOnCreate, SyncopePullResultHandler handler, OperationOptions options) {
    }
}

