/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPushResultHandler;
import org.apache.syncope.core.provisioning.java.job.AfterHandlingJob;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationReporter;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractRealmResultHandler;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultRealmPushResultHandler
extends AbstractRealmResultHandler<PushTask, PushActions>
implements RealmPushResultHandler {
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private SyncopeTaskScheduler scheduler;

    protected static ResourceOperation toResourceOperation(UnmatchingRule rule) {
        return switch (rule) {
            case UnmatchingRule.ASSIGN, UnmatchingRule.PROVISION -> ResourceOperation.CREATE;
            default -> ResourceOperation.NONE;
        };
    }

    protected static ResourceOperation toResourceOperation(MatchingRule rule) {
        return switch (rule) {
            case MatchingRule.UPDATE -> ResourceOperation.UPDATE;
            case MatchingRule.DEPROVISION, MatchingRule.UNASSIGN -> ResourceOperation.DELETE;
            default -> ResourceOperation.NONE;
        };
    }

    protected static ProvisioningReport.Status toProvisioningReportStatus(ExecStatus status) {
        switch (status) {
            case FAILURE: {
                return ProvisioningReport.Status.FAILURE;
            }
            case SUCCESS: {
                return ProvisioningReport.Status.SUCCESS;
            }
        }
        return ProvisioningReport.Status.IGNORE;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean handle(String realmKey) {
        Realm realm = null;
        try {
            realm = (Realm)this.realmDAO.findById(realmKey).orElseThrow(() -> new NotFoundException("Realm " + realmKey));
            this.doHandle(realm);
            if (this.stopRequested) {
                LOG.debug("Stop was requested");
                return false;
            }
            return true;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType(realm == null ? null : "REALM");
            result.setStatus(ProvisioningReport.Status.IGNORE);
            result.setKey(realmKey);
            this.profile.getResults().add(result);
            LOG.warn("Ignoring during push", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Push failed", (Throwable)e);
            return false;
        }
    }

    private static void reportPropagation(ProvisioningReport result, PropagationReporter reporter) {
        if (!reporter.getStatuses().isEmpty()) {
            result.setStatus(DefaultRealmPushResultHandler.toProvisioningReportStatus(((PropagationStatus)reporter.getStatuses().get(0)).getStatus()));
            result.setMessage(((PropagationStatus)reporter.getStatuses().get(0)).getFailureReason());
        }
    }

    private Realm update(RealmTO realmTO, ConnectorObject beforeObj, ProvisioningReport result) {
        Realm realm = (Realm)this.realmSearchDAO.findByFullPath(realmTO.getFullPath()).orElseThrow(() -> new NotFoundException("Realm " + realmTO.getFullPath()));
        Map beforeAttrs = this.propagationManager.prepareAttrs(realm);
        PropagationByResource propByRes = this.binder.update(realm, realmTO);
        List taskInfos = this.propagationManager.setAttributeDeltas(this.propagationManager.createTasks(realm = (Realm)this.realmDAO.save((Entity)realm), propByRes, null), beforeAttrs);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.get(0)).setBeforeObj(Optional.ofNullable(beforeObj));
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.get(0), (PropagationReporter)reporter, this.securityProperties.getAdminUser());
            DefaultRealmPushResultHandler.reportPropagation(result, reporter);
        }
        return realm;
    }

    private void deprovision(Realm realm, ConnectorObject beforeObj, ProvisioningReport result) {
        ArrayList noPropResources = new ArrayList(realm.getResourceKeys());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.DELETE, (Collection)realm.getResourceKeys());
        List taskInfos = this.propagationManager.createTasks(realm, propByRes, noPropResources);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.get(0)).setBeforeObj(Optional.ofNullable(beforeObj));
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.get(0), (PropagationReporter)reporter, this.securityProperties.getAdminUser());
            DefaultRealmPushResultHandler.reportPropagation(result, reporter);
        }
    }

    private void provision(Realm realm, ProvisioningReport result) {
        ArrayList noPropResources = new ArrayList(realm.getResourceKeys());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.CREATE, (Serializable)((Object)((PushTask)this.profile.getTask()).getResource().getKey()));
        PropagationReporter reporter = this.taskExecutor.execute((Collection)this.propagationManager.createTasks(realm, propByRes, noPropResources), false, this.securityProperties.getAdminUser());
        DefaultRealmPushResultHandler.reportPropagation(result, reporter);
    }

    private void link(Realm realm, boolean unlink, ProvisioningReport result) {
        RealmTO realmTO = this.binder.getRealmTO(realm, true);
        if (unlink) {
            realmTO.getResources().remove(((PushTask)this.profile.getTask()).getResource().getKey());
        } else {
            realmTO.getResources().add(((PushTask)this.profile.getTask()).getResource().getKey());
        }
        this.update(realmTO, null, result);
    }

    private void unassign(Realm realm, ConnectorObject beforeObj, ProvisioningReport result) {
        RealmTO realmTO = this.binder.getRealmTO(realm, true);
        realmTO.getResources().remove(((PushTask)this.profile.getTask()).getResource().getKey());
        this.deprovision(this.update(realmTO, beforeObj, result), beforeObj, result);
    }

    private void assign(Realm realm, ProvisioningReport result) {
        RealmTO realmTO = this.binder.getRealmTO(realm, true);
        realmTO.getResources().add(((PushTask)this.profile.getTask()).getResource().getKey());
        this.provision(this.update(realmTO, null, result), result);
    }

    protected ConnectorObject getRemoteObject(ObjectClass objectClass, String connObjectKey, String connObjectKeyValue, boolean ignoreCaseMatch, Stream<Item> mapItems) {
        ConnectorObject obj = null;
        try {
            obj = this.profile.getConnector().getObject(objectClass, AttributeBuilder.build((String)connObjectKey, (Object[])new Object[]{connObjectKeyValue}), ignoreCaseMatch, MappingUtils.buildOperationOptions(mapItems, new String[0]));
        }
        catch (TimeoutException toe) {
            LOG.debug("Request timeout", (Throwable)toe);
            throw toe;
        }
        catch (RuntimeException ignore) {
            LOG.debug("While resolving {}", (Object)connObjectKeyValue, (Object)ignore);
        }
        return obj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doHandle(Realm realm) throws JobExecutionException {
        HashMap<String, Object> jobMap;
        ProvisioningReport result = new ProvisioningReport();
        this.profile.getResults().add(result);
        result.setKey(realm.getKey());
        result.setAnyType("REALM");
        result.setName(realm.getFullPath());
        LOG.debug("Propagating Realm with key {} towards {}", (Object)realm.getKey(), (Object)((PushTask)this.profile.getTask()).getResource());
        Exception output = null;
        OpEvent.Outcome resultStatus = null;
        OrgUnit orgUnit = ((PushTask)this.profile.getTask()).getResource().getOrgUnit();
        Optional connObjectKey = orgUnit.getConnObjectKeyItem();
        Optional connObjecKeyValue = this.mappingManager.getConnObjectKeyValue(realm, orgUnit);
        ConnectorObject beforeObj = null;
        if (connObjectKey.isPresent() && connObjecKeyValue.isPresent()) {
            beforeObj = this.getRemoteObject(new ObjectClass(orgUnit.getObjectClass()), ((Item)connObjectKey.get()).getExtAttrName(), (String)connObjecKeyValue.get(), orgUnit.isIgnoreCaseMatch(), orgUnit.getItems().stream());
        } else {
            LOG.debug("OrgUnitItem {} or its value {} are null", (Object)connObjectKey, (Object)connObjecKeyValue);
        }
        if (this.profile.isDryRun()) {
            if (beforeObj == null) {
                result.setOperation(DefaultRealmPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
            } else {
                result.setOperation(DefaultRealmPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
            }
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            return;
        }
        String operation = beforeObj == null ? UnmatchingRule.toOp((UnmatchingRule)((PushTask)this.profile.getTask()).getUnmatchingRule()) : MatchingRule.toOp((MatchingRule)((PushTask)this.profile.getTask()).getMatchingRule());
        boolean notificationsAvailable = this.notificationManager.notificationsAvailable(AuthContextUtils.getDomain(), OpEvent.CategoryType.PUSH, "REALM".toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation);
        boolean auditRequested = this.auditManager.auditRequested(AuthContextUtils.getDomain(), AuthContextUtils.getUsername(), OpEvent.CategoryType.PUSH, "REALM".toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation);
        try {
            if (beforeObj == null) {
                result.setOperation(DefaultRealmPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
                switch (((PushTask)this.profile.getTask()).getUnmatchingRule()) {
                    case ASSIGN: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeAssign(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            LOG.debug("PushTask not configured for create");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.assign(realm, result);
                        break;
                    }
                    case PROVISION: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeProvision(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            LOG.debug("PushTask not configured for create");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.provision(realm, result);
                        break;
                    }
                    case UNLINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(realm, true, result);
                        break;
                    }
                    case IGNORE: {
                        LOG.debug("Ignored any: {}", (Object)realm);
                        result.setStatus(ProvisioningReport.Status.IGNORE);
                        break;
                    }
                }
            } else {
                result.setOperation(DefaultRealmPushResultHandler.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
                switch (((PushTask)this.profile.getTask()).getMatchingRule()) {
                    case UPDATE: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.update(this.binder.getRealmTO(realm, true), beforeObj, result);
                        break;
                    }
                    case DEPROVISION: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeDeprovision(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            LOG.debug("PushTask not configured for delete");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.deprovision(realm, beforeObj, result);
                        break;
                    }
                    case UNASSIGN: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnassign(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            LOG.debug("PushTask not configured for delete");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.unassign(realm, beforeObj, result);
                        break;
                    }
                    case LINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeLink(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(realm, false, result);
                        break;
                    }
                    case UNLINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, (Entity)realm);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(realm, true, result);
                        break;
                    }
                    case IGNORE: {
                        LOG.debug("Ignored any: {}", (Object)realm);
                        result.setStatus(ProvisioningReport.Status.IGNORE);
                        break;
                    }
                }
            }
            for (PushActions action : this.profile.getActions()) {
                action.after(this.profile, (Entity)realm, result);
            }
            if (result.getStatus() == null) {
                result.setStatus(ProvisioningReport.Status.SUCCESS);
            }
            if (notificationsAvailable || auditRequested) {
                resultStatus = OpEvent.Outcome.SUCCESS;
                if (connObjectKey.isPresent() && connObjecKeyValue.isPresent()) {
                    output = this.getRemoteObject(new ObjectClass(orgUnit.getObjectClass()), ((Item)connObjectKey.get()).getExtAttrName(), (String)connObjecKeyValue.get(), orgUnit.isIgnoreCaseMatch(), orgUnit.getItems().stream());
                }
            }
            if (!notificationsAvailable) {
                if (!auditRequested) return;
            }
            jobMap = new HashMap<String, Object>();
        }
        catch (IgnoreProvisionException e) {
            try {
                throw e;
                catch (Exception e2) {
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e2));
                    if (notificationsAvailable || auditRequested) {
                        resultStatus = OpEvent.Outcome.FAILURE;
                        output = e2;
                    }
                    LOG.warn("Error pushing {} towards {}", new Object[]{realm, ((PushTask)this.profile.getTask()).getResource(), e2});
                    Iterator iterator = this.profile.getActions().iterator();
                    while (iterator.hasNext()) {
                        PushActions action = (PushActions)iterator.next();
                        action.onError(this.profile, (Entity)realm, result, e2);
                    }
                    throw new JobExecutionException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (!notificationsAvailable) {
                    if (!auditRequested) throw throwable;
                }
                HashMap<String, Object> jobMap2 = new HashMap<String, Object>();
                jobMap2.put("AfterHandlingEvent", new AfterHandlingEvent(AuthContextUtils.getDomain(), AuthContextUtils.getWho(), OpEvent.CategoryType.PUSH, "REALM".toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, (Object)output, new Object[]{realm}));
                AfterHandlingJob.schedule(this.scheduler, jobMap2);
                throw throwable;
            }
        }
        jobMap.put("AfterHandlingEvent", new AfterHandlingEvent(AuthContextUtils.getDomain(), AuthContextUtils.getWho(), OpEvent.CategoryType.PUSH, "REALM".toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, (Object)output, new Object[]{realm}));
        AfterHandlingJob.schedule(this.scheduler, jobMap);
    }
}

