/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Optional;
import org.apache.syncope.common.lib.request.AbstractPatchItem;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.identityconnectors.framework.common.objects.LiveSyncDelta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DBPasswordPullActions
implements InboundActions {
    protected static final Logger LOG = LoggerFactory.getLogger(DBPasswordPullActions.class);
    protected static final String CLEARTEXT = "CLEARTEXT";
    @Autowired
    protected UserDAO userDAO;
    protected String encodedPassword;
    protected CipherAlgorithm cipher;

    @Transactional(readOnly=true)
    public void beforeProvision(ProvisioningProfile<?, ?> profile, LiveSyncDelta delta, AnyCR anyCR) {
        if (anyCR instanceof UserCR) {
            UserCR userCR = (UserCR)anyCR;
            this.parseEncodedPassword(userCR.getPassword(), profile.getConnector());
        }
    }

    @Transactional(readOnly=true)
    public void beforeUpdate(ProvisioningProfile<?, ?> profile, LiveSyncDelta delta, EntityTO entityTO, AnyUR anyUR) {
        if (anyUR instanceof UserUR) {
            UserUR userUR = (UserUR)anyUR;
            this.parseEncodedPassword(Optional.ofNullable(userUR.getPassword()).map(AbstractPatchItem::getValue).orElse(null), profile.getConnector());
        }
    }

    protected void parseEncodedPassword(String password, Connector connector) {
        ConnInstance connInstance;
        String cipherAlgorithm;
        if (password != null && !CLEARTEXT.equals(cipherAlgorithm = this.getCipherAlgorithm(connInstance = connector.getConnInstance()))) {
            try {
                this.encodedPassword = password;
                this.cipher = CipherAlgorithm.valueOf((String)cipherAlgorithm);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cipher algorithm not allowed: {}", (Object)cipherAlgorithm, (Object)e);
                this.encodedPassword = null;
            }
        }
    }

    protected String getCipherAlgorithm(ConnInstance connInstance) {
        return connInstance.getConf().stream().filter(property -> "cipherAlgorithm".equals(property.getSchema().getName()) && property.getValues() != null && !property.getValues().isEmpty()).findFirst().map(cipherAlgorithm -> cipherAlgorithm.getValues().get(0).toString()).orElse(CLEARTEXT);
    }

    @Transactional
    public void after(ProvisioningProfile<?, ?> profile, LiveSyncDelta delta, EntityTO any, ProvisioningReport result) {
        if (any instanceof UserTO && this.encodedPassword != null && this.cipher != null) {
            this.userDAO.findById(any.getKey()).ifPresent(user -> {
                user.setEncodedPassword(this.encodedPassword.toUpperCase(), this.cipher);
                this.userDAO.save((Entity)user);
            });
            this.encodedPassword = null;
            this.cipher = null;
        }
    }
}

