/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.cache.Cache;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Remediation;
import org.apache.syncope.core.persistence.api.entity.task.InboundTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullResultHandler;
import org.apache.syncope.core.provisioning.api.rules.InboundMatch;
import org.apache.syncope.core.provisioning.java.cache.VirAttrCacheKey;
import org.apache.syncope.core.provisioning.java.cache.VirAttrCacheValue;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractSyncopeResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.LiveSyncDelta;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractPullResultHandler
extends AbstractSyncopeResultHandler<PullTask, InboundActions>
implements SyncopePullResultHandler {
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected TaskDAO taskDAO;
    @Autowired
    protected RemediationDAO remediationDAO;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected Cache<VirAttrCacheKey, VirAttrCacheValue> virAttrCache;
    @Autowired
    protected EntityFactory entityFactory;

    protected static OpEvent.Outcome and(OpEvent.Outcome left, OpEvent.Outcome right) {
        return left == OpEvent.Outcome.SUCCESS && right == OpEvent.Outcome.SUCCESS ? OpEvent.Outcome.SUCCESS : OpEvent.Outcome.FAILURE;
    }

    protected abstract String getName(AnyTO var1);

    protected abstract String getName(AnyCR var1);

    protected abstract ProvisioningManager<?, ?> getProvisioningManager();

    protected abstract AnyTO doCreate(AnyCR var1, SyncDelta var2);

    protected abstract AnyUR doUpdate(AnyTO var1, AnyUR var2, SyncDelta var3, ProvisioningReport var4);

    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW)
    public boolean handle(SyncDelta delta) {
        Provision provision = null;
        try {
            provision = (Provision)((PullTask)this.profile.getTask()).getResource().getProvisionByObjectClass(delta.getObject().getObjectClass().getObjectClassValue()).orElseThrow(() -> new JobExecutionException("No provision found on " + String.valueOf(((PullTask)this.profile.getTask()).getResource()) + " for " + String.valueOf(delta.getObject().getObjectClass())));
            String anyType = provision.getAnyType();
            OpEvent.Outcome latestResult = this.doHandle(delta, provision, ((AnyType)this.anyTypeDAO.findById(anyType).orElseThrow(() -> new NotFoundException("AnyType " + anyType))).getKind());
            LOG.debug("Successfully handled {}", (Object)delta);
            if (this.stopRequested) {
                LOG.debug("Stop was requested");
                return false;
            }
            if (((PullTask)this.profile.getTask()).getPullMode() != PullMode.INCREMENTAL) {
                return true;
            }
            return latestResult == OpEvent.Outcome.SUCCESS;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport ignoreResult = new ProvisioningReport();
            ignoreResult.setOperation(ResourceOperation.NONE);
            ignoreResult.setAnyType(provision == null ? this.getAnyUtils().anyTypeKind().name() : provision.getAnyType());
            ignoreResult.setStatus(ProvisioningReport.Status.IGNORE);
            ignoreResult.setMessage(e.getMessage());
            ignoreResult.setKey(null);
            ignoreResult.setUidValue(delta.getUid().getUidValue());
            ignoreResult.setName(delta.getObject().getName().getNameValue());
            this.profile.getResults().add(ignoreResult);
            LOG.warn("Ignoring during pull", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Pull failed", (Throwable)e);
            return false;
        }
    }

    protected void throwIgnoreProvisionException(SyncDelta delta, Exception exception) {
        if (exception instanceof IgnoreProvisionException) {
            throw (IgnoreProvisionException)((Object)IgnoreProvisionException.class.cast(exception));
        }
        IgnoreProvisionException ipe = null;
        for (InboundActions action : this.profile.getActions()) {
            if (ipe != null) continue;
            ipe = action.onError(this.profile, (LiveSyncDelta)delta, exception);
        }
        if (ipe != null) {
            throw ipe;
        }
    }

    protected OpEvent.Outcome provision(UnmatchingRule rule, SyncDelta delta, AnyTypeKind anyTypeKind, Provision provision) throws JobExecutionException {
        OpEvent.Outcome resultStatus;
        Object output;
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.end(provision.getAnyType(), UnmatchingRule.toOp((UnmatchingRule)rule), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        Object anyCR = this.connObjectUtils.getAnyCR(delta.getObject(), (InboundTask)this.profile.getTask(), anyTypeKind, provision, true);
        if (rule == UnmatchingRule.ASSIGN) {
            anyCR.getResources().add(((PullTask)this.profile.getTask()).getResource().getKey());
        }
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType(provision.getAnyType());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(this.getName((AnyCR)anyCR));
        result.setUidValue(delta.getUid().getUidValue());
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.end(provision.getAnyType(), UnmatchingRule.toOp((UnmatchingRule)rule), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        try {
            AnyTO created;
            for (InboundActions action : this.profile.getActions()) {
                if (rule == UnmatchingRule.ASSIGN) {
                    action.beforeAssign(this.profile, (LiveSyncDelta)delta, anyCR);
                    continue;
                }
                if (rule != UnmatchingRule.PROVISION) continue;
                action.beforeProvision(this.profile, (LiveSyncDelta)delta, anyCR);
            }
            result.setName(this.getName((AnyCR)anyCR));
            output = created = this.doCreate((AnyCR)anyCR, delta);
            result.setKey(created.getKey());
            result.setName(this.getName(created));
            resultStatus = OpEvent.Outcome.SUCCESS;
            for (InboundActions action : this.profile.getActions()) {
                action.after(this.profile, (LiveSyncDelta)delta, (EntityTO)created, result);
            }
            LOG.debug("{} {} successfully created", (Object)created.getType(), (Object)created.getKey());
        }
        catch (PropagationException e) {
            LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
            output = e;
            resultStatus = OpEvent.Outcome.FAILURE;
        }
        catch (Exception e) {
            this.throwIgnoreProvisionException(delta, e);
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOG.error("Could not create {} {} ", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
            output = e;
            if (((PullTask)this.profile.getTask()).isRemediation()) {
                resultStatus = OpEvent.Outcome.SUCCESS;
                this.createRemediation(provision.getAnyType(), null, (AnyCR)anyCR, null, result, delta);
            }
            resultStatus = OpEvent.Outcome.FAILURE;
        }
        this.end(provision.getAnyType(), UnmatchingRule.toOp((UnmatchingRule)rule), resultStatus, null, output, delta, new Object[0]);
        this.profile.getResults().add(result);
        return resultStatus;
    }

    protected OpEvent.Outcome update(SyncDelta delta, List<InboundMatch> matches, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(provision.getAnyType(), MatchingRule.toOp((MatchingRule)MatchingRule.UPDATE), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        LOG.debug("About to update {}", matches);
        OpEvent.Outcome global = OpEvent.Outcome.SUCCESS;
        for (InboundMatch match : matches) {
            LOG.debug("About to update {}", (Object)match);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.UPDATE);
            result.setAnyType(provision.getAnyType());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(match.getAny().getKey());
            result.setUidValue(delta.getUid().getUidValue());
            AnyTO before = this.getAnyTO(match.getAny());
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType(), match));
            } else {
                result.setName(this.getName(before));
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                OpEvent.Outcome resultStatus;
                AnyUR effectiveReq = null;
                if (before == null) {
                    resultStatus = OpEvent.Outcome.FAILURE;
                    output = null;
                } else {
                    AnyUR anyUR = null;
                    try {
                        anyUR = (AnyUR)this.connObjectUtils.getAnyUR(before.getKey(), delta.getObject(), before, (InboundTask)this.profile.getTask(), match.getAny().getType().getKind(), provision);
                        for (InboundActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, (LiveSyncDelta)delta, (EntityTO)before, anyUR);
                        }
                        effectiveReq = this.doUpdate(before, anyUR, delta, result);
                        AnyTO updated = AnyOperations.patch((AnyTO)before, (AnyUR)effectiveReq);
                        for (InboundActions action : this.profile.getActions()) {
                            action.after(this.profile, (LiveSyncDelta)delta, (EntityTO)updated, result);
                        }
                        output = updated;
                        resultStatus = OpEvent.Outcome.SUCCESS;
                        result.setName(this.getName(updated));
                        LOG.debug("{} {} successfully updated", (Object)provision.getAnyType(), (Object)match);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = OpEvent.Outcome.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                        output = e;
                        if (((PullTask)this.profile.getTask()).isRemediation()) {
                            resultStatus = OpEvent.Outcome.SUCCESS;
                            this.createRemediation(provision.getAnyType(), null, null, anyUR, result, delta);
                        }
                        resultStatus = OpEvent.Outcome.FAILURE;
                    }
                }
                this.end(provision.getAnyType(), MatchingRule.toOp((MatchingRule)MatchingRule.UPDATE), resultStatus, before, output, delta, effectiveReq);
                global = AbstractPullResultHandler.and(global, resultStatus);
            }
            this.profile.getResults().add(result);
        }
        return global;
    }

    protected OpEvent.Outcome deprovision(MatchingRule matchingRule, SyncDelta delta, List<InboundMatch> matches, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(provision.getAnyType(), MatchingRule.toOp((MatchingRule)matchingRule), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        LOG.debug("About to deprovision {}", matches);
        OpEvent.Outcome global = OpEvent.Outcome.SUCCESS;
        for (InboundMatch match : matches) {
            LOG.debug("About to unassign resource {}", (Object)match);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.DELETE);
            result.setAnyType(provision.getAnyType());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(match.getAny().getKey());
            result.setUidValue(delta.getUid().getUidValue());
            AnyTO before = this.getAnyTO(match.getAny());
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType(), match));
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                OpEvent.Outcome resultStatus;
                if (before == null) {
                    resultStatus = OpEvent.Outcome.FAILURE;
                    output = null;
                } else {
                    result.setName(this.getName(before));
                    try {
                        if (matchingRule == MatchingRule.UNASSIGN) {
                            for (InboundActions action : this.profile.getActions()) {
                                action.beforeUnassign(this.profile, (LiveSyncDelta)delta, (EntityTO)before);
                            }
                        } else if (matchingRule == MatchingRule.DEPROVISION) {
                            for (InboundActions action : this.profile.getActions()) {
                                action.beforeDeprovision(this.profile, (LiveSyncDelta)delta, (EntityTO)before);
                            }
                        }
                        PropagationByResource propByRes = new PropagationByResource();
                        propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)((PullTask)this.profile.getTask()).getResource().getKey()));
                        this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(match.getAny().getType().getKind(), match.getAny().getKey(), propByRes, null, null), false, this.securityProperties.getAdminUser());
                        AnyUR anyUR = null;
                        if (matchingRule == MatchingRule.UNASSIGN) {
                            anyUR = this.getAnyUtils().newAnyUR(match.getAny().getKey());
                            anyUR.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value((Object)((PullTask)this.profile.getTask()).getResource().getKey())).build());
                        }
                        output = anyUR == null ? this.getAnyTO(match.getAny()) : this.doUpdate(before, anyUR, delta, result);
                        for (InboundActions action : this.profile.getActions()) {
                            action.after(this.profile, (LiveSyncDelta)delta, (EntityTO)AnyTO.class.cast(output), result);
                        }
                        resultStatus = OpEvent.Outcome.SUCCESS;
                        LOG.debug("{} {} successfully updated", (Object)provision.getAnyType(), (Object)match);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = OpEvent.Outcome.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = OpEvent.Outcome.FAILURE;
                    }
                }
                this.end(provision.getAnyType(), MatchingRule.toOp((MatchingRule)matchingRule), resultStatus, before, output, delta, new Object[0]);
                global = AbstractPullResultHandler.and(global, resultStatus);
            }
            this.profile.getResults().add(result);
        }
        return global;
    }

    protected OpEvent.Outcome link(SyncDelta delta, List<InboundMatch> matches, Provision provision, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(provision.getAnyType(), unlink ? MatchingRule.toOp((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toOp((MatchingRule)MatchingRule.LINK), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        LOG.debug("About to update {}", matches);
        OpEvent.Outcome global = OpEvent.Outcome.SUCCESS;
        for (InboundMatch match : matches) {
            LOG.debug("About to unassign resource {}", (Object)match);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType(provision.getAnyType());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(match.getAny().getKey());
            result.setUidValue(delta.getUid().getUidValue());
            AnyTO before = this.getAnyTO(match.getAny());
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType(), match));
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                OpEvent.Outcome resultStatus;
                AnyUR effectiveReq = null;
                if (before == null) {
                    resultStatus = OpEvent.Outcome.FAILURE;
                    output = null;
                } else {
                    result.setName(this.getName(before));
                    try {
                        if (unlink) {
                            for (InboundActions action : this.profile.getActions()) {
                                action.beforeUnlink(this.profile, (LiveSyncDelta)delta, (EntityTO)before);
                            }
                        } else {
                            for (InboundActions action : this.profile.getActions()) {
                                action.beforeLink(this.profile, (LiveSyncDelta)delta, (EntityTO)before);
                            }
                        }
                        AnyUR anyUR = this.getAnyUtils().newAnyUR(before.getKey());
                        anyUR.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(unlink ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).value((Object)((PullTask)this.profile.getTask()).getResource().getKey())).build());
                        effectiveReq = (AnyUR)this.update(anyUR).getResult();
                        output = AnyOperations.patch((AnyTO)before, (AnyUR)effectiveReq);
                        for (InboundActions action : this.profile.getActions()) {
                            action.after(this.profile, (LiveSyncDelta)delta, (EntityTO)AnyTO.class.cast(output), result);
                        }
                        resultStatus = OpEvent.Outcome.SUCCESS;
                        LOG.debug("{} {} successfully updated", (Object)provision.getAnyType(), (Object)match);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = OpEvent.Outcome.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = OpEvent.Outcome.FAILURE;
                    }
                }
                this.end(provision.getAnyType(), unlink ? MatchingRule.toOp((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toOp((MatchingRule)MatchingRule.LINK), resultStatus, before, output, delta, effectiveReq);
                global = AbstractPullResultHandler.and(global, resultStatus);
            }
            this.profile.getResults().add(result);
        }
        return global;
    }

    protected OpEvent.Outcome delete(SyncDelta delta, List<InboundMatch> matches, Provision provision) {
        if (!((PullTask)this.profile.getTask()).isPerformDelete()) {
            LOG.debug("PullTask not configured for delete");
            this.end(provision.getAnyType(), ResourceOperation.DELETE.name().toLowerCase(), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        LOG.debug("About to delete {}", matches);
        OpEvent.Outcome global = OpEvent.Outcome.SUCCESS;
        for (InboundMatch match : matches) {
            OpEvent.Outcome resultStatus = OpEvent.Outcome.FAILURE;
            ProvisioningReport result = new ProvisioningReport();
            try {
                AnyTO before = this.getAnyTO(match.getAny());
                result.setKey(match.getAny().getKey());
                result.setName(this.getName(before));
                result.setOperation(ResourceOperation.DELETE);
                result.setAnyType(provision.getAnyType());
                result.setStatus(ProvisioningReport.Status.SUCCESS);
                result.setUidValue(delta.getUid().getUidValue());
                if (!this.profile.isDryRun()) {
                    Exception output;
                    block11: {
                        for (InboundActions action : this.profile.getActions()) {
                            action.beforeDelete(this.profile, (LiveSyncDelta)delta, (EntityTO)before);
                        }
                        try {
                            this.getProvisioningManager().delete(match.getAny().getKey(), Set.of(((PullTask)this.profile.getTask()).getResource().getKey()), true, this.profile.getExecutor(), this.profile.getContext());
                            output = null;
                            resultStatus = OpEvent.Outcome.SUCCESS;
                            for (InboundActions action : this.profile.getActions()) {
                                action.after(this.profile, (LiveSyncDelta)delta, (EntityTO)before, result);
                            }
                        }
                        catch (Exception e) {
                            this.throwIgnoreProvisionException(delta, e);
                            result.setStatus(ProvisioningReport.Status.FAILURE);
                            result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                            LOG.error("Could not delete {} {}", new Object[]{provision.getAnyType(), match, e});
                            output = e;
                            if (!((PullTask)this.profile.getTask()).isRemediation()) break block11;
                            resultStatus = OpEvent.Outcome.SUCCESS;
                            this.createRemediation(provision.getAnyType(), match.getAny().getKey(), null, null, result, delta);
                        }
                    }
                    this.end(provision.getAnyType(), ResourceOperation.DELETE.name().toLowerCase(), resultStatus, before, output, delta, new Object[0]);
                    global = AbstractPullResultHandler.and(global, resultStatus);
                }
                this.profile.getResults().add(result);
            }
            catch (NotFoundException e) {
                LOG.error("Could not find {} {}", new Object[]{provision.getAnyType(), match, e});
            }
            catch (DelegatedAdministrationException e) {
                LOG.error("Not allowed to read {} {}", new Object[]{provision.getAnyType(), match, e});
            }
            catch (Exception e) {
                LOG.error("Could not delete {} {}", new Object[]{provision.getAnyType(), match, e});
            }
        }
        return global;
    }

    protected OpEvent.Outcome ignore(SyncDelta delta, List<InboundMatch> matches, Provision provision, boolean matching, String ... message) {
        LOG.debug("Any to ignore {}", (Object)delta.getObject().getUid().getUidValue());
        if (matches == null) {
            ProvisioningReport report = new ProvisioningReport();
            report.setKey(null);
            report.setName(delta.getObject().getUid().getUidValue());
            report.setOperation(ResourceOperation.NONE);
            report.setAnyType(provision.getAnyType());
            report.setStatus(ProvisioningReport.Status.SUCCESS);
            report.setUidValue(delta.getUid().getUidValue());
            if (message != null && message.length >= 1) {
                report.setMessage(message[0]);
            }
            this.profile.getResults().add(report);
        } else {
            matches.forEach(match -> {
                ProvisioningReport report = new ProvisioningReport();
                report.setKey(match.getAny().getKey());
                report.setName(delta.getObject().getUid().getUidValue());
                report.setOperation(ResourceOperation.NONE);
                report.setAnyType(provision.getAnyType());
                report.setStatus(ProvisioningReport.Status.SUCCESS);
                report.setUidValue(delta.getUid().getUidValue());
                if (message != null && message.length >= 1) {
                    report.setMessage(message[0]);
                }
                this.profile.getResults().add(report);
            });
        }
        this.end(provision.getAnyType(), matching ? MatchingRule.toOp((MatchingRule)MatchingRule.IGNORE) : UnmatchingRule.toOp((UnmatchingRule)UnmatchingRule.IGNORE), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
        return OpEvent.Outcome.SUCCESS;
    }

    protected OpEvent.Outcome handleAnys(SyncDelta delta, List<InboundMatch> matches, AnyTypeKind anyTypeKind, Provision provision) throws JobExecutionException {
        if (matches.isEmpty()) {
            LOG.debug("Nothing to do");
            return OpEvent.Outcome.SUCCESS;
        }
        OpEvent.Outcome result = OpEvent.Outcome.SUCCESS;
        block0 : switch (delta.getDeltaType()) {
            case CREATE: 
            case UPDATE: 
            case CREATE_OR_UPDATE: {
                if (matches.get(0).getAny() == null) {
                    switch (((PullTask)this.profile.getTask()).getUnmatchingRule()) {
                        case ASSIGN: 
                        case PROVISION: {
                            result = this.provision(((PullTask)this.profile.getTask()).getUnmatchingRule(), delta, anyTypeKind, provision);
                            break block0;
                        }
                        case IGNORE: {
                            result = this.ignore(delta, null, provision, false, new String[0]);
                            break block0;
                        }
                    }
                    break;
                }
                this.virSchemaDAO.findByResourceAndAnyType(((PullTask)this.profile.getTask()).getResource().getKey(), matches.get(0).getAny().getType().getKey()).forEach(vs -> {
                    Attribute attr = delta.getObject().getAttributeByName(vs.getExtAttrName());
                    matches.forEach(match -> {
                        VirAttrCacheKey cacheKey = VirAttrCacheKey.of(provision.getAnyType(), match.getAny().getKey(), vs.getKey());
                        if (attr == null) {
                            this.virAttrCache.remove((Object)cacheKey);
                        } else {
                            this.virAttrCache.put((Object)cacheKey, (Object)VirAttrCacheValue.of(attr.getValue()));
                        }
                    });
                });
                switch (((PullTask)this.profile.getTask()).getMatchingRule()) {
                    case UPDATE: {
                        result = this.update(delta, matches, provision);
                        break block0;
                    }
                    case DEPROVISION: 
                    case UNASSIGN: {
                        result = this.deprovision(((PullTask)this.profile.getTask()).getMatchingRule(), delta, matches, provision);
                        break block0;
                    }
                    case LINK: {
                        result = this.link(delta, matches, provision, false);
                        break block0;
                    }
                    case UNLINK: {
                        result = this.link(delta, matches, provision, true);
                        break block0;
                    }
                    case IGNORE: {
                        result = this.ignore(delta, matches, provision, true, new String[0]);
                        break block0;
                    }
                }
                break;
            }
            case DELETE: {
                result = matches.get(0).getAny() == null ? OpEvent.Outcome.SUCCESS : this.delete(delta, matches, provision);
                break;
            }
        }
        return result;
    }

    protected OpEvent.Outcome handleLinkedAccounts(SyncDelta delta, List<InboundMatch> matches, Provision provision) throws JobExecutionException {
        if (matches.isEmpty()) {
            LOG.debug("Nothing to do");
            return OpEvent.Outcome.SUCCESS;
        }
        LOG.warn("Unexpected linked accounts found for {}: {}", (Object)provision.getAnyType(), matches);
        return OpEvent.Outcome.SUCCESS;
    }

    protected OpEvent.Outcome doHandle(SyncDelta delta, Provision provision, AnyTypeKind anyTypeKind) throws JobExecutionException {
        LOG.debug("Process {} for {} as {}", new Object[]{delta.getDeltaType(), delta.getUid().getUidValue(), delta.getObject().getObjectClass()});
        SyncDelta finalDelta = delta;
        for (InboundActions action : this.profile.getActions()) {
            finalDelta = (SyncDelta)action.preprocess(this.profile, (LiveSyncDelta)finalDelta);
        }
        LOG.debug("Transformed {} for {} as {}", new Object[]{finalDelta.getDeltaType(), finalDelta.getUid().getUidValue(), finalDelta.getObject().getObjectClass()});
        OpEvent.Outcome result = OpEvent.Outcome.SUCCESS;
        try {
            List<InboundMatch> matches = this.inboundMatcher.match(finalDelta, ((PullTask)this.profile.getTask()).getResource(), provision, anyTypeKind);
            LOG.debug("Match(es) found for {} as {}: {}", new Object[]{finalDelta.getUid().getUidValue(), finalDelta.getObject().getObjectClass(), matches});
            if (matches.size() > 1) {
                switch (this.profile.getConflictResolutionAction()) {
                    case IGNORE: {
                        throw new IgnoreProvisionException("More than one match found for " + finalDelta.getObject().getUid().getUidValue() + ": " + String.valueOf(matches));
                    }
                    case FIRSTMATCH: {
                        matches = matches.subList(0, 1);
                        break;
                    }
                    case LASTMATCH: {
                        matches = matches.subList(matches.size() - 1, matches.size());
                        break;
                    }
                }
            }
            OpEvent.Outcome anys = this.handleAnys(finalDelta, matches.stream().filter(match -> match.getMatchTarget() == MatchType.ANY).toList(), anyTypeKind, provision);
            OpEvent.Outcome linkedAccounts = this.handleLinkedAccounts(finalDelta, matches.stream().filter(match -> match.getMatchTarget() == MatchType.LINKED_ACCOUNT).toList(), provision);
            result = AbstractPullResultHandler.and(anys, linkedAccounts);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
        return result;
    }

    protected void end(String anyType, String event, OpEvent.Outcome result, Object before, Object output, SyncDelta delta, Object ... furtherInput) {
        this.notificationManager.createTasks(this.profile.getExecutor(), OpEvent.CategoryType.PULL, anyType, ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta, furtherInput});
        this.auditManager.audit(AuthContextUtils.getDomain(), this.profile.getExecutor(), OpEvent.CategoryType.PULL, anyType, ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta, furtherInput});
    }

    protected void createRemediationIfNeeded(AnyUR anyUR, SyncDelta delta, ProvisioningReport result) {
        if (ProvisioningReport.Status.FAILURE == result.getStatus() && ((PullTask)this.profile.getTask()).isRemediation()) {
            this.createRemediation(result.getAnyType(), null, null, anyUR, result, delta);
        }
    }

    protected void createRemediation(String anyType, String anyKey, AnyCR anyCR, AnyUR anyUR, ProvisioningReport result, SyncDelta delta) {
        Remediation remediation = (Remediation)this.entityFactory.newEntity(Remediation.class);
        remediation.setAnyType((AnyType)this.anyTypeDAO.findById(anyType).orElseThrow(() -> new NotFoundException("AnyType " + anyType)));
        remediation.setOperation(anyUR == null ? ResourceOperation.CREATE : ResourceOperation.UPDATE);
        if (StringUtils.isNotBlank((CharSequence)anyKey)) {
            remediation.setPayload(anyKey);
        } else if (anyCR != null) {
            remediation.setPayload(anyCR);
        } else if (anyUR != null) {
            remediation.setPayload(anyUR);
        }
        remediation.setError(result.getMessage());
        remediation.setInstant(OffsetDateTime.now());
        remediation.setRemoteName(delta.getObject().getName().getNameValue());
        remediation.setPullTask((PullTask)this.taskDAO.findById(TaskType.PULL, ((PullTask)this.profile.getTask()).getKey()).map(PullTask.class::cast).orElse(null));
        remediation = (Remediation)this.remediationDAO.save((Entity)remediation);
        ProvisioningReport remediationResult = new ProvisioningReport();
        remediationResult.setOperation(remediation.getOperation());
        remediationResult.setAnyType(anyType);
        remediationResult.setStatus(ProvisioningReport.Status.FAILURE);
        remediationResult.setMessage(remediation.getError());
        if (StringUtils.isNotBlank((CharSequence)anyKey)) {
            remediationResult.setKey(anyKey);
        } else if (anyUR != null) {
            remediationResult.setKey(anyUR.getKey());
        }
        remediationResult.setUidValue(delta.getUid().getUidValue());
        remediationResult.setName(remediation.getRemoteName());
        this.profile.getResults().add(remediationResult);
    }
}

