/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskCallable;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class DefaultPropagationTaskCallable
implements PropagationTaskCallable {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationTaskCallable.class);
    @Autowired
    protected PropagationTaskExecutor taskExecutor;
    protected final String domain;
    protected final Collection<String> authorities;
    protected PropagationTaskInfo taskInfo;
    protected PropagationReporter reporter;
    protected String executor;

    public DefaultPropagationTaskCallable() {
        SecurityContext ctx = SecurityContextHolder.getContext();
        this.domain = AuthContextUtils.getDomain();
        this.authorities = ctx.getAuthentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
    }

    public void setTaskInfo(PropagationTaskInfo taskInfo) {
        this.taskInfo = taskInfo;
    }

    public void setReporter(PropagationReporter reporter) {
        this.reporter = reporter;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }

    public TaskExec<PropagationTask> call() {
        return (TaskExec)AuthContextUtils.callAs((String)this.domain, (String)this.executor, this.authorities, () -> {
            LOG.debug("Execution started for {}", (Object)this.taskInfo);
            TaskExec execution = this.taskExecutor.execute(this.taskInfo, this.reporter, this.executor);
            LOG.debug("Execution completed for {}, {}", (Object)this.taskInfo, (Object)execution);
            return execution;
        });
    }
}

