/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.task.PropagationData;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.BaseConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.retry.RetryException;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.backoff.ExponentialRandomBackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public abstract class AbstractPropagationTaskExecutor
implements PropagationTaskExecutor {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationTaskExecutor.class);
    protected final Map<String, RetryTemplate> retryTemplates = Collections.synchronizedMap(new HashMap());
    protected final ConnectorManager connectorManager;
    protected final ConnObjectUtils connObjectUtils;
    protected final TaskDAO taskDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final NotificationManager notificationManager;
    protected final AuditManager auditManager;
    protected final TaskDataBinder taskDataBinder;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final TaskUtilsFactory taskUtilsFactory;
    protected final OutboundMatcher outboundMatcher;
    protected final PlainAttrValidationManager validator;
    protected final ApplicationEventPublisher publisher;
    protected final Map<String, PropagationActions> perContextActions = new ConcurrentHashMap<String, PropagationActions>();

    public AbstractPropagationTaskExecutor(ConnectorManager connectorManager, ConnObjectUtils connObjectUtils, TaskDAO taskDAO, ExternalResourceDAO resourceDAO, PlainSchemaDAO plainSchemaDAO, NotificationManager notificationManager, AuditManager auditManager, TaskDataBinder taskDataBinder, AnyUtilsFactory anyUtilsFactory, TaskUtilsFactory taskUtilsFactory, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator, ApplicationEventPublisher publisher) {
        this.connectorManager = connectorManager;
        this.connObjectUtils = connObjectUtils;
        this.taskDAO = taskDAO;
        this.resourceDAO = resourceDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.notificationManager = notificationManager;
        this.auditManager = auditManager;
        this.taskDataBinder = taskDataBinder;
        this.anyUtilsFactory = anyUtilsFactory;
        this.taskUtilsFactory = taskUtilsFactory;
        this.outboundMatcher = outboundMatcher;
        this.validator = validator;
        this.publisher = publisher;
    }

    public void expireRetryTemplate(String resource) {
        this.retryTemplates.remove(resource);
    }

    protected List<PropagationActions> getPropagationActions(ExternalResource resource) {
        ArrayList<PropagationActions> result = new ArrayList<PropagationActions>();
        resource.getPropagationActions().forEach(impl -> {
            try {
                result.add((PropagationActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (PropagationActions)instance)));
            }
            catch (Exception e) {
                LOG.error("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    protected void checkMandatoryMissing(PropagationTaskInfo taskInfo, Set<Attribute> attrs, boolean enablePasswordCheck) {
        HashSet mandatoryAttrNames = new HashSet();
        Optional.ofNullable(AttributeUtil.find((String)"__MANDATORY_MISSING__", attrs)).ifPresent(missing -> {
            attrs.remove(missing);
            if (taskInfo.getOperation() == ResourceOperation.CREATE) {
                mandatoryAttrNames.addAll(enablePasswordCheck ? missing.getValue() : missing.getValue().stream().filter(v -> !OperationalAttributes.PASSWORD_NAME.equals(v)).toList());
            }
        });
        Optional.ofNullable(AttributeUtil.find((String)"__MANDATORY_NULL_OR_EMPTY__", attrs)).ifPresent(nullOrEmpty -> {
            attrs.remove(nullOrEmpty);
            mandatoryAttrNames.addAll(nullOrEmpty.getValue());
        });
        if (!mandatoryAttrNames.isEmpty()) {
            throw new IllegalArgumentException("Not attempted because there are mandatory attributes without value(s): " + String.valueOf(mandatoryAttrNames));
        }
    }

    protected Uid doCreate(PropagationTaskInfo taskInfo, Connector connector, AtomicReference<Boolean> propagationAttempted) {
        Set attrs = taskInfo.getPropagationData().getAttributes();
        this.checkMandatoryMissing(taskInfo, attrs, true);
        LOG.debug("Create {} on {}", (Object)attrs, (Object)taskInfo.getResource().getKey());
        Uid result = connector.create(taskInfo.getObjectClass(), attrs, null, propagationAttempted);
        taskInfo.getResource().getProvisionByAnyType(taskInfo.getAnyType()).filter(provision -> provision.getUidOnCreate() != null).ifPresent(provision -> {
            LOG.debug("Adding uidOnCreate [{}] attribute to [{}] on create", (Object)provision.getUidOnCreate(), (Object)taskInfo.getEntityKey());
            AnyUtils anyUtils = this.anyUtilsFactory.getInstance(taskInfo.getAnyTypeKind());
            anyUtils.addAttr(this.validator, taskInfo.getEntityKey(), (PlainSchema)this.plainSchemaDAO.findById(provision.getUidOnCreate()).orElseThrow(() -> new NotFoundException("PlainSchema " + provision.getUidOnCreate())), result.getUidValue());
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)((Any)anyUtils.dao().findById(taskInfo.getEntityKey()).orElseThrow(() -> new NotFoundException(String.valueOf(anyUtils.anyTypeKind()) + taskInfo.getEntityKey()))), AuthContextUtils.getDomain()));
        });
        return result;
    }

    protected Uid doUpdate(PropagationTaskInfo taskInfo, Connector connector, ConnectorObject beforeObj, AtomicReference<Boolean> propagationAttempted) {
        Uid result;
        Set attrs = taskInfo.getPropagationData().getAttributes();
        this.checkMandatoryMissing(taskInfo, attrs, false);
        LOG.debug("Update {} on {}", (Object)attrs, (Object)taskInfo.getResource().getKey());
        Name newName = AttributeUtil.getNameFromAttributes((Set)attrs);
        LOG.debug("Rename required with value {}", (Object)newName);
        if (beforeObj != null && newName != null && newName.equals((Object)beforeObj.getName()) && !newName.getNameValue().equals(beforeObj.getUid().getUidValue())) {
            LOG.debug("Remote object name unchanged");
            attrs.remove(newName);
        }
        Map<Object, Object> originalAttrMap = Map.of();
        if (beforeObj != null) {
            originalAttrMap = beforeObj.getAttributes().stream().collect(Collectors.toMap(attr -> attr.getName().toUpperCase(), Function.identity()));
            Map updateAttrMap = attrs.stream().collect(Collectors.toMap(attr -> attr.getName().toUpperCase(), Function.identity()));
            originalAttrMap.keySet().removeAll(updateAttrMap.keySet());
        }
        if (!originalAttrMap.isEmpty() && originalAttrMap.values().equals(attrs)) {
            LOG.debug("Don't need to propagate anything: {} is equal to {}", originalAttrMap.values(), (Object)attrs);
            result = AttributeUtil.getUidAttribute((Set)attrs);
        } else {
            LOG.debug("Attributes to update: {}", (Object)attrs);
            LOG.debug("Update {} on {}", (Object)attrs, (Object)taskInfo.getResource().getKey());
            result = connector.update(Optional.ofNullable(beforeObj).map(BaseConnectorObject::getObjectClass).orElseGet(() -> taskInfo.getObjectClass()), Optional.ofNullable(beforeObj).map(ConnectorObject::getUid).orElseGet(() -> new Uid(taskInfo.getOldConnObjectKey() == null ? taskInfo.getConnObjectKey() : taskInfo.getOldConnObjectKey())), attrs, null, propagationAttempted);
        }
        return result;
    }

    protected Uid doUpdateDelta(PropagationTaskInfo taskInfo, Set<AttributeDelta> modifications, Connector connector, AtomicReference<Boolean> propagationAttempted) {
        Uid uid = new Uid(taskInfo.getConnObjectKey());
        if (modifications.isEmpty()) {
            LOG.debug("Nothing to modify for {} on {}", (Object)uid, (Object)taskInfo.getResource().getKey());
        } else {
            LOG.debug("Update Delta {} for {} on {}", new Object[]{modifications, uid, taskInfo.getResource().getKey()});
            connector.updateDelta(taskInfo.getObjectClass(), uid, modifications, null, propagationAttempted);
        }
        return uid;
    }

    protected Uid createOrUpdate(PropagationTaskInfo taskInfo, boolean fetchRemoteObj, ConnectorObject beforeObj, Connector connector, AtomicReference<Boolean> propagationAttempted) {
        PropagationData propagationData = taskInfo.getPropagationData();
        if (propagationData.getAttributeDeltas() == null) {
            if (beforeObj != null) {
                return this.doUpdate(taskInfo, connector, beforeObj, propagationAttempted);
            }
            if (fetchRemoteObj || taskInfo.getOperation() == ResourceOperation.CREATE) {
                return this.doCreate(taskInfo, connector, propagationAttempted);
            }
            return this.doUpdate(taskInfo, connector, beforeObj, propagationAttempted);
        }
        return this.doUpdateDelta(taskInfo, propagationData.getAttributeDeltas(), connector, propagationAttempted);
    }

    protected Uid delete(PropagationTaskInfo taskInfo, boolean fetchRemoteObj, ConnectorObject beforeObj, Connector connector, AtomicReference<Boolean> propagationAttempted) {
        Uid result;
        if (fetchRemoteObj && beforeObj == null) {
            LOG.debug("{} not found on {}: ignoring delete", (Object)taskInfo.getConnObjectKey(), (Object)taskInfo.getResource().getKey());
            result = null;
        } else {
            ObjectClass objectClass = Optional.ofNullable(beforeObj).map(BaseConnectorObject::getObjectClass).orElseGet(() -> taskInfo.getObjectClass());
            Uid uid = Optional.ofNullable(beforeObj).map(ConnectorObject::getUid).orElseGet(() -> new Uid(taskInfo.getConnObjectKey()));
            LOG.debug("Delete {} on {}", (Object)uid, (Object)taskInfo.getResource().getKey());
            connector.delete(objectClass, uid, null, propagationAttempted);
            result = uid;
            taskInfo.getResource().getProvisionByAnyType(taskInfo.getAnyType()).filter(provision -> provision.getUidOnCreate() != null).ifPresent(provision -> {
                LOG.debug("Removing uidOnCreate [{}] attribute from [{}] on delete", (Object)provision.getUidOnCreate(), (Object)taskInfo.getEntityKey());
                AnyUtils anyUtils = this.anyUtilsFactory.getInstance(taskInfo.getAnyTypeKind());
                anyUtils.removeAttr(taskInfo.getEntityKey(), (PlainSchema)this.plainSchemaDAO.findById(provision.getUidOnCreate()).orElseThrow(() -> new NotFoundException("PlainSchema " + provision.getUidOnCreate())));
                this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)((Any)anyUtils.dao().findById(taskInfo.getEntityKey()).orElseThrow(() -> new NotFoundException(String.valueOf(anyUtils.anyTypeKind()) + taskInfo.getEntityKey()))), AuthContextUtils.getDomain()));
            });
        }
        return result;
    }

    protected Optional<RetryTemplate> retryTemplate(ExternalResource resource) {
        RetryTemplate retryTemplate = null;
        if (resource.getPropagationPolicy() != null && (retryTemplate = this.retryTemplates.get(resource.getKey())) == null) {
            retryTemplate = new RetryTemplate();
            SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy();
            retryPolicy.setMaxAttempts(resource.getPropagationPolicy().getMaxAttempts());
            retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
            String[] params = resource.getPropagationPolicy().getBackOffParams().split(";");
            switch (resource.getPropagationPolicy().getBackOffStrategy()) {
                case EXPONENTIAL: {
                    ExponentialBackOffPolicy eBackOffPolicy = new ExponentialBackOffPolicy();
                    if (params.length > 0) {
                        try {
                            eBackOffPolicy.setInitialInterval(Long.parseLong(params[0]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to long: {}", (Object)params[0], (Object)e);
                        }
                    }
                    if (params.length > 1) {
                        try {
                            eBackOffPolicy.setMaxInterval(Long.parseLong(params[1]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to long: {}", (Object)params[1], (Object)e);
                        }
                    }
                    if (params.length > 2) {
                        try {
                            eBackOffPolicy.setMultiplier(Double.parseDouble(params[2]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to double: {}", (Object)params[2], (Object)e);
                        }
                    }
                    retryTemplate.setBackOffPolicy((BackOffPolicy)eBackOffPolicy);
                    break;
                }
                case RANDOM: {
                    ExponentialRandomBackOffPolicy erBackOffPolicy = new ExponentialRandomBackOffPolicy();
                    if (params.length > 0) {
                        try {
                            erBackOffPolicy.setInitialInterval(Long.parseLong(params[0]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to long: {}", (Object)params[0], (Object)e);
                        }
                    }
                    if (params.length > 1) {
                        try {
                            erBackOffPolicy.setMaxInterval(Long.parseLong(params[1]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to long: {}", (Object)params[1], (Object)e);
                        }
                    }
                    if (params.length > 2) {
                        try {
                            erBackOffPolicy.setMultiplier(Double.parseDouble(params[2]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to double: {}", (Object)params[2], (Object)e);
                        }
                    }
                    retryTemplate.setBackOffPolicy((BackOffPolicy)erBackOffPolicy);
                    break;
                }
                default: {
                    FixedBackOffPolicy fBackOffPolicy = new FixedBackOffPolicy();
                    if (params.length > 0) {
                        try {
                            fBackOffPolicy.setBackOffPeriod(Long.parseLong(params[0]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to long: {}", (Object)params[0], (Object)e);
                        }
                    }
                    retryTemplate.setBackOffPolicy((BackOffPolicy)fBackOffPolicy);
                }
            }
            this.retryTemplates.put(resource.getKey(), retryTemplate);
        }
        return Optional.ofNullable(retryTemplate);
    }

    public TaskExec<PropagationTask> execute(PropagationTaskInfo taskInfo, PropagationReporter reporter, String executor) {
        return this.retryTemplate(taskInfo.getResource()).map(rt -> (TaskExec)rt.execute(context -> {
            LOG.debug("#{} Propagation attempt", (Object)context.getRetryCount());
            TaskExec<PropagationTask> exec = this.doExecute(taskInfo, reporter, executor);
            if (context.getRetryCount() < taskInfo.getResource().getPropagationPolicy().getMaxAttempts() - 1 && !ExecStatus.SUCCESS.name().equals(exec.getStatus())) {
                throw new RetryException("Attempt #" + context.getRetryCount() + " failed");
            }
            return exec;
        })).orElseGet(() -> this.doExecute(taskInfo, reporter, executor));
    }

    protected boolean isFetchRemoteObj(PropagationTaskInfo taskInfo) {
        return Optional.ofNullable(taskInfo.getResource().getPropagationPolicy()).map(PropagationPolicy::isFetchAroundProvisioning).orElse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskExec<PropagationTask> doExecute(PropagationTaskInfo taskInfo, PropagationReporter reporter, String executor) {
        Object fiql;
        OpEvent.Outcome result;
        Uid uid;
        OrgUnit orgUnit;
        Provision provision;
        ConnectorObject afterObj;
        ConnectorObject beforeObj;
        boolean fetchRemoteObj;
        Object failureReason;
        String taskExecutionMessage;
        TaskExec exec;
        OffsetDateTime start;
        List<PropagationActions> actions;
        Connector connector;
        block28: {
            connector = taskInfo.getConnector() == null ? this.connectorManager.getConnector(taskInfo.getResource()) : taskInfo.getConnector();
            actions = this.getPropagationActions(taskInfo.getResource());
            start = OffsetDateTime.now();
            exec = this.taskUtilsFactory.getInstance(TaskType.PROPAGATION).newTaskExec();
            exec.setStatus(ExecStatus.CREATED.name());
            exec.setExecutor(executor);
            taskExecutionMessage = null;
            failureReason = null;
            AtomicReference<Boolean> propagationAttempted = new AtomicReference<Boolean>(false);
            fetchRemoteObj = this.isFetchRemoteObj(taskInfo);
            beforeObj = null;
            afterObj = null;
            provision = null;
            orgUnit = null;
            uid = null;
            try {
                provision = taskInfo.getResource().getProvisionByObjectClass(taskInfo.getObjectClass().getObjectClassValue()).orElse(null);
                orgUnit = taskInfo.getResource().getOrgUnit();
                if (taskInfo.getBeforeObj().isEmpty()) {
                    if (fetchRemoteObj) {
                        beforeObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(taskInfo, connector, provision, actions, false) : this.getRemoteObject(taskInfo, connector, orgUnit, actions, false));
                        taskInfo.setBeforeObj(Optional.ofNullable(beforeObj));
                    }
                } else {
                    beforeObj = (ConnectorObject)taskInfo.getBeforeObj().get();
                }
                actions.forEach(action -> action.before(taskInfo));
                switch (taskInfo.getOperation()) {
                    case CREATE: 
                    case UPDATE: {
                        uid = this.createOrUpdate(taskInfo, fetchRemoteObj, beforeObj, connector, propagationAttempted);
                        break;
                    }
                    case DELETE: {
                        uid = this.delete(taskInfo, fetchRemoteObj, beforeObj, connector, propagationAttempted);
                        break;
                    }
                }
                exec.setStatus(propagationAttempted.get() != false ? ExecStatus.SUCCESS.name() : ExecStatus.NOT_ATTEMPTED.name());
                result = OpEvent.Outcome.SUCCESS;
                LOG.debug("Successfully propagated to {}", (Object)taskInfo.getResource());
                if (uid == null) break block28;
            }
            catch (Exception e) {
                block29: {
                    try {
                        result = OpEvent.Outcome.FAILURE;
                        exec.setStatus(ExecStatus.FAILURE.name());
                        propagationAttempted.set(true);
                        LOG.error("Exception during provision on resource {}", (Object)taskInfo.getResource().getKey(), (Object)e);
                        if (e instanceof ConnectorException && e.getCause() != null) {
                            taskExecutionMessage = e.getCause().getMessage();
                            failureReason = e.getCause().getMessage() == null ? e.getMessage() : e.getMessage() + "\n\n Cause: " + e.getCause().getMessage().split("\n")[0];
                        } else {
                            taskExecutionMessage = ExceptionUtils2.getFullStackTrace((Throwable)e);
                            failureReason = e.getCause() == null ? e.getMessage() : e.getMessage() + "\n\n Cause: " + e.getCause().getMessage().split("\n")[0];
                        }
                        actions.forEach(action -> action.onError(taskInfo, exec, e));
                        if (uid == null) break block29;
                    }
                    catch (Throwable throwable) {
                        if (uid != null) {
                            taskInfo.setConnObjectKey(uid.getUidValue());
                        }
                        if (fetchRemoteObj) {
                            try {
                                afterObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(taskInfo, connector, provision, actions, true) : this.getRemoteObject(taskInfo, connector, orgUnit, actions, true));
                            }
                            catch (Exception ignore) {
                                LOG.error("Error retrieving after object", (Throwable)ignore);
                            }
                        }
                        if (!ExecStatus.FAILURE.name().equals(exec.getStatus()) && afterObj == null && uid != null && taskInfo.getOperation() != ResourceOperation.DELETE) {
                            afterObj = new ConnectorObjectBuilder().setObjectClass(taskInfo.getObjectClass()).setUid(uid).setName(Optional.ofNullable(AttributeUtil.getNameFromAttributes((Set)taskInfo.getPropagationData().getAttributes())).orElseGet(() -> new Name(taskInfo.getConnObjectKey()))).build();
                        }
                        exec.setStart(start);
                        exec.setMessage(taskExecutionMessage);
                        exec.setEnd(OffsetDateTime.now());
                        LOG.debug("Execution finished: {}", (Object)exec);
                        this.hasToBeregistered(taskInfo, (TaskExec<PropagationTask>)exec).ifPresent(task -> {
                            LOG.debug("Execution to be stored: {}", (Object)exec);
                            exec.setTask((Task)task);
                            task.add(exec);
                            taskInfo.setKey(((PropagationTask)this.taskDAO.save((Entity)task)).getKey());
                        });
                        String fiql2 = provision == null ? null : (afterObj != null ? this.outboundMatcher.getFIQL(afterObj, taskInfo.getResource(), provision) : (beforeObj != null ? this.outboundMatcher.getFIQL(beforeObj, taskInfo.getResource(), provision) : null));
                        reporter.onSuccessOrNonPriorityResourceFailures(taskInfo, ExecStatus.valueOf((String)exec.getStatus()), (String)failureReason, fiql2, beforeObj, afterObj);
                        throw throwable;
                    }
                    taskInfo.setConnObjectKey(uid.getUidValue());
                }
                if (fetchRemoteObj) {
                    try {
                        afterObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(taskInfo, connector, provision, actions, true) : this.getRemoteObject(taskInfo, connector, orgUnit, actions, true));
                    }
                    catch (Exception ignore) {
                        LOG.error("Error retrieving after object", (Throwable)ignore);
                    }
                }
                if (!ExecStatus.FAILURE.name().equals(exec.getStatus()) && afterObj == null && uid != null && taskInfo.getOperation() != ResourceOperation.DELETE) {
                    afterObj = new ConnectorObjectBuilder().setObjectClass(taskInfo.getObjectClass()).setUid(uid).setName(Optional.ofNullable(AttributeUtil.getNameFromAttributes((Set)taskInfo.getPropagationData().getAttributes())).orElseGet(() -> new Name(taskInfo.getConnObjectKey()))).build();
                }
                exec.setStart(start);
                exec.setMessage(taskExecutionMessage);
                exec.setEnd(OffsetDateTime.now());
                LOG.debug("Execution finished: {}", (Object)exec);
                this.hasToBeregistered(taskInfo, (TaskExec<PropagationTask>)exec).ifPresent(task -> {
                    LOG.debug("Execution to be stored: {}", (Object)exec);
                    exec.setTask((Task)task);
                    task.add(exec);
                    taskInfo.setKey(((PropagationTask)this.taskDAO.save((Entity)task)).getKey());
                });
                fiql = provision == null ? null : (afterObj != null ? this.outboundMatcher.getFIQL(afterObj, taskInfo.getResource(), provision) : (beforeObj != null ? this.outboundMatcher.getFIQL(beforeObj, taskInfo.getResource(), provision) : null));
                reporter.onSuccessOrNonPriorityResourceFailures(taskInfo, ExecStatus.valueOf((String)exec.getStatus()), (String)failureReason, (String)fiql, beforeObj, afterObj);
            }
            taskInfo.setConnObjectKey(uid.getUidValue());
        }
        if (fetchRemoteObj) {
            try {
                afterObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(taskInfo, connector, provision, actions, true) : this.getRemoteObject(taskInfo, connector, orgUnit, actions, true));
            }
            catch (Exception ignore) {
                LOG.error("Error retrieving after object", (Throwable)ignore);
            }
        }
        if (!ExecStatus.FAILURE.name().equals(exec.getStatus()) && afterObj == null && uid != null && taskInfo.getOperation() != ResourceOperation.DELETE) {
            afterObj = new ConnectorObjectBuilder().setObjectClass(taskInfo.getObjectClass()).setUid(uid).setName(Optional.ofNullable(AttributeUtil.getNameFromAttributes((Set)taskInfo.getPropagationData().getAttributes())).orElseGet(() -> new Name(taskInfo.getConnObjectKey()))).build();
        }
        exec.setStart(start);
        exec.setMessage(taskExecutionMessage);
        exec.setEnd(OffsetDateTime.now());
        LOG.debug("Execution finished: {}", (Object)exec);
        this.hasToBeregistered(taskInfo, (TaskExec<PropagationTask>)exec).ifPresent(task -> {
            LOG.debug("Execution to be stored: {}", (Object)exec);
            exec.setTask((Task)task);
            task.add(exec);
            taskInfo.setKey(((PropagationTask)this.taskDAO.save((Entity)task)).getKey());
        });
        fiql = provision == null ? null : (afterObj != null ? this.outboundMatcher.getFIQL(afterObj, taskInfo.getResource(), provision) : (beforeObj != null ? this.outboundMatcher.getFIQL(beforeObj, taskInfo.getResource(), provision) : null));
        reporter.onSuccessOrNonPriorityResourceFailures(taskInfo, ExecStatus.valueOf((String)exec.getStatus()), (String)failureReason, (String)fiql, beforeObj, afterObj);
        for (PropagationActions action2 : actions) {
            action2.after(taskInfo, exec, afterObj);
        }
        String anyTypeKind = Optional.ofNullable(taskInfo.getAnyTypeKind()).map(Enum::name).orElse("realm");
        String operation = taskInfo.getOperation().name().toLowerCase();
        boolean notificationsAvailable = this.notificationManager.notificationsAvailable(AuthContextUtils.getDomain(), OpEvent.CategoryType.PROPAGATION, anyTypeKind, taskInfo.getResource().getKey(), operation);
        boolean auditRequested = this.auditManager.auditRequested(AuthContextUtils.getDomain(), AuthContextUtils.getUsername(), OpEvent.CategoryType.PROPAGATION, anyTypeKind, taskInfo.getResource().getKey(), operation);
        if (notificationsAvailable || auditRequested) {
            ExecTO execTO = this.taskDataBinder.getExecTO(exec);
            AfterHandlingEvent event = new AfterHandlingEvent(AuthContextUtils.getDomain(), AuthContextUtils.getWho(), OpEvent.CategoryType.PROPAGATION, anyTypeKind, taskInfo.getResource().getKey(), operation, result, (Object)beforeObj, (Object)new Object[]{execTO, afterObj}, new Object[]{taskInfo});
            this.notificationManager.createTasks(event);
            this.auditManager.audit(event);
        }
        return exec;
    }

    protected TaskExec<PropagationTask> rejected(PropagationTaskInfo taskInfo, String rejectReason, PropagationReporter reporter, String executor) {
        TaskExec execution = this.taskUtilsFactory.getInstance(TaskType.PROPAGATION).newTaskExec();
        execution.setStatus(ExecStatus.NOT_ATTEMPTED.name());
        execution.setExecutor(executor);
        execution.setStart(OffsetDateTime.now());
        execution.setMessage(rejectReason);
        execution.setEnd(execution.getStart());
        this.hasToBeregistered(taskInfo, (TaskExec<PropagationTask>)execution).ifPresent(task -> {
            LOG.debug("Execution to be stored: {}", (Object)execution);
            execution.setTask((Task)task);
            task.add(execution);
            this.taskDAO.save((Entity)task);
        });
        reporter.onSuccessOrNonPriorityResourceFailures(taskInfo, ExecStatus.valueOf((String)execution.getStatus()), rejectReason, null, null, null);
        return execution;
    }

    protected Optional<PropagationTask> hasToBeregistered(PropagationTaskInfo taskInfo, TaskExec<PropagationTask> execution) {
        boolean result;
        boolean failed = ExecStatus.valueOf((String)execution.getStatus()) != ExecStatus.SUCCESS;
        ExternalResource resource = taskInfo.getResource();
        switch (taskInfo.getOperation()) {
            case CREATE: {
                boolean bl;
                if (resource.getCreateTraceLevel() == TraceLevel.ALL || failed && resource.getCreateTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case UPDATE: {
                boolean bl;
                if (resource.getUpdateTraceLevel() == TraceLevel.ALL || failed && resource.getUpdateTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case DELETE: {
                boolean bl;
                if (resource.getDeleteTraceLevel() == TraceLevel.ALL || failed && resource.getDeleteTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = result = false;
            }
        }
        if (!result) {
            return Optional.empty();
        }
        PropagationTask task = Optional.ofNullable(taskInfo.getKey()).flatMap(key -> this.taskDAO.findById(TaskType.PROPAGATION, key)).map(PropagationTask.class::cast).orElseGet(() -> {
            PropagationTask t = (PropagationTask)this.taskUtilsFactory.getInstance(TaskType.PROPAGATION).newTask();
            t.setResource((ExternalResource)this.resourceDAO.findById(resource.getKey()).orElseThrow(() -> new NotFoundException("Resource " + resource.getKey())));
            t.setObjectClassName(taskInfo.getObjectClass().getObjectClassValue());
            t.setAnyTypeKind(taskInfo.getAnyTypeKind());
            t.setAnyType(taskInfo.getAnyType());
            t.setEntityKey(taskInfo.getEntityKey());
            t.setOperation(taskInfo.getOperation());
            t.setConnObjectKey(taskInfo.getConnObjectKey());
            t.setOldConnObjectKey(taskInfo.getOldConnObjectKey());
            return t;
        });
        task.setPropagationData(taskInfo.getPropagationData());
        return Optional.of(task);
    }

    protected ConnectorObject getRemoteObject(PropagationTaskInfo taskInfo, Connector connector, Provision provision, List<PropagationActions> actions, boolean latest) {
        String connObjectKeyValue = latest || taskInfo.getOldConnObjectKey() == null ? taskInfo.getConnObjectKey() : taskInfo.getOldConnObjectKey();
        List<ConnectorObject> matches = this.outboundMatcher.match(taskInfo, connector, provision, actions, connObjectKeyValue);
        LOG.debug("Found for propagation task {}: {}", (Object)taskInfo, matches);
        return matches.isEmpty() ? null : matches.get(0);
    }

    protected ConnectorObject getRemoteObject(PropagationTaskInfo taskInfo, Connector connector, OrgUnit orgUnit, List<PropagationActions> actions, boolean latest) {
        String connObjectKey = latest || taskInfo.getOldConnObjectKey() == null ? taskInfo.getConnObjectKey() : taskInfo.getOldConnObjectKey();
        HashSet moreAttrsToGet = new HashSet();
        actions.forEach(action -> moreAttrsToGet.addAll(action.moreAttrsToGet(Optional.of(taskInfo), orgUnit)));
        ConnectorObject obj = null;
        Optional connObjectKeyItem = orgUnit.getConnObjectKeyItem();
        if (connObjectKeyItem.isPresent()) {
            try {
                obj = connector.getObject(taskInfo.getObjectClass(), AttributeBuilder.build((String)((Item)connObjectKeyItem.get()).getExtAttrName(), (Object[])new Object[]{connObjectKey}), orgUnit.isIgnoreCaseMatch(), MappingUtils.buildOperationOptions(MappingUtils.getPropagationItems(orgUnit.getItems().stream()), (String[])moreAttrsToGet.toArray(String[]::new)));
            }
            catch (TimeoutException toe) {
                LOG.debug("Request timeout", (Throwable)toe);
                throw toe;
            }
            catch (RuntimeException ignore) {
                LOG.debug("While resolving {}", (Object)connObjectKey, (Object)ignore);
            }
        }
        return obj;
    }
}

