/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.notification;

import java.lang.runtime.SwitchBootstraps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyAbout;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.notification.RecipientsProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class DefaultNotificationManager
implements NotificationManager {
    protected static final Logger LOG = LoggerFactory.getLogger(NotificationManager.class);
    protected final DerSchemaDAO derSchemaDAO;
    protected final VirSchemaDAO virSchemaDAO;
    protected final NotificationDAO notificationDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnySearchDAO anySearchDAO;
    protected final AnyMatchDAO anyMatchDAO;
    protected final TaskDAO taskDAO;
    protected final DerAttrHandler derAttrHandler;
    protected final VirAttrHandler virAttrHandler;
    protected final UserDataBinder userDataBinder;
    protected final GroupDataBinder groupDataBinder;
    protected final AnyObjectDataBinder anyObjectDataBinder;
    protected final ConfParamOps confParamOps;
    protected final EntityFactory entityFactory;
    protected final IntAttrNameParser intAttrNameParser;
    protected final SearchCondVisitor searchCondVisitor;
    protected Optional<RecipientsProvider> perContextRecipientsProvider = Optional.empty();

    public DefaultNotificationManager(DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, NotificationDAO notificationDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, AnyMatchDAO anyMatchDAO, TaskDAO taskDAO, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, UserDataBinder userDataBinder, GroupDataBinder groupDataBinder, AnyObjectDataBinder anyObjectDataBinder, ConfParamOps confParamOps, EntityFactory entityFactory, IntAttrNameParser intAttrNameParser, SearchCondVisitor searchCondVisitor) {
        this.derSchemaDAO = derSchemaDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.notificationDAO = notificationDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anySearchDAO = anySearchDAO;
        this.anyMatchDAO = anyMatchDAO;
        this.taskDAO = taskDAO;
        this.derAttrHandler = derAttrHandler;
        this.virAttrHandler = virAttrHandler;
        this.userDataBinder = userDataBinder;
        this.groupDataBinder = groupDataBinder;
        this.anyObjectDataBinder = anyObjectDataBinder;
        this.confParamOps = confParamOps;
        this.entityFactory = entityFactory;
        this.intAttrNameParser = intAttrNameParser;
        this.searchCondVisitor = searchCondVisitor;
    }

    @Transactional(readOnly=true)
    public long getMaxRetries() {
        return (Long)this.confParamOps.get("Master", "notification.maxRetries", (Object)0L, Long.class);
    }

    protected NotificationTask getNotificationTask(Notification notification, Any<?> any, Map<String, Object> jexlVars) {
        jexlVars.put("syncopeConf", this.confParamOps.list("Master"));
        jexlVars.put("events", notification.getEvents());
        Optional.ofNullable(any).ifPresent(arg_0 -> ((VirAttrHandler)this.virAttrHandler).getValues(arg_0));
        ArrayList<User> recipients = new ArrayList<User>();
        Optional.ofNullable(notification.getRecipientsFIQL()).ifPresent(fiql -> recipients.addAll(this.anySearchDAO.search(SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)fiql, (String[])new String[0]), List.of(), AnyTypeKind.USER)));
        if (notification.isSelfAsRecipient() && any instanceof User) {
            recipients.add((User)any);
        }
        HashSet recipientEmails = new HashSet();
        ArrayList recipientTOs = new ArrayList(recipients.size());
        recipients.forEach(recipient -> {
            this.virAttrHandler.getValues((Any)recipient);
            Optional.ofNullable(this.getRecipientEmail(notification.getRecipientAttrName(), (User)recipient)).ifPresentOrElse(email -> {
                recipientEmails.add(email);
                recipientTOs.add(this.userDataBinder.getUserTO(recipient, true));
            }, () -> LOG.warn("{} cannot be notified: {} not found", recipient, (Object)notification.getRecipientAttrName()));
        });
        jexlVars.put("recipients", recipientTOs);
        Optional.ofNullable(notification.getStaticRecipients()).ifPresent(recipientEmails::addAll);
        Optional.ofNullable(notification.getRecipientsProvider()).ifPresent(impl -> {
            try {
                RecipientsProvider recipientsProvider = (RecipientsProvider)ImplementationManager.build((Implementation)impl, () -> this.perContextRecipientsProvider.orElse(null), instance -> {
                    this.perContextRecipientsProvider = Optional.of(instance);
                });
                recipientEmails.addAll(recipientsProvider.provideRecipients(notification, any, jexlVars));
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)notification.getRecipientsProvider(), (Object)e);
            }
        });
        MapContext ctx = new MapContext(jexlVars);
        NotificationTask task = (NotificationTask)this.entityFactory.newEntity(NotificationTask.class);
        task.setNotification(notification);
        Optional.ofNullable(any).ifPresent(a -> {
            task.setEntityKey(a.getKey());
            task.setAnyTypeKind(a.getType().getKind());
        });
        task.setTraceLevel(notification.getTraceLevel());
        task.getRecipients().addAll(recipientEmails);
        task.setSender(notification.getSender());
        task.setSubject(JexlUtils.evaluateTemplate((String)notification.getSubject(), (JexlContext)ctx));
        if (StringUtils.isNotBlank((CharSequence)notification.getTemplate().getTextTemplate())) {
            task.setTextBody(JexlUtils.evaluateTemplate((String)notification.getTemplate().getTextTemplate(), (JexlContext)ctx));
        }
        if (StringUtils.isNotBlank((CharSequence)notification.getTemplate().getHTMLTemplate())) {
            task.setHtmlBody(JexlUtils.evaluateTemplate((String)notification.getTemplate().getHTMLTemplate(), (JexlContext)ctx));
        }
        return task;
    }

    public boolean notificationsAvailable(String domain, OpEvent.CategoryType type, String category, String subcategory, String op) {
        String successEvent = OpEvent.toString((OpEvent.CategoryType)type, (String)category, (String)subcategory, (String)op, (OpEvent.Outcome)OpEvent.Outcome.SUCCESS);
        String failureEvent = OpEvent.toString((OpEvent.CategoryType)type, (String)category, (String)subcategory, (String)op, (OpEvent.Outcome)OpEvent.Outcome.FAILURE);
        return (Boolean)AuthContextUtils.callAsAdmin((String)domain, () -> this.notificationDAO.findAll().stream().anyMatch(notification -> notification.isActive() && (notification.getEvents().contains(successEvent) || notification.getEvents().contains(failureEvent))));
    }

    public void createTasks(AfterHandlingEvent event) {
        AuthContextUtils.runAsAdmin((String)event.getDomain(), () -> this.createTasks(event.getWho(), event.getType(), event.getCategory(), event.getSubcategory(), event.getOp(), event.getOutcome(), event.getBefore(), event.getOutput(), event.getInput()));
    }

    public List<NotificationTask> createTasks(String who, OpEvent.CategoryType type, String category, String subcategory, String op, OpEvent.Outcome outcome, Object before, Object output, Object ... input) {
        Optional any = Optional.empty();
        if (before instanceof UserTO) {
            UserTO userTO = (UserTO)before;
            any = this.userDAO.findById(userTO.getKey());
        } else if (output instanceof UserTO) {
            UserTO userTO = (UserTO)output;
            any = this.userDAO.findById(userTO.getKey());
        } else if (output instanceof Pair && ((Pair)output).getRight() instanceof UserTO) {
            any = this.userDAO.findById(((UserTO)((Pair)output).getRight()).getKey());
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getEntity() instanceof UserTO) {
            any = this.userDAO.findById(((ProvisioningResult)output).getEntity().getKey());
        } else if (before instanceof AnyObjectTO) {
            AnyObjectTO anyObjectTO = (AnyObjectTO)before;
            any = this.anyObjectDAO.findById(anyObjectTO.getKey());
        } else if (output instanceof AnyObjectTO) {
            AnyObjectTO anyObjectTO = (AnyObjectTO)output;
            any = this.anyObjectDAO.findById(anyObjectTO.getKey());
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getEntity() instanceof AnyObjectTO) {
            any = this.anyObjectDAO.findById(((ProvisioningResult)output).getEntity().getKey());
        } else if (before instanceof GroupTO) {
            GroupTO groupTO = (GroupTO)before;
            any = this.groupDAO.findById(groupTO.getKey());
        } else if (output instanceof GroupTO) {
            GroupTO groupTO = (GroupTO)output;
            any = this.groupDAO.findById(groupTO.getKey());
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getEntity() instanceof GroupTO) {
            any = this.groupDAO.findById(((ProvisioningResult)output).getEntity().getKey());
        }
        AnyType anyType = any.map(Any::getType).orElse(null);
        LOG.debug("Search notification for [{}]{}", (Object)anyType, (Object)any);
        ArrayList<NotificationTask> notifications = new ArrayList<NotificationTask>();
        for (Notification notification : this.notificationDAO.findAll()) {
            if (LOG.isDebugEnabled()) {
                notification.getAbouts().forEach(a -> LOG.debug("Notification about {} defined: {}", (Object)a.getAnyType(), (Object)a.get()));
            }
            if (notification.isActive()) {
                String currentEvent = OpEvent.toString((OpEvent.CategoryType)type, (String)category, (String)subcategory, (String)op, (OpEvent.Outcome)outcome);
                if (!notification.getEvents().contains(currentEvent)) {
                    LOG.debug("No events found about {}", (Object)any);
                    continue;
                }
                if (anyType != null && !any.isEmpty() && !notification.getAbout(anyType).isEmpty() && !this.anyMatchDAO.matches((Any)any.get(), SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)((AnyAbout)notification.getAbout(anyType).get()).get(), (String[])new String[0]))) continue;
                LOG.debug("Creating notification task for event {} about {}", (Object)currentEvent, (Object)any);
                HashMap<String, Object> jexlVars = new HashMap<String, Object>();
                jexlVars.put("who", who);
                jexlVars.put("type", type);
                jexlVars.put("category", category);
                jexlVars.put("subcategory", subcategory);
                jexlVars.put("event", op);
                jexlVars.put("condition", outcome);
                jexlVars.put("before", before);
                jexlVars.put("output", output);
                jexlVars.put("input", input);
                any.ifPresent(a -> {
                    Any any = a;
                    Objects.requireNonNull(any);
                    Any selector0$temp = any;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{User.class, Group.class, AnyObject.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            User user = (User)selector0$temp;
                            jexlVars.put("user", this.userDataBinder.getUserTO(user, true));
                            break;
                        }
                        case 1: {
                            Group group = (Group)selector0$temp;
                            jexlVars.put("group", this.groupDataBinder.getGroupTO(group, true));
                            break;
                        }
                        case 2: {
                            AnyObject anyObject = (AnyObject)selector0$temp;
                            jexlVars.put("anyObject", this.anyObjectDataBinder.getAnyObjectTO(anyObject, true));
                            break;
                        }
                    }
                });
                NotificationTask notificationTask = this.getNotificationTask(notification, any.orElse(null), jexlVars);
                notificationTask = (NotificationTask)this.taskDAO.save((Entity)notificationTask);
                notifications.add(notificationTask);
                continue;
            }
            LOG.debug("Notification {} is not active, task will not be created", (Object)notification.getKey());
        }
        return notifications;
    }

    protected String getRecipientEmail(String recipientAttrName, User user) {
        IntAttrName intAttrName;
        String email = null;
        try {
            intAttrName = this.intAttrNameParser.parse(recipientAttrName, AnyTypeKind.USER);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified as recipient, ignoring", (Object)recipientAttrName, (Object)e);
            return null;
        }
        if ("username".equals(intAttrName.getField())) {
            email = user.getUsername();
        } else if (intAttrName.getSchemaType() != null) {
            UMembership membership = Optional.ofNullable(intAttrName.getMembershipOfGroup()).flatMap(arg_0 -> ((GroupDAO)this.groupDAO).findByName(arg_0)).flatMap(group -> user.getMembership(group.getKey())).orElse(null);
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    Optional attr = membership == null ? user.getPlainAttr(recipientAttrName) : user.getPlainAttr(recipientAttrName, (Membership)membership);
                    email = attr.map(a -> a.getValuesAsStrings().isEmpty() ? null : (String)a.getValuesAsStrings().get(0)).orElse(null);
                    break;
                }
                case DERIVED: {
                    email = this.derSchemaDAO.findById(recipientAttrName).map(derSchema -> membership == null ? this.derAttrHandler.getValue((Any)user, derSchema) : this.derAttrHandler.getValue((Any)user, (Membership)membership, derSchema)).orElse(null);
                    break;
                }
                case VIRTUAL: {
                    email = this.virSchemaDAO.findById(recipientAttrName).map(virSchema -> {
                        List virAttrValues = membership == null ? this.virAttrHandler.getValues((Any)user, virSchema) : this.virAttrHandler.getValues((Any)user, (Membership)membership, virSchema);
                        return virAttrValues.isEmpty() ? null : (String)virAttrValues.get(0);
                    }).orElse(null);
                    break;
                }
            }
        }
        return email;
    }

    public TaskExec<NotificationTask> storeExec(TaskExec<NotificationTask> execution) {
        NotificationTask task = this.taskDAO.findById(TaskType.NOTIFICATION, ((NotificationTask)execution.getTask()).getKey()).map(NotificationTask.class::cast).orElseThrow(() -> new NotFoundException("NotificationTask " + ((NotificationTask)execution.getTask()).getKey()));
        task.add(execution);
        task.setExecuted(true);
        this.taskDAO.save((Entity)task);
        return execution;
    }

    public void setTaskExecuted(String taskKey, boolean executed) {
        NotificationTask task = this.taskDAO.findById(TaskType.NOTIFICATION, taskKey).map(NotificationTask.class::cast).orElseThrow(() -> new NotFoundException("NotificationTask " + taskKey));
        task.setExecuted(executed);
        this.taskDAO.save((Entity)task);
    }

    public long countExecutionsWithStatus(String taskKey, String status) {
        NotificationTask task = this.taskDAO.findById(TaskType.NOTIFICATION, taskKey).map(NotificationTask.class::cast).orElseThrow(() -> new NotFoundException("NotificationTask " + taskKey));
        long count = 0L;
        for (TaskExec taskExec : task.getExecs()) {
            if (status == null) {
                if (taskExec.getStatus() != null) continue;
                ++count;
                continue;
            }
            if (!status.equals(taskExec.getStatus())) continue;
            ++count;
        }
        return count;
    }
}

