/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.job.report.ReportJobDelegate;
import org.apache.syncope.core.provisioning.java.job.Job;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ReportJob
extends Job {
    private static final Logger LOG = LoggerFactory.getLogger(ReportJob.class);
    private final Map<String, ReportJobDelegate> perContextReportJobDelegates = new ConcurrentHashMap<String, ReportJobDelegate>();
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private DomainHolder<?> domainHolder;

    @Override
    protected void execute(JobExecutionContext context) throws JobExecutionException {
        if (!this.domainHolder.getDomains().containsKey(context.getDomain())) {
            LOG.debug("Domain {} not found, skipping", (Object)context.getDomain());
            return;
        }
        String reportKey = (String)context.getData().get("reportKey");
        try {
            AuthContextUtils.runAsAdmin((String)context.getDomain(), () -> {
                try {
                    String implKey = (String)context.getData().get("delegateImpl");
                    Implementation impl = this.implementationDAO.findById(implKey).orElse(null);
                    if (impl == null) {
                        LOG.error("Could not find Implementation '{}', aborting", (Object)implKey);
                    } else {
                        ReportJobDelegate delegate = (ReportJobDelegate)ImplementationManager.buildReportJobDelegate((Implementation)impl, () -> this.perContextReportJobDelegates.get(impl.getKey()), instance -> this.perContextReportJobDelegates.put(impl.getKey(), (ReportJobDelegate)instance)).orElseThrow(() -> new IllegalArgumentException("Could not instantiate " + impl.getBody()));
                        delegate.execute(reportKey, context.isDryRun(), context);
                    }
                }
                catch (Exception e) {
                    LOG.error("While executing report {}", (Object)reportKey, (Object)e);
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            LOG.error("While executing report {}", (Object)reportKey, (Object)e);
            throw new JobExecutionException("While executing report " + reportKey, (Throwable)e);
        }
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

