/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.notification;

import java.util.Optional;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.notification.NotificationJobDelegate;
import org.apache.syncope.core.provisioning.java.job.Job;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationJob
extends Job {
    protected static final Logger LOG = LoggerFactory.getLogger(NotificationJob.class);
    public static final String DEFAULT_CRON_EXP = "0 0/5 * * * ?";
    protected final SecurityProperties securityProperties;
    protected final DomainHolder<?> domainHolder;
    protected final NotificationJobDelegate delegate;

    public NotificationJob(SecurityProperties securityProperties, DomainHolder<?> domainHolder, NotificationJobDelegate delegate) {
        this.securityProperties = securityProperties;
        this.domainHolder = domainHolder;
        this.delegate = delegate;
    }

    @Override
    protected void execute(JobExecutionContext context) throws JobExecutionException {
        LOG.debug("Waking up...");
        String executor = Optional.ofNullable(context.getExecutor()).orElse(this.securityProperties.getAdminUser());
        for (String domain : this.domainHolder.getDomains().keySet()) {
            try {
                AuthContextUtils.runAsAdmin((String)domain, () -> {
                    try {
                        this.delegate.execute(executor);
                    }
                    catch (Exception e) {
                        LOG.error("While sending out notifications", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (RuntimeException e) {
                LOG.error("While sending out notifications", (Throwable)e);
                throw new JobExecutionException("While sending out notifications", (Throwable)e);
            }
        }
        LOG.debug("Sleeping again...");
    }

    public static enum Status {
        SENT,
        NOT_SENT;

    }
}

