/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.job.StoppableSchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.Job;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class SyncopeTaskScheduler {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeTaskScheduler.class);
    protected final TaskScheduler scheduler;
    protected final JobStatusDAO jobStatusDAO;
    protected final Map<Pair<String, String>, Pair<Job, ScheduledFuture<?>>> jobs = new ConcurrentHashMap();

    public SyncopeTaskScheduler(TaskScheduler scheduler, JobStatusDAO jobStatusDAO) {
        this.scheduler = scheduler;
        this.jobStatusDAO = jobStatusDAO;
    }

    public void register(Job job) {
        this.jobs.put((Pair<String, String>)Pair.of((Object)job.getContext().getDomain(), (Object)job.getContext().getJobName()), Pair.of((Object)job, null));
    }

    public void start(String domain, String jobName) {
        Optional.ofNullable(this.jobs.get(Pair.of((Object)domain, (Object)jobName))).ifPresent(pair -> this.schedule((Job)pair.getLeft(), Instant.now()));
    }

    public void start(Job job) {
        this.schedule(job, Instant.now());
    }

    public void schedule(Job job, CronTrigger trigger) {
        ScheduledFuture future = this.scheduler.schedule((Runnable)job, (Trigger)trigger);
        this.jobs.put((Pair<String, String>)Pair.of((Object)job.getContext().getDomain(), (Object)job.getContext().getJobName()), Pair.of((Object)job, (Object)future));
    }

    public void schedule(Job job, Instant startTime) {
        ScheduledFuture future = this.scheduler.schedule((Runnable)job, startTime);
        this.jobs.put((Pair<String, String>)Pair.of((Object)job.getContext().getDomain(), (Object)job.getContext().getJobName()), Pair.of((Object)job, (Object)future));
    }

    public boolean contains(String domain, String jobName) {
        return this.jobs.containsKey(Pair.of((Object)domain, (Object)jobName));
    }

    public Optional<Class<?>> getJobClass(String domain, String jobName) {
        return Optional.ofNullable(this.jobs.get(Pair.of((Object)domain, (Object)jobName))).map(pair -> AopUtils.getTargetClass((Object)pair.getLeft()));
    }

    public Optional<OffsetDateTime> getNextTrigger(String domain, String jobName) {
        return Optional.ofNullable(this.jobs.get(Pair.of((Object)domain, (Object)jobName))).filter(pair -> pair.getRight() != null).map(pair -> ((ScheduledFuture)pair.getRight()).getDelay(TimeUnit.SECONDS)).filter(delay -> delay > 0L).map(delay -> OffsetDateTime.now().plusSeconds((long)delay));
    }

    public void cancel(String domain, String jobName) {
        Optional.ofNullable(this.jobs.get(Pair.of((Object)domain, (Object)jobName))).ifPresent(pair -> {
            TaskJob taskJob;
            SchedTaskJobDelegate patt1$temp;
            boolean mayInterruptIfRunning = true;
            Object patt0$temp = pair.getLeft();
            if (patt0$temp instanceof TaskJob && (patt1$temp = (taskJob = (TaskJob)patt0$temp).getDelegate()) instanceof StoppableSchedTaskJobDelegate) {
                StoppableSchedTaskJobDelegate stoppable = (StoppableSchedTaskJobDelegate)patt1$temp;
                stoppable.stop();
                mayInterruptIfRunning = false;
            }
            if (pair.getRight() != null) {
                ((ScheduledFuture)pair.getRight()).cancel(mayInterruptIfRunning);
            }
        });
    }

    public void delete(String domain, String jobName) {
        this.jobs.remove(Pair.of((Object)domain, (Object)jobName));
        AuthContextUtils.runAsAdmin((String)domain, () -> this.jobStatusDAO.unlock(jobName));
    }

    public List<String> getJobNames(String domain) {
        return this.jobs.keySet().stream().filter(pair -> domain.equals(pair.getLeft())).map(Pair::getRight).toList();
    }
}

