/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.java.job.Job;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskRejectedException;

public class AfterHandlingJob
extends Job {
    private static final Logger LOG = LoggerFactory.getLogger(AfterHandlingJob.class);
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private AuditManager auditManager;

    public static void schedule(SyncopeTaskScheduler scheduler, Map<String, Object> jobMap) {
        JobExecutionContext context = new JobExecutionContext(AuthContextUtils.getDomain(), AfterHandlingJob.class.getSimpleName() + "_" + String.valueOf(SecureRandomUtils.generateRandomUUID()), AuthContextUtils.getWho(), false);
        context.getData().putAll(jobMap);
        try {
            AfterHandlingJob job = (AfterHandlingJob)ApplicationContextProvider.getBeanFactory().createBean(AfterHandlingJob.class);
            job.setContext(context);
            scheduler.schedule((Job)job, Instant.now());
        }
        catch (TaskRejectedException e) {
            LOG.error("Could not schedule, aborting", (Throwable)e);
        }
    }

    @Override
    protected void execute(JobExecutionContext context) throws JobExecutionException {
        Optional<AfterHandlingEvent> event = Optional.ofNullable(context.getData().get("AfterHandlingEvent")).map(AfterHandlingEvent.class::cast);
        if (event.isEmpty()) {
            LOG.debug("No event to process, aborting");
            return;
        }
        try {
            AuthContextUtils.runAsAdmin((String)context.getDomain(), () -> {
                this.notificationManager.createTasks((AfterHandlingEvent)event.get());
                this.auditManager.audit((AfterHandlingEvent)event.get());
            });
        }
        catch (RuntimeException e) {
            throw new JobExecutionException("While handling notification / audit events", (Throwable)e);
        }
    }
}

