/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.time.OffsetDateTime;
import java.util.Optional;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.JobStatusEvent;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractSchedTaskJobDelegate<T extends SchedTask>
implements SchedTaskJobDelegate {
    protected static final Logger LOG = LoggerFactory.getLogger(SchedTaskJobDelegate.class);
    @Autowired
    protected SecurityProperties securityProperties;
    protected TaskType taskType;
    protected T task;
    @Autowired
    protected TaskExecDAO taskExecDAO;
    @Autowired
    protected TaskDAO taskDAO;
    @Autowired
    protected TaskUtilsFactory taskUtilsFactory;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected ApplicationEventPublisher publisher;
    protected boolean manageOperationId;
    protected String executor;

    protected void setStatus(String status) {
        this.publisher.publishEvent((ApplicationEvent)new JobStatusEvent((Object)this, AuthContextUtils.getDomain(), JobNamer.getJobName(this.task), status));
    }

    protected void init(TaskType taskType, String taskKey, JobExecutionContext context) throws JobExecutionException {
        this.taskType = taskType;
        this.task = (SchedTask)this.taskDAO.findById(taskType, taskKey).orElseThrow(() -> new JobExecutionException("Not found: " + String.valueOf(taskType) + " Task " + taskKey));
        if (!this.task.isActive()) {
            LOG.info("Task {} not active, aborting...", (Object)taskKey);
            return;
        }
        this.manageOperationId = Optional.ofNullable(MDC.get((String)"operation.id")).map(operationId -> false).orElseGet(() -> {
            MDC.put((String)"operation.id", (String)SecureRandomUtils.generateRandomUUID().toString());
            return true;
        });
        this.executor = Optional.ofNullable(context.getExecutor()).orElse(this.securityProperties.getAdminUser());
    }

    protected TaskExec<SchedTask> initExecution() {
        TaskExec execution = this.taskUtilsFactory.getInstance(this.taskType).newTaskExec();
        execution.setStart(OffsetDateTime.now());
        execution.setTask(this.task);
        execution.setExecutor(this.executor);
        return execution;
    }

    protected void endExecution(TaskExec<SchedTask> execution, String message, String status, OpEvent.Outcome result) {
        execution.setMessage(message);
        execution.setStatus(status);
        execution.setEnd(OffsetDateTime.now());
        if (this.hasToBeRegistered(execution)) {
            this.register(execution);
        }
        this.task = (SchedTask)this.taskDAO.save(this.task);
        this.notificationManager.createTasks(this.executor, OpEvent.CategoryType.TASK, this.getClass().getSimpleName(), null, this.getClass().getSimpleName(), result, this.task, execution, new Object[0]);
        this.auditManager.audit(AuthContextUtils.getDomain(), this.executor, OpEvent.CategoryType.TASK, this.task.getClass().getSimpleName(), null, this.getClass().getSimpleName(), result, this.task, execution, new Object[0]);
    }

    protected void end() {
        if (this.manageOperationId) {
            MDC.remove((String)"operation.id");
        }
    }

    @Transactional
    public void execute(TaskType taskType, String taskKey, JobExecutionContext context) throws JobExecutionException {
        OpEvent.Outcome result;
        String status;
        String message;
        this.init(taskType, taskKey, context);
        this.setStatus("Initialization completed");
        TaskExec<SchedTask> execution = this.initExecution();
        try {
            message = this.doExecute(context);
            status = TaskJob.Status.SUCCESS.name();
            result = OpEvent.Outcome.SUCCESS;
        }
        catch (JobExecutionException e) {
            LOG.error("While executing task {}", (Object)taskKey, (Object)e);
            message = ExceptionUtils2.getFullStackTrace((Throwable)e);
            status = TaskJob.Status.FAILURE.name();
            result = OpEvent.Outcome.FAILURE;
        }
        this.endExecution(execution, message, status, result);
        this.end();
    }

    protected abstract String doExecute(JobExecutionContext var1) throws JobExecutionException;

    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return false;
    }

    protected void register(TaskExec<?> execution) {
        this.taskExecDAO.saveAndAdd(this.taskType, this.task.getKey(), execution);
    }
}

