/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.util.Optional;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplateRealm;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmDataBinderImpl
implements RealmDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(RealmDataBinder.class);
    protected final AnyTypeDAO anyTypeDAO;
    protected final ImplementationDAO implementationDAO;
    protected final RealmDAO realmDAO;
    protected final PolicyDAO policyDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityFactory entityFactory;

    public RealmDataBinderImpl(AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, RealmDAO realmDAO, PolicyDAO policyDAO, ExternalResourceDAO resourceDAO, EntityFactory entityFactory) {
        this.anyTypeDAO = anyTypeDAO;
        this.implementationDAO = implementationDAO;
        this.realmDAO = realmDAO;
        this.policyDAO = policyDAO;
        this.resourceDAO = resourceDAO;
        this.entityFactory = entityFactory;
    }

    protected void setTemplates(RealmTO realmTO, Realm realm) {
        TemplateUtils.check(realmTO.getTemplates(), ClientExceptionType.InvalidRealm);
        realmTO.getTemplates().forEach((key, template) -> this.anyTypeDAO.findById(key).ifPresentOrElse(type -> {
            AnyTemplateRealm anyTemplate = realm.getTemplate(type).orElse(null);
            if (anyTemplate == null) {
                anyTemplate = (AnyTemplateRealm)this.entityFactory.newEntity(AnyTemplateRealm.class);
                anyTemplate.setAnyType(type);
                anyTemplate.setRealm(realm);
                realm.add(anyTemplate);
            }
            anyTemplate.set(template);
        }, () -> LOG.debug("Invalid AnyType {} specified, ignoring...", key)));
        realm.getTemplates().removeIf(template -> !realmTO.getTemplates().containsKey(template.getAnyType().getKey()));
    }

    public Realm create(Realm parent, RealmTO realmTO) {
        Realm realm = (Realm)this.entityFactory.newEntity(Realm.class);
        realm.setName(realmTO.getName());
        realm.setParent(parent);
        realm.setPasswordPolicy(realmTO.getPasswordPolicy() == null ? null : (PasswordPolicy)this.policyDAO.findById(realmTO.getPasswordPolicy(), PasswordPolicy.class).orElse(null));
        realm.setAccountPolicy(realmTO.getAccountPolicy() == null ? null : (AccountPolicy)this.policyDAO.findById(realmTO.getAccountPolicy(), AccountPolicy.class).orElse(null));
        realm.setAuthPolicy(realmTO.getAuthPolicy() == null ? null : (AuthPolicy)this.policyDAO.findById(realmTO.getAuthPolicy(), AuthPolicy.class).orElse(null));
        realm.setAccessPolicy(realmTO.getAccessPolicy() == null ? null : (AccessPolicy)this.policyDAO.findById(realmTO.getAccessPolicy(), AccessPolicy.class).orElse(null));
        realm.setAttrReleasePolicy(realmTO.getAttrReleasePolicy() == null ? null : (AttrReleasePolicy)this.policyDAO.findById(realmTO.getAttrReleasePolicy(), AttrReleasePolicy.class).orElse(null));
        realm.setTicketExpirationPolicy(realmTO.getTicketExpirationPolicy() == null ? null : (TicketExpirationPolicy)this.policyDAO.findById(realmTO.getTicketExpirationPolicy(), TicketExpirationPolicy.class).orElse(null));
        realmTO.getActions().forEach(key -> this.implementationDAO.findById(key).ifPresentOrElse(arg_0 -> ((Realm)realm).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), key)));
        this.setTemplates(realmTO, realm);
        realmTO.getResources().forEach(key -> this.resourceDAO.findById(key).ifPresentOrElse(arg_0 -> ((Realm)realm).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), key)));
        return realm;
    }

    public PropagationByResource<String> update(Realm realm, RealmTO realmTO) {
        realm.setName(realmTO.getName());
        realm.setParent(realmTO.getParent() == null ? null : (Realm)this.realmDAO.findById(realmTO.getParent()).orElse(null));
        realm.setPasswordPolicy(realmTO.getPasswordPolicy() == null ? null : (PasswordPolicy)this.policyDAO.findById(realmTO.getPasswordPolicy(), PasswordPolicy.class).orElse(null));
        realm.setAccountPolicy(realmTO.getAccountPolicy() == null ? null : (AccountPolicy)this.policyDAO.findById(realmTO.getAccountPolicy(), AccountPolicy.class).orElse(null));
        realm.setAuthPolicy(realmTO.getAuthPolicy() == null ? null : (AuthPolicy)this.policyDAO.findById(realmTO.getAuthPolicy(), AuthPolicy.class).orElse(null));
        realm.setAccessPolicy(realmTO.getAccessPolicy() == null ? null : (AccessPolicy)this.policyDAO.findById(realmTO.getAccessPolicy(), AccessPolicy.class).orElse(null));
        realm.setAttrReleasePolicy(realmTO.getAttrReleasePolicy() == null ? null : (AttrReleasePolicy)this.policyDAO.findById(realmTO.getAttrReleasePolicy(), AttrReleasePolicy.class).orElse(null));
        realm.setTicketExpirationPolicy(realmTO.getTicketExpirationPolicy() == null ? null : (TicketExpirationPolicy)this.policyDAO.findById(realmTO.getTicketExpirationPolicy(), TicketExpirationPolicy.class).orElse(null));
        realmTO.getActions().forEach(key -> this.implementationDAO.findById(key).ifPresentOrElse(arg_0 -> ((Realm)realm).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)Implementation.class.getSimpleName(), key)));
        realm.getActions().removeIf(implementation -> !realmTO.getActions().contains(implementation.getKey()));
        this.setTemplates(realmTO, realm);
        PropagationByResource propByRes = new PropagationByResource();
        realmTO.getResources().forEach(key -> this.resourceDAO.findById(key).ifPresentOrElse(resource -> {
            realm.add(resource);
            propByRes.add(ResourceOperation.CREATE, (Serializable)((Object)resource.getKey()));
        }, () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), key)));
        realm.getResources().removeIf(resource -> {
            boolean contained = realmTO.getResources().contains(resource.getKey());
            if (!contained) {
                propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)resource.getKey()));
            }
            return !contained;
        });
        return propByRes;
    }

    public RealmTO getRealmTO(Realm realm, boolean admin) {
        RealmTO realmTO = new RealmTO();
        realmTO.setKey(realm.getKey());
        realmTO.setName(realm.getName());
        Optional.ofNullable(realm.getParent()).ifPresent(parent -> realmTO.setParent(parent.getKey()));
        realmTO.setFullPath(realm.getFullPath());
        if (admin) {
            Optional.ofNullable(realm.getAccountPolicy()).ifPresent(policy -> realmTO.setAccountPolicy(policy.getKey()));
            Optional.ofNullable(realm.getPasswordPolicy()).ifPresent(policy -> realmTO.setPasswordPolicy(policy.getKey()));
            Optional.ofNullable(realm.getAuthPolicy()).ifPresent(policy -> realmTO.setAuthPolicy(policy.getKey()));
            Optional.ofNullable(realm.getAccessPolicy()).ifPresent(policy -> realmTO.setAccessPolicy(policy.getKey()));
            Optional.ofNullable(realm.getAttrReleasePolicy()).ifPresent(policy -> realmTO.setAttrReleasePolicy(policy.getKey()));
            Optional.ofNullable(realm.getTicketExpirationPolicy()).ifPresent(policy -> realmTO.setTicketExpirationPolicy(policy.getKey()));
            realm.getActions().forEach(action -> realmTO.getActions().add(action.getKey()));
            realm.getTemplates().forEach(template -> realmTO.getTemplates().put(template.getAnyType().getKey(), template.get()));
            realm.getResources().forEach(resource -> realmTO.getResources().add(resource.getKey()));
        }
        return realmTO;
    }
}

