/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.DropdownValueProvider;
import org.apache.syncope.core.persistence.api.attrvalue.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AccountGetter;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PlainAttrGetter;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAnyDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractAnyDataBinder.class);
    protected final AnyTypeDAO anyTypeDAO;
    protected final RealmSearchDAO realmSearchDAO;
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final PlainAttrValueDAO plainAttrValueDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final RelationshipTypeDAO relationshipTypeDAO;
    protected final EntityFactory entityFactory;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final DerAttrHandler derAttrHandler;
    protected final VirAttrHandler virAttrHandler;
    protected final MappingManager mappingManager;
    protected final IntAttrNameParser intAttrNameParser;
    protected final OutboundMatcher outboundMatcher;
    protected final PlainAttrValidationManager validator;
    protected final Map<String, DropdownValueProvider> dropdownValueProviders = new ConcurrentHashMap<String, DropdownValueProvider>();

    protected static void fillTO(AnyTO anyTO, String realmFullPath, Collection<? extends AnyTypeClass> auxClasses, Collection<? extends PlainAttr<?>> plainAttrs, Map<DerSchema, String> derAttrs, Map<VirSchema, List<String>> virAttrs, Collection<? extends ExternalResource> resources) {
        anyTO.setRealm(realmFullPath);
        anyTO.getAuxClasses().addAll(auxClasses.stream().map(Entity::getKey).toList());
        plainAttrs.forEach(plainAttr -> anyTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema().getKey()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        derAttrs.forEach((schema, value) -> anyTO.getDerAttrs().add(new Attr.Builder(schema.getKey()).value(value).build()));
        virAttrs.forEach((schema, values) -> anyTO.getVirAttrs().add(new Attr.Builder(schema.getKey()).values((Collection)values).build()));
        anyTO.getResources().addAll(resources.stream().map(Entity::getKey).collect(Collectors.toSet()));
    }

    protected static RelationshipTO getRelationshipTO(String relationshipType, RelationshipTO.End end, Any<?> otherEnd) {
        String string;
        RelationshipTO.Builder builder = new RelationshipTO.Builder(relationshipType, end);
        String string2 = otherEnd.getType().getKey();
        String string3 = otherEnd.getKey();
        if (otherEnd instanceof User) {
            User user = (User)otherEnd;
            string = user.getUsername();
        } else {
            string = ((AnyObject)otherEnd).getName();
        }
        return builder.otherEnd(string2, string3, string).build();
    }

    protected static MembershipTO getMembershipTO(Collection<? extends PlainAttr<?>> plainAttrs, Map<DerSchema, String> derAttrs, Map<VirSchema, List<String>> virAttrs, Membership<? extends Any<?>> membership) {
        MembershipTO membershipTO = new MembershipTO.Builder(((Group)membership.getRightEnd()).getKey()).groupName(((Group)membership.getRightEnd()).getName()).build();
        plainAttrs.forEach(plainAttr -> membershipTO.getPlainAttrs().add(new Attr.Builder(plainAttr.getSchema().getKey()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        derAttrs.forEach((schema, value) -> membershipTO.getDerAttrs().add(new Attr.Builder(schema.getKey()).value(value).build()));
        virAttrs.forEach((schema, values) -> membershipTO.getVirAttrs().add(new Attr.Builder(schema.getKey()).values((Collection)values).build()));
        return membershipTO;
    }

    protected AbstractAnyDataBinder(AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, PlainAttrValueDAO plainAttrValueDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator) {
        this.anyTypeDAO = anyTypeDAO;
        this.realmSearchDAO = realmSearchDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.plainAttrValueDAO = plainAttrValueDAO;
        this.resourceDAO = resourceDAO;
        this.relationshipTypeDAO = relationshipTypeDAO;
        this.entityFactory = entityFactory;
        this.anyUtilsFactory = anyUtilsFactory;
        this.derAttrHandler = derAttrHandler;
        this.virAttrHandler = virAttrHandler;
        this.mappingManager = mappingManager;
        this.intAttrNameParser = intAttrNameParser;
        this.outboundMatcher = outboundMatcher;
        this.validator = validator;
    }

    protected void setRealm(Any<?> any, AnyUR anyUR) {
        if (anyUR.getRealm() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)anyUR.getRealm().getValue()))) {
            this.realmSearchDAO.findByFullPath((String)anyUR.getRealm().getValue()).ifPresentOrElse(newRealm -> any.setRealm(newRealm), () -> LOG.debug("Invalid realm specified: {}, ignoring", anyUR.getRealm().getValue()));
        }
    }

    protected Map<String, ConnObject> onResources(Any<?> any, Collection<String> resources, String password, boolean changePwd) {
        HashMap<String, ConnObject> onResources = new HashMap<String, ConnObject>();
        resources.stream().map(arg_0 -> ((ExternalResourceDAO)this.resourceDAO).findById(arg_0)).flatMap(Optional::stream).forEach(resource -> resource.getProvisionByAnyType(any.getType().getKey()).ifPresent(provision -> MappingUtils.getConnObjectKeyItem(provision).ifPresent(keyItem -> {
            ConnObject connObjectTO;
            Pair prepared = this.mappingManager.prepareAttrsFromAny(any, password, changePwd, Boolean.valueOf(true), resource, provision);
            if (StringUtils.isBlank((CharSequence)((CharSequence)prepared.getLeft()))) {
                connObjectTO = ConnObjectUtils.getConnObjectTO(null, (Set)prepared.getRight());
            } else {
                ConnectorObject connectorObject = new ConnectorObjectBuilder().addAttributes((Collection)prepared.getRight()).addAttribute(new Attribute[]{new Uid((String)prepared.getLeft())}).addAttribute(new Attribute[]{AttributeBuilder.build((String)keyItem.getExtAttrName(), (Object[])new Object[]{prepared.getLeft()})}).build();
                connObjectTO = ConnObjectUtils.getConnObjectTO(this.outboundMatcher.getFIQL(connectorObject, (ExternalResource)resource, (Provision)provision), connectorObject.getAttributes());
            }
            onResources.put(resource.getKey(), connObjectTO);
        })));
        return onResources;
    }

    protected PlainSchema getPlainSchema(String schemaName) {
        PlainSchema schema = null;
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            schema = this.plainSchemaDAO.findById(schemaName).orElse(null);
            if (schema == null) {
                LOG.debug("Ignoring invalid schema {}", (Object)schemaName);
            } else if (schema.isReadonly()) {
                schema = null;
                LOG.debug("Ignoring readonly schema {}", (Object)schemaName);
            }
        }
        return schema;
    }

    protected void fillAttr(AnyTO anyTO, List<String> values, AnyUtils anyUtils, PlainSchema schema, PlainAttr<?> attr, SyncopeClientException invalidValues) {
        List<String> valuesProvided = schema.isMultivalue() ? values : (values.isEmpty() || values.get(0) == null ? List.of() : List.of(values.get(0)));
        valuesProvided.forEach(value -> {
            if (StringUtils.isBlank((CharSequence)value)) {
                LOG.debug("Null value for {}, ignoring", (Object)schema.getKey());
            } else {
                try {
                    switch (schema.getType()) {
                        case Enum: {
                            if (schema.getEnumValues().containsKey(value)) break;
                            throw new InvalidPlainAttrValueException("'" + value + "' is not one of: " + String.valueOf(schema.getEnumValues().keySet()));
                        }
                        case Dropdown: {
                            List dropdownValues = List.of();
                            try {
                                DropdownValueProvider provider = (DropdownValueProvider)ImplementationManager.build((Implementation)schema.getDropdownValueProvider(), () -> this.dropdownValueProviders.get(schema.getDropdownValueProvider().getKey()), instance -> this.dropdownValueProviders.put(schema.getDropdownValueProvider().getKey(), (DropdownValueProvider)instance));
                                dropdownValues = provider.getChoices(anyTO);
                            }
                            catch (Exception e) {
                                LOG.error("While getting dropdown values for {}", (Object)schema.getKey(), (Object)e);
                            }
                            if (dropdownValues.contains(value)) break;
                            throw new InvalidPlainAttrValueException("'" + value + "' is not one of: " + String.valueOf(dropdownValues));
                        }
                    }
                    attr.add(this.validator, value, anyUtils);
                }
                catch (InvalidPlainAttrValueException e) {
                    LOG.warn("Invalid value for attribute {}: {}", new Object[]{schema.getKey(), StringUtils.abbreviate((String)value, (int)20), e});
                    invalidValues.getElements().add(schema.getKey() + ": " + value + " - " + e.getMessage());
                }
            }
        });
    }

    protected List<String> evaluateMandatoryCondition(ExternalResource resource, Provision provision, Any<?> any) {
        ArrayList<String> missingAttrNames = new ArrayList<String>();
        MappingUtils.getPropagationItems(provision.getMapping().getItems().stream()).forEach(mapItem -> {
            AttrSchemaType schemaType;
            Pair intValues;
            IntAttrName intAttrName = null;
            try {
                intAttrName = this.intAttrNameParser.parse(mapItem.getIntAttrName(), any.getType().getKind());
            }
            catch (ParseException e) {
                LOG.error("Invalid intAttrName '{}', ignoring", (Object)mapItem.getIntAttrName(), (Object)e);
            }
            if (intAttrName != null && intAttrName.getSchema() != null && ((List)(intValues = this.mappingManager.getIntValues(resource, provision, mapItem, intAttrName, schemaType = intAttrName.getSchema() instanceof PlainSchema ? intAttrName.getSchema().getType() : AttrSchemaType.String, any, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT)).getRight()).isEmpty() && JexlUtils.evaluateMandatoryCondition((String)mapItem.getMandatoryCondition(), (Any)any, (DerAttrHandler)this.derAttrHandler)) {
                missingAttrNames.add(mapItem.getIntAttrName());
            }
        });
        return missingAttrNames;
    }

    private SyncopeClientException checkMandatoryOnResources(Any<?> any, Collection<? extends ExternalResource> resources) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        resources.forEach(resource -> {
            List<String> missingAttrNames;
            Optional provision = resource.getProvisionByAnyType(any.getType().getKey());
            if (resource.isEnforceMandatoryCondition() && provision.isPresent() && !(missingAttrNames = this.evaluateMandatoryCondition((ExternalResource)resource, (Provision)provision.get(), any)).isEmpty()) {
                LOG.error("Mandatory schemas {} not provided with values", missingAttrNames);
                reqValMissing.getElements().addAll(missingAttrNames);
            }
        });
        return reqValMissing;
    }

    private void checkMandatory(PlainSchema schema, PlainAttr<?> attr, Any<?> any, SyncopeClientException reqValMissing) {
        if (attr == null && !schema.isReadonly() && JexlUtils.evaluateMandatoryCondition((String)schema.getMandatoryCondition(), any, (DerAttrHandler)this.derAttrHandler)) {
            LOG.error("Mandatory schema {} not provided with values", (Object)schema.getKey());
            reqValMissing.getElements().add(schema.getKey());
        }
    }

    private SyncopeClientException checkMandatory(Any<?> any, AnyUtils anyUtils) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        AllowedSchemas allowedPlainSchemas = anyUtils.dao().findAllowedSchemas(any, PlainSchema.class);
        allowedPlainSchemas.getForSelf().forEach(schema -> this.checkMandatory((PlainSchema)schema, any.getPlainAttr(schema.getKey()).orElse(null), any, reqValMissing));
        if (any instanceof GroupableRelatable) {
            GroupableRelatable groupable = (GroupableRelatable)any;
            allowedPlainSchemas.getForMemberships().forEach((group, schemas) -> {
                Membership membership = groupable.getMembership(group.getKey()).orElse(null);
                schemas.forEach(schema -> this.checkMandatory((PlainSchema)schema, groupable.getPlainAttr(schema.getKey(), membership).orElse(null), any, reqValMissing));
            });
        }
        return reqValMissing;
    }

    protected void processAttrPatch(AnyTO anyTO, Any any, AttrPatch patch, PlainSchema schema, PlainAttr<?> attr, AnyUtils anyUtils, SyncopeClientException invalidValues) {
        switch (patch.getOperation()) {
            case ADD_REPLACE: {
                List valuesToBeAdded;
                if (attr.getSchema().isUniqueConstraint()) {
                    if (attr.getUniqueValue() != null && !patch.getAttr().getValues().isEmpty() && !((String)patch.getAttr().getValues().get(0)).equals(attr.getUniqueValue().getValueAsString())) {
                        this.plainAttrValueDAO.deleteAll(attr, anyUtils);
                    }
                } else {
                    this.plainAttrValueDAO.deleteAll(attr, anyUtils);
                }
                if (!((valuesToBeAdded = patch.getAttr().getValues()).isEmpty() || schema.isUniqueConstraint() && attr.getUniqueValue() != null && ((String)valuesToBeAdded.get(0)).equals(attr.getUniqueValue().getValueAsString()))) {
                    this.fillAttr(anyTO, valuesToBeAdded, anyUtils, schema, attr, invalidValues);
                }
                if (!attr.getValuesAsStrings().isEmpty()) break;
                this.plainSchemaDAO.delete(attr);
                break;
            }
            default: {
                any.remove(attr);
                this.plainSchemaDAO.delete(attr);
            }
        }
    }

    protected void fill(AnyTO anyTO, Any any, AnyUR anyUR, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException requiredValuesMissing;
        for (StringPatchItem patch2 : anyUR.getAuxClasses()) {
            this.anyTypeClassDAO.findById((String)patch2.getValue()).ifPresentOrElse(auxClass -> {
                switch (patch2.getOperation()) {
                    case ADD_REPLACE: {
                        any.add(auxClass);
                        break;
                    }
                    default: {
                        any.getAuxClasses().remove(auxClass);
                    }
                }
            }, () -> LOG.debug("Invalid {} {}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), patch2.getValue()));
        }
        for (StringPatchItem patch2 : anyUR.getResources()) {
            this.resourceDAO.findById((String)patch2.getValue()).ifPresentOrElse(resource -> {
                switch (patch2.getOperation()) {
                    case ADD_REPLACE: {
                        any.add(resource);
                        break;
                    }
                    default: {
                        any.getResources().remove(resource);
                    }
                }
            }, () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), patch2.getValue()));
        }
        Set resources = anyUtils.getAllResources(any);
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        anyUR.getPlainAttrs().stream().filter(patch -> patch.getAttr() != null).forEach(patch -> {
            PlainSchema schema = this.getPlainSchema(patch.getAttr().getSchema());
            if (schema == null) {
                LOG.debug("Invalid {} {}, ignoring...", (Object)PlainSchema.class.getSimpleName(), (Object)patch.getAttr().getSchema());
            } else {
                PlainAttr attr = any.getPlainAttr(schema.getKey()).orElse(null);
                if (attr == null) {
                    LOG.debug("No plain attribute found for schema {}", (Object)schema);
                    if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                        attr = anyUtils.newPlainAttr();
                        attr.setOwner(any);
                        attr.setSchema(schema);
                        any.add(attr);
                    }
                }
                if (attr != null) {
                    this.processAttrPatch(anyTO, any, (AttrPatch)patch, schema, (PlainAttr<?>)attr, anyUtils, invalidValues);
                }
            }
        });
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(requiredValuesMissing = this.checkMandatory(any, anyUtils)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        if (!(requiredValuesMissing = this.checkMandatoryOnResources(any, resources)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
    }

    protected PropagationByResource<String> propByRes(Map<String, ConnObject> before, Map<String, ConnObject> after) {
        PropagationByResource propByRes = new PropagationByResource();
        after.forEach((resource, connObject) -> {
            if (before.containsKey(resource)) {
                ConnObject beforeObject = (ConnObject)before.get(resource);
                if (!beforeObject.equals(connObject)) {
                    propByRes.add(ResourceOperation.UPDATE, (Serializable)((Object)resource));
                    beforeObject.getAttr(Uid.NAME).map(attr -> (String)attr.getValues().get(0)).ifPresent(value -> propByRes.addOldConnObjectKey(resource, value));
                }
            } else {
                propByRes.add(ResourceOperation.CREATE, (Serializable)((Object)resource));
            }
        });
        propByRes.addAll(ResourceOperation.DELETE, (Collection)before.keySet().stream().filter(resource -> !after.containsKey(resource)).collect(Collectors.toSet()));
        return propByRes;
    }

    protected void fill(AnyTO anyTO, Any any, AnyCR anyCR, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException requiredValuesMissing;
        any.getAuxClasses().clear();
        anyCR.getAuxClasses().stream().map(className -> this.anyTypeClassDAO.findById(className)).flatMap(Optional::stream).forEach(auxClass -> {
            if (auxClass == null) {
                LOG.debug("Invalid {} {}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), auxClass);
            } else {
                any.add(auxClass);
            }
        });
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        anyCR.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> {
            PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
            if (schema != null) {
                PlainAttr attr = any.getPlainAttr(schema.getKey()).orElse(null);
                if (attr == null) {
                    attr = anyUtils.newPlainAttr();
                    attr.setOwner(any);
                    attr.setSchema(schema);
                }
                this.fillAttr(anyTO, attrTO.getValues(), anyUtils, schema, attr, invalidValues);
                if (attr.getValuesAsStrings().isEmpty()) {
                    attr.setOwner(null);
                } else {
                    any.add(attr);
                }
            }
        });
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(requiredValuesMissing = this.checkMandatory(any, anyUtils)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        anyCR.getResources().forEach(resource -> this.resourceDAO.findById(resource).ifPresentOrElse(arg_0 -> ((Any)any).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)ExternalResource.class.getSimpleName(), resource)));
        requiredValuesMissing = this.checkMandatoryOnResources(any, anyUtils.getAllResources(any));
        if (!requiredValuesMissing.isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
    }

    protected void fill(AnyTO anyTO, Any any, Membership membership, MembershipTO membershipTO, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        membershipTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> Optional.ofNullable(this.getPlainSchema(attrTO.getSchema())).ifPresent(schema -> {
            GroupablePlainAttr attr = (GroupablePlainAttr)((GroupableRelatable)GroupableRelatable.class.cast(any)).getPlainAttr(schema.getKey(), membership).orElseGet(() -> {
                GroupablePlainAttr gpa = (GroupablePlainAttr)anyUtils.newPlainAttr();
                gpa.setOwner(any);
                gpa.setMembership(membership);
                gpa.setSchema(schema);
                return gpa;
            });
            this.fillAttr(anyTO, attrTO.getValues(), anyUtils, (PlainSchema)schema, (PlainAttr<?>)attr, invalidValues);
            if (attr.getValuesAsStrings().isEmpty()) {
                attr.setOwner(null);
            } else {
                any.add((PlainAttr)attr);
            }
        }));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
    }
}

