/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.cache.Cache;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.java.cache.VirAttrCacheKey;
import org.apache.syncope.core.provisioning.java.cache.VirAttrCacheValue;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class DefaultVirAttrHandler
implements VirAttrHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(VirAttrHandler.class);
    protected final ConnectorManager connectorManager;
    protected final Cache<VirAttrCacheKey, VirAttrCacheValue> virAttrCache;
    protected final OutboundMatcher outboundMatcher;
    protected final AnyUtilsFactory anyUtilsFactory;

    public DefaultVirAttrHandler(ConnectorManager connectorManager, Cache<VirAttrCacheKey, VirAttrCacheValue> virAttrCache, OutboundMatcher outboundMatcher, AnyUtilsFactory anyUtilsFactory) {
        this.connectorManager = connectorManager;
        this.virAttrCache = virAttrCache;
        this.outboundMatcher = outboundMatcher;
        this.anyUtilsFactory = anyUtilsFactory;
    }

    public void setValues(Any<?> any, ConnectorObject connObj) {
        if (any == null) {
            LOG.debug("Null any passed, ignoring");
            return;
        }
        AllowedSchemas schemas = this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class);
        Stream.concat(schemas.getForSelf().stream(), schemas.getForMemberships().values().stream().flatMap(Collection::stream)).forEach(schema -> {
            VirAttrCacheKey cacheKey = VirAttrCacheKey.of(any.getType().getKey(), any.getKey(), schema.getKey());
            Attribute attr = connObj.getAttributeByName(schema.getExtAttrName());
            if (attr == null) {
                this.virAttrCache.remove((Object)cacheKey);
                LOG.debug("Evicted from cache: {}", (Object)cacheKey);
            } else {
                VirAttrCacheValue cacheValue = VirAttrCacheValue.of(attr.getValue());
                this.virAttrCache.put((Object)cacheKey, (Object)cacheValue);
                LOG.debug("Set in cache: {}={}", (Object)cacheKey, (Object)cacheValue);
            }
        });
    }

    protected Map<VirSchema, List<String>> getValues(Any<?> any, Set<VirSchema> schemas) {
        Set resources = this.anyUtilsFactory.getInstance(any).getAllResources(any);
        HashMap<VirSchema, List<String>> result = new HashMap<VirSchema, List<String>>();
        HashMap<Pair, Set> toRead = new HashMap<Pair, Set>();
        schemas.stream().filter(schema -> resources.contains(schema.getResource())).forEach(schema -> {
            VirAttrCacheKey cacheKey = VirAttrCacheKey.of(any.getType().getKey(), any.getKey(), schema.getKey());
            VirAttrCacheValue cacheValue = (VirAttrCacheValue)this.virAttrCache.get((Object)cacheKey);
            if (cacheValue != null) {
                LOG.debug("Found in cache: {}={}", (Object)cacheKey, (Object)cacheValue);
                result.put((VirSchema)schema, cacheValue.values());
            } else if (schema.getAnyType().equals((Object)any.getType())) {
                schema.getResource().getProvisionByAnyType(schema.getAnyType().getKey()).ifPresent(provision -> {
                    HashSet<VirSchema> schemasToRead = (HashSet<VirSchema>)toRead.get(Pair.of((Object)schema.getResource(), (Object)provision));
                    if (schemasToRead == null) {
                        schemasToRead = new HashSet<VirSchema>();
                        toRead.put(Pair.of((Object)schema.getResource(), (Object)provision), schemasToRead);
                    }
                    schemasToRead.add((VirSchema)schema);
                });
            }
        });
        toRead.forEach((pair, schemasToRead) -> {
            LOG.debug("About to read from {}: {}", pair, schemasToRead);
            this.outboundMatcher.match(this.connectorManager.getConnector((ExternalResource)pair.getLeft()), any, (ExternalResource)pair.getLeft(), (Provision)pair.getRight(), Optional.empty(), (Item[])schemasToRead.stream().map(VirSchema::asLinkingMappingItem).toArray(Item[]::new)).forEach(connObj -> schemasToRead.forEach(schema -> {
                Attribute attr = connObj.getAttributeByName(schema.getExtAttrName());
                if (attr != null) {
                    VirAttrCacheKey cacheKey = VirAttrCacheKey.of(any.getType().getKey(), any.getKey(), schema.getKey());
                    VirAttrCacheValue cacheValue = VirAttrCacheValue.of(attr.getValue());
                    this.virAttrCache.put((Object)cacheKey, (Object)cacheValue);
                    LOG.debug("Set in cache: {}={}", (Object)cacheKey, (Object)cacheValue);
                    result.put((VirSchema)schema, cacheValue.values());
                }
            }));
        });
        return result;
    }

    public List<String> getValues(Any<?> any, VirSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).forSelfContains((Schema)schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return List.of();
        }
        List<String> result = this.getValues(any, Set.of(schema)).get(schema);
        return result == null ? List.of() : result;
    }

    public List<String> getValues(Any<?> any, Membership<?> membership, VirSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForMembership((Group)membership.getRightEnd()).contains(schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return List.of();
        }
        List<String> result = this.getValues(any, Set.of(schema)).get(schema);
        return result == null ? List.of() : result;
    }

    public Map<VirSchema, List<String>> getValues(Any<?> any) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForSelf());
    }

    public Map<VirSchema, List<String>> getValues(Any<?> any, Membership<?> membership) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForMembership((Group)membership.getRightEnd()));
    }
}

