/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.request.AbstractPatchItem;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.StatusRType;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultUserProvisioningManager
implements UserProvisioningManager {
    protected static final Logger LOG = LoggerFactory.getLogger(UserProvisioningManager.class);
    protected final UserWorkflowAdapter uwfAdapter;
    protected final PropagationManager propagationManager;
    protected final PropagationTaskExecutor taskExecutor;
    protected final UserDAO userDAO;
    protected final VirAttrHandler virtAttrHandler;

    public DefaultUserProvisioningManager(UserWorkflowAdapter uwfAdapter, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, UserDAO userDAO, VirAttrHandler virtAttrHandler) {
        this.uwfAdapter = uwfAdapter;
        this.propagationManager = propagationManager;
        this.taskExecutor = taskExecutor;
        this.userDAO = userDAO;
        this.virtAttrHandler = virtAttrHandler;
    }

    public Pair<String, List<PropagationStatus>> create(UserCR userCR, boolean nullPriorityAsync, String creator, String context) {
        return this.create(userCR, false, null, Set.of(), nullPriorityAsync, creator, context);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<String, List<PropagationStatus>> create(UserCR userCR, boolean disablePwdPolicyCheck, Boolean enabled, Set<String> excludedResources, boolean nullPriorityAsync, String creator, String context) {
        UserWorkflowResult created = this.uwfAdapter.create(userCR, disablePwdPolicyCheck, enabled, creator, context);
        List taskInfos = this.propagationManager.getUserCreateTasks((String)((Pair)created.getResult()).getLeft(), userCR.getPassword(), (Boolean)((Pair)created.getResult()).getRight(), created.getPropByRes(), created.getPropByLinkedAccount(), (Collection)userCR.getVirAttrs(), excludedResources);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, creator);
        return Pair.of((Object)((String)((Pair)created.getResult()).getLeft()), (Object)propagationReporter.getStatuses());
    }

    public Pair<UserUR, List<PropagationStatus>> update(UserUR userUR, boolean nullPriorityAsync, String updater, String context) {
        Map beforeAttrs = this.propagationManager.prepareAttrs(AnyTypeKind.USER, userUR.getKey(), (String)Optional.ofNullable(userUR.getPassword()).map(AbstractPatchItem::getValue).orElse(null), userUR.getPassword() != null, null, Set.of());
        UserWorkflowResult updated = this.uwfAdapter.update(userUR, null, updater, context);
        List taskInfos = this.propagationManager.setAttributeDeltas(this.propagationManager.getUserUpdateTasks(updated), beforeAttrs);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, updater);
        return Pair.of((Object)((UserUR)((Pair)updated.getResult()).getLeft()), (Object)propagationReporter.getStatuses());
    }

    public Pair<UserUR, List<PropagationStatus>> update(UserUR userUR, Set<String> excludedResources, boolean nullPriorityAsync, String updater, String context) {
        return this.update(userUR, new ProvisioningReport(), null, excludedResources, nullPriorityAsync, updater, context);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<UserUR, List<PropagationStatus>> update(UserUR userUR, ProvisioningReport result, Boolean enabled, Set<String> excludedResources, boolean nullPriorityAsync, String updater, String context) {
        UserWorkflowResult updated;
        Map beforeAttrs = this.propagationManager.prepareAttrs(AnyTypeKind.USER, userUR.getKey(), (String)Optional.ofNullable(userUR.getPassword()).map(AbstractPatchItem::getValue).orElse(null), userUR.getPassword() != null, enabled, excludedResources);
        try {
            updated = this.uwfAdapter.update(userUR, enabled, updater, context);
        }
        catch (Exception e) {
            LOG.error("Update of user {} failed, trying to pull its status anyway (if configured)", (Object)userUR.getKey(), (Object)e);
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage("Update failed, trying to pull status anyway (if configured)\n" + e.getMessage());
            updated = new UserWorkflowResult((Object)Pair.of((Object)userUR, (Object)false), new PropagationByResource(), new PropagationByResource(), new HashSet());
        }
        List taskInfos = this.propagationManager.setAttributeDeltas(this.propagationManager.getUserUpdateTasks(updated, ((UserUR)((Pair)updated.getResult()).getLeft()).getPassword() != null, excludedResources), beforeAttrs);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, updater);
        return Pair.of((Object)((UserUR)((Pair)updated.getResult()).getLeft()), (Object)propagationReporter.getStatuses());
    }

    public List<PropagationStatus> delete(String key, boolean nullPriorityAsync, String eraser, String context) {
        return this.delete(key, Set.of(), nullPriorityAsync, eraser, context);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<PropagationStatus> delete(String key, Set<String> excludedResources, boolean nullPriorityAsync, String eraser, String context) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.DELETE, this.userDAO.findAllResourceKeys(key));
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        this.userDAO.findLinkedAccounts(key).forEach(account -> propByLinkedAccount.add(ResourceOperation.DELETE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        List taskInfos = this.propagationManager.getDeleteTasks(AnyTypeKind.USER, key, propByRes, propByLinkedAccount, excludedResources);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, eraser);
        this.uwfAdapter.delete(key, eraser, context);
        return propagationReporter.getStatuses();
    }

    public String unlink(UserUR userUR, String updater, String context) {
        UserWorkflowResult updated = this.uwfAdapter.update(userUR, null, updater, context);
        return ((UserUR)((Pair)updated.getResult()).getLeft()).getKey();
    }

    public String link(UserUR userUR, String updater, String context) {
        return ((UserUR)((Pair)this.uwfAdapter.update(userUR, null, updater, context).getResult()).getLeft()).getKey();
    }

    public Pair<String, List<PropagationStatus>> activate(StatusR statusR, boolean nullPriorityAsync, String updater, String context) {
        UserWorkflowResult updated = statusR.isOnSyncope() ? this.uwfAdapter.activate(statusR.getKey(), statusR.getToken(), updater, context) : new UserWorkflowResult((Object)statusR.getKey(), null, null, statusR.getType().name().toLowerCase());
        return Pair.of((Object)((String)updated.getResult()), this.propagateStatus(statusR, nullPriorityAsync, updater));
    }

    public Pair<String, List<PropagationStatus>> reactivate(StatusR statusR, boolean nullPriorityAsync, String updater, String context) {
        UserWorkflowResult updated = statusR.isOnSyncope() ? this.uwfAdapter.reactivate(statusR.getKey(), updater, context) : new UserWorkflowResult((Object)statusR.getKey(), null, null, statusR.getType().name().toLowerCase());
        return Pair.of((Object)((String)updated.getResult()), this.propagateStatus(statusR, nullPriorityAsync, updater));
    }

    public Pair<String, List<PropagationStatus>> suspend(StatusR statusR, boolean nullPriorityAsync, String updater, String context) {
        UserWorkflowResult updated = statusR.isOnSyncope() ? this.uwfAdapter.suspend(statusR.getKey(), updater, context) : new UserWorkflowResult((Object)statusR.getKey(), null, null, statusR.getType().name().toLowerCase());
        return Pair.of((Object)((String)updated.getResult()), this.propagateStatus(statusR, nullPriorityAsync, updater));
    }

    protected List<PropagationStatus> propagateStatus(StatusR statusR, boolean nullPriorityAsync, String updater) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.UPDATE, (Collection)statusR.getResources());
        List taskInfos = this.propagationManager.getUpdateTasks(null, AnyTypeKind.USER, statusR.getKey(), false, Boolean.valueOf(statusR.getType() != StatusRType.SUSPEND), propByRes, null, null, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, updater);
        return propagationReporter.getStatuses();
    }

    public void internalSuspend(String key, String updater, String context) {
        Pair updated = this.uwfAdapter.internalSuspend(key, updater, context);
        if (updated != null && ((Boolean)updated.getRight()).booleanValue()) {
            UserUR userUR = new UserUR();
            userUR.setKey((String)((UserWorkflowResult)updated.getLeft()).getResult());
            List taskInfos = this.propagationManager.getUserUpdateTasks(new UserWorkflowResult((Object)Pair.of((Object)userUR, (Object)Boolean.FALSE), ((UserWorkflowResult)updated.getLeft()).getPropByRes(), ((UserWorkflowResult)updated.getLeft()).getPropByLinkedAccount(), ((UserWorkflowResult)updated.getLeft()).getPerformedTasks()));
            this.taskExecutor.execute((Collection)taskInfos, false, updater);
        }
    }

    public List<PropagationStatus> provision(String key, boolean changePwd, String password, Collection<String> resources, boolean nullPriorityAsync, String executor) {
        UserUR userUR = new UserUR();
        userUR.setKey(key);
        userUR.getResources().addAll(resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(r)).build()).collect(Collectors.toSet()));
        if (changePwd) {
            PasswordPatch passwordPatch = new PasswordPatch();
            passwordPatch.setOnSyncope(false);
            passwordPatch.getResources().addAll(resources);
            passwordPatch.setValue((Object)password);
            userUR.setPassword(passwordPatch);
        }
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.UPDATE, resources);
        UserWorkflowResult wfResult = new UserWorkflowResult((Object)Pair.of((Object)userUR, (Object)null), propByRes, null, "update");
        List taskInfos = this.propagationManager.getUserUpdateTasks(wfResult, changePwd, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, executor);
        return propagationReporter.getStatuses();
    }

    public List<PropagationStatus> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync, String executor) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.DELETE, resources);
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        this.userDAO.findLinkedAccounts(key).stream().filter(account -> resources.contains(account.getResource().getKey())).forEach(account -> propByLinkedAccount.add(ResourceOperation.DELETE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        List taskInfos = this.propagationManager.getDeleteTasks(AnyTypeKind.USER, key, propByRes, propByLinkedAccount, this.userDAO.findAllResourceKeys(key).stream().filter(resource -> !resources.contains(resource)).toList());
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, nullPriorityAsync, executor);
        return propagationReporter.getStatuses();
    }

    public void requestPasswordReset(String key, String updater, String context) {
        this.uwfAdapter.requestPasswordReset(key, updater, context);
    }

    public void confirmPasswordReset(String key, String token, String password, String updater, String context) {
        UserWorkflowResult updated = this.uwfAdapter.confirmPasswordReset(key, token, password, updater, context);
        List taskInfos = this.propagationManager.getUserUpdateTasks(updated);
        this.taskExecutor.execute((Collection)taskInfos, false, updater);
    }
}

