/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.persistence.api.dao.AuditEventDAO;
import org.apache.syncope.core.persistence.api.entity.AuditConf;
import org.apache.syncope.core.persistence.api.entity.AuditEvent;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.api.AuditEventProcessor;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.transaction.annotation.Transactional;

public class DefaultAuditManager
implements AuditManager {
    protected static final Logger LOG = LoggerFactory.getLogger(AuditManager.class);
    protected static final String MASKED_VALUE = "<MASKED>";
    protected final AuditConfDAO auditConfDAO;
    protected final AuditEventDAO auditEventDAO;
    protected final EntityFactory entityFactory;
    protected final List<AuditEventProcessor> auditEventProcessors;
    protected final AsyncTaskExecutor taskExecutor;

    protected static Object maskSensitive(Object object) {
        Object masked;
        if (object instanceof UserTO) {
            UserTO userTO = (UserTO)object;
            masked = SerializationUtils.clone((Serializable)userTO);
            if (((UserTO)masked).getPassword() != null) {
                ((UserTO)masked).setPassword(MASKED_VALUE);
            }
            if (((UserTO)masked).getSecurityAnswer() != null) {
                ((UserTO)masked).setSecurityAnswer(MASKED_VALUE);
            }
        } else if (object instanceof UserCR) {
            UserCR userCR = (UserCR)object;
            masked = SerializationUtils.clone((Serializable)userCR);
            if (((UserCR)masked).getPassword() != null) {
                ((UserCR)masked).setPassword(MASKED_VALUE);
            }
            if (((UserCR)masked).getSecurityAnswer() != null) {
                ((UserCR)masked).setSecurityAnswer(MASKED_VALUE);
            }
        } else if (object instanceof UserUR && ((UserUR)object).getPassword() != null) {
            masked = SerializationUtils.clone((Serializable)((UserUR)object));
            ((UserUR)masked).getPassword().setValue((Object)MASKED_VALUE);
        } else {
            masked = object;
        }
        return masked;
    }

    public DefaultAuditManager(AuditConfDAO auditConfDAO, AuditEventDAO auditEventDAO, EntityFactory entityFactory, List<AuditEventProcessor> auditEventProcessors, AsyncTaskExecutor taskExecutor) {
        this.auditConfDAO = auditConfDAO;
        this.auditEventDAO = auditEventDAO;
        this.entityFactory = entityFactory;
        this.auditEventProcessors = auditEventProcessors;
        this.taskExecutor = taskExecutor;
    }

    public boolean auditRequested(String domain, String who, OpEvent.CategoryType type, String category, String subcategory, String op) {
        return (Boolean)AuthContextUtils.callAsAdmin((String)domain, () -> {
            OpEvent opEvent = new OpEvent(type, category, subcategory, op, OpEvent.Outcome.SUCCESS);
            if (this.auditConfDAO.findById(opEvent.toString()).map(AuditConf::isActive).orElse(false).booleanValue()) {
                return true;
            }
            opEvent = new OpEvent(type, category, subcategory, op, OpEvent.Outcome.FAILURE);
            return this.auditConfDAO.findById(opEvent.toString()).map(AuditConf::isActive).orElse(false);
        });
    }

    public void audit(AfterHandlingEvent event) {
        this.audit(event.getDomain(), event.getWho(), event.getType(), event.getCategory(), event.getSubcategory(), event.getOp(), event.getOutcome(), event.getBefore(), event.getOutput(), event.getInput());
    }

    public void audit(final String domain, final String who, final OpEvent.CategoryType type, final String category, final String subcategory, final String op, final OpEvent.Outcome outcome, final Object before, final Object output, final Object ... input) {
        this.taskExecutor.submit(() -> AuthContextUtils.runAsAdmin((String)domain, (Runnable)new Runnable(){

            @Override
            @Transactional
            public void run() {
                OpEvent opEvent = new OpEvent(type, category, subcategory, op, outcome);
                Optional auditConf = DefaultAuditManager.this.auditConfDAO.findById(opEvent.toString());
                if (auditConf.isEmpty()) {
                    LOG.debug("No audit conf found for {}, skippping", (Object)opEvent.toString());
                    return;
                }
                if (!((AuditConf)auditConf.get()).isActive()) {
                    LOG.debug("Audit conf found for {} is not active, skippping", (Object)opEvent.toString());
                    return;
                }
                try {
                    AuditEvent auditEvent = (AuditEvent)DefaultAuditManager.this.entityFactory.newEntity(AuditEvent.class);
                    auditEvent.setOpEvent(opEvent.toString());
                    auditEvent.setWho(who);
                    auditEvent.setWhen(OffsetDateTime.now());
                    auditEvent.setBefore(POJOHelper.serialize((Object)DefaultAuditManager.maskSensitive(before)));
                    Optional.ofNullable(input).ifPresent(in -> auditEvent.setInputs(Arrays.stream(in).map(DefaultAuditManager::maskSensitive).map(POJOHelper::serialize).toList()));
                    if (output instanceof Throwable) {
                        Throwable throwable = (Throwable)output;
                        auditEvent.setOutput(throwable.getMessage());
                        auditEvent.setThrowable(ExceptionUtils2.getFullStackTrace((Throwable)throwable));
                    } else {
                        auditEvent.setOutput(POJOHelper.serialize((Object)DefaultAuditManager.maskSensitive(output)));
                    }
                    DefaultAuditManager.this.auditEventDAO.save(auditEvent);
                    DefaultAuditManager.this.auditEventProcessors.stream().filter(p -> p.getEvents(domain).contains(opEvent)).forEach(p -> p.process(domain, auditEvent));
                }
                catch (Exception e) {
                    LOG.error("While processing audit event for conf {}", (Object)opEvent, (Object)e);
                }
            }
        }));
    }
}

