/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.rest.factory;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetadata;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.credential.AbstractCredential;
import org.apereo.cas.authentication.metadata.BasicCredentialMetadata;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.springframework.core.Ordered;
import org.springframework.util.MultiValueMap;

@FunctionalInterface
public interface RestHttpRequestCredentialFactory
extends Ordered {
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";

    public List<Credential> fromRequest(HttpServletRequest var1, MultiValueMap<String, String> var2) throws Throwable;

    default public int getOrder() {
        return Integer.MAX_VALUE;
    }

    default public List<Credential> fromAuthentication(HttpServletRequest request, MultiValueMap<String, String> requestBody, Authentication authentication, MultifactorAuthenticationProvider provider) {
        return new ArrayList<Credential>(0);
    }

    default public Credential prepareCredential(HttpServletRequest request, Credential credential) {
        if (credential instanceof AbstractCredential) {
            AbstractCredential ac = (AbstractCredential)credential;
            CredentialMetadata credentialMetadata = Optional.ofNullable(ac.getCredentialMetadata()).orElseGet(() -> new BasicCredentialMetadata(credential));
            credentialMetadata.putProperties(HttpRequestUtils.getRequestHeaders((HttpServletRequest)request));
            ac.setCredentialMetadata(credentialMetadata);
        }
        return credential;
    }
}

