/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.authentication.SamlResponseBuilder;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml1.core.Response;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Endpoint(id="samlValidate", enableByDefault=false)
public class SamlValidateEndpoint
extends BaseCasRestActuatorEndpoint {
    private final ObjectProvider<ServicesManager> servicesManager;
    private final ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    private final ObjectProvider<ServiceFactory<WebApplicationService>> serviceFactory;
    private final ObjectProvider<PrincipalFactory> principalFactory;
    private final ObjectProvider<SamlResponseBuilder> samlResponseBuilder;
    private final ObjectProvider<OpenSamlConfigBean> openSamlConfigBean;
    private final ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    private final ObjectProvider<PrincipalResolver> principalResolver;

    public SamlValidateEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<ServicesManager> servicesManager, ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport, ObjectProvider<ServiceFactory<WebApplicationService>> serviceFactory, ObjectProvider<PrincipalFactory> principalFactory, ObjectProvider<SamlResponseBuilder> samlResponseBuilder, ObjectProvider<OpenSamlConfigBean> openSamlConfigBean, ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer, ObjectProvider<PrincipalResolver> principalResolver) {
        super(casProperties, applicationContext);
        this.servicesManager = servicesManager;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.serviceFactory = serviceFactory;
        this.principalFactory = principalFactory;
        this.samlResponseBuilder = samlResponseBuilder;
        this.openSamlConfigBean = openSamlConfigBean;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.principalResolver = principalResolver;
    }

    @PostMapping(produces={"text/xml", "application/xml", "application/json"}, consumes={"text/xml", "application/xml", "application/json", "application/x-www-form-urlencoded"})
    @Operation(summary="Handle validation request and produce saml1 payload.", parameters={@Parameter(name="username", required=true, description="The username"), @Parameter(name="password", required=false, description="The password"), @Parameter(name="service", required=true, description="The service")})
    public ResponseEntity handle(HttpServletRequest request, String username, @RequestParam(required=false) String password, String service) throws Throwable {
        WebApplicationService selectedService = (WebApplicationService)((ServiceFactory)this.serviceFactory.getObject()).createService(service);
        Authentication authentication = this.buildAuthentication(username, password, selectedService);
        RegisteredService registeredService = ((ServicesManager)this.servicesManager.getObject()).findServiceBy((Service)selectedService);
        AuditableContext audit = AuditableContext.builder().service((Service)selectedService).authentication(authentication).registeredService(registeredService).build();
        AuditableExecutionResult accessResult = ((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).execute(audit);
        accessResult.throwExceptionIfNeeded();
        Principal principal = authentication.getPrincipal();
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service((Service)selectedService).principal(principal).applicationContext((ApplicationContext)((OpenSamlConfigBean)this.openSamlConfigBean.getObject()).getApplicationContext()).build();
        Map attributesToRelease = registeredService.getAttributeReleasePolicy().getAttributes(context);
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService(registeredService).service((Service)selectedService).principal(principal).applicationContext((ApplicationContext)((OpenSamlConfigBean)this.openSamlConfigBean.getObject()).getApplicationContext()).build();
        String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(usernameContext);
        Principal modifiedPrincipal = ((PrincipalFactory)this.principalFactory.getObject()).createPrincipal(principalId, attributesToRelease);
        AuthenticationBuilder builder = DefaultAuthenticationBuilder.newInstance((Authentication)authentication);
        builder.setPrincipal(modifiedPrincipal);
        Authentication finalAuthentication = builder.build();
        Response samlResponse = ((SamlResponseBuilder)this.samlResponseBuilder.getObject()).createResponse(selectedService.getId(), selectedService);
        ((SamlResponseBuilder)this.samlResponseBuilder.getObject()).prepareSuccessfulResponse(Map.of(), samlResponse, (Service)selectedService, finalAuthentication, principal, finalAuthentication.getAttributes(), principal.getAttributes());
        String encoded = SamlUtils.transformSamlObject((OpenSamlConfigBean)((OpenSamlConfigBean)this.openSamlConfigBean.getObject()), (XMLObject)samlResponse).toString();
        String contentType = (String)StringUtils.defaultIfBlank((CharSequence)request.getHeader("Content-Type"), (CharSequence)"application/json");
        if ("application/xml".equals(contentType) || "text/xml".equals(contentType)) {
            HttpHeaders headers = new HttpHeaders();
            headers.put("Content-Type", List.of("text/xml"));
            return new ResponseEntity((Object)encoded, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        LinkedHashMap<String, String> resValidation = new LinkedHashMap<String, String>();
        resValidation.put("assertion", encoded);
        resValidation.put("service", (String)selectedService);
        resValidation.put("registeredService", (String)registeredService);
        HttpHeaders headers = new HttpHeaders();
        headers.put("Content-Type", List.of("application/json"));
        return new ResponseEntity(resValidation, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    private Authentication buildAuthentication(String username, String password, WebApplicationService selectedService) throws Throwable {
        if (StringUtils.isNotBlank((CharSequence)password)) {
            UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
            AuthenticationResult result = ((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).finalizeAuthenticationTransaction((Service)selectedService, new Credential[]{credential});
            return result.getAuthentication();
        }
        Principal principal = ((PrincipalResolver)this.principalResolver.getObject()).resolve((Credential)new BasicIdentifiableCredential(username), Optional.of(((PrincipalFactory)this.principalFactory.getObject()).createPrincipal(username)), Optional.empty(), Optional.of(selectedService));
        return DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).build();
    }
}

