/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yubico.core.WebAuthnServer;
import com.yubico.data.AssertionRequestWrapper;
import com.yubico.data.RegistrationRequest;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.util.Either;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ResidentKeyRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="webAuthnController")
@RequestMapping(value={"/webauthn"})
public class WebAuthnController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnController.class);
    public static final String BASE_ENDPOINT_WEBAUTHN = "/webauthn";
    public static final String WEBAUTHN_ENDPOINT_REGISTER = "/register";
    public static final String WEBAUTHN_ENDPOINT_AUTHENTICATE = "/authenticate";
    private static final String WEBAUTHN_ENDPOINT_FINISH = "/finish";
    private static final ObjectMapper MAPPER = JacksonCodecs.json().findAndRegisterModules();
    private final WebAuthnServer server;

    private static ResponseEntity<Object> startResponse(Object request) throws Exception {
        LOGGER.trace("Response: [{}]", request);
        return ResponseEntity.ok((Object)WebAuthnController.writeJson(request));
    }

    private static String writeJson(Object o) throws Exception {
        return MAPPER.writeValueAsString(o);
    }

    private static ResponseEntity<Object> finishResponse(Either<List<String>, ?> result, String responseJson) throws Exception {
        if (result.isRight()) {
            LOGGER.trace("Response: [{}]", (Object)responseJson);
            return ResponseEntity.ok((Object)WebAuthnController.writeJson(result.right().get()));
        }
        return WebAuthnController.messagesJson(ResponseEntity.badRequest(), result.left().get());
    }

    private static ResponseEntity<Object> messagesJson(ResponseEntity.BodyBuilder response, String message) {
        return WebAuthnController.messagesJson(response, List.of(message));
    }

    private static ResponseEntity<Object> messagesJson(ResponseEntity.BodyBuilder response, List<String> messages) {
        return response.body(Map.of("messages", messages));
    }

    @PostMapping(value={"/register"}, produces={"application/json"})
    public ResponseEntity<Object> startRegistration(@RequestParam(value="username") @NonNull String username, @RequestParam(value="displayName") @NonNull String displayName, @RequestParam(value="credentialNickname", required=false, defaultValue="") String credentialNickname, @RequestParam(value="requireResidentKey", required=false) boolean requireResidentKey, @RequestParam(value="sessionToken", required=false, defaultValue="") String sessionTokenBase64, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        Either<String, RegistrationRequest> result = this.server.startRegistration(username, Optional.of(displayName), Optional.ofNullable(credentialNickname), requireResidentKey ? ResidentKeyRequirement.REQUIRED : ResidentKeyRequirement.DISCOURAGED, Optional.ofNullable(sessionTokenBase64).map(Unchecked.function(ByteArray::fromBase64Url)));
        if (result.isRight()) {
            return WebAuthnController.startResponse(new StartRegistrationResponse(result.right().get()));
        }
        return WebAuthnController.messagesJson(ResponseEntity.badRequest(), result.left().get());
    }

    @PostMapping(value={"/register/finish"}, produces={"application/json"})
    public ResponseEntity<Object> finishRegistration(@RequestBody String responseJson) throws Exception {
        Either<List<String>, WebAuthnServer.SuccessfulRegistrationResult> result = this.server.finishRegistration(responseJson);
        return WebAuthnController.finishResponse(result, responseJson);
    }

    @PostMapping(value={"/authenticate"}, produces={"application/json"})
    public ResponseEntity<Object> startAuthentication(@RequestParam(value="username", required=false) String username) throws Exception {
        Either<List<String>, AssertionRequestWrapper> request = this.server.startAuthentication(Optional.ofNullable(username));
        if (request.isRight()) {
            return WebAuthnController.startResponse(new StartAuthenticationResponse(request.right().get()));
        }
        return WebAuthnController.messagesJson(ResponseEntity.badRequest(), request.left().get());
    }

    @PostMapping(value={"/authenticate/finish"}, produces={"application/json"})
    public ResponseEntity<Object> finishAuthentication(@RequestBody String responseJson) throws Exception {
        Either<List<String>, WebAuthnServer.SuccessfulAuthenticationResult> result = this.server.finishAuthentication(responseJson);
        return WebAuthnController.finishResponse(result, responseJson);
    }

    @Generated
    public WebAuthnController(WebAuthnServer server) {
        this.server = server;
    }

    private static final class StartRegistrationResponse {
        private final boolean success = true;
        private final RegistrationRequest request;
        private final StartRegistrationActions actions = new StartRegistrationActions();

        @Generated
        public StartRegistrationResponse(RegistrationRequest request) {
            this.request = request;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public RegistrationRequest getRequest() {
            return this.request;
        }

        @Generated
        public StartRegistrationActions getActions() {
            return this.actions;
        }
    }

    private static final class StartAuthenticationResponse {
        private final boolean success = true;
        private final AssertionRequestWrapper request;
        private final StartAuthenticationActions actions = new StartAuthenticationActions();

        @Generated
        public StartAuthenticationResponse(AssertionRequestWrapper request) {
            this.request = request;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public AssertionRequestWrapper getRequest() {
            return this.request;
        }

        @Generated
        public StartAuthenticationActions getActions() {
            return this.actions;
        }
    }

    private static final class StartAuthenticationActions {
        private final String finish = "/webauthn".substring(1) + "/authenticate/finish";

        private StartAuthenticationActions() {
        }

        @Generated
        public String getFinish() {
            return this.finish;
        }
    }

    private static final class StartRegistrationActions {
        private final String finish = "/webauthn".substring(1) + "/register/finish";

        private StartRegistrationActions() {
        }

        @Generated
        public String getFinish() {
            return this.finish;
        }
    }
}

