/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn;

import com.yubico.core.RegistrationStorage;
import com.yubico.data.CredentialRegistration;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.attestation.Attestation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.device.MultifactorAuthenticationDeviceManager;
import org.apereo.cas.authentication.device.MultifactorAuthenticationRegisteredDevice;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.function.FunctionUtils;

public class WebAuthnMultifactorAuthenticationDeviceManager
implements MultifactorAuthenticationDeviceManager {
    private final RegistrationStorage webAuthnCredentialRepository;

    public List<MultifactorAuthenticationRegisteredDevice> findRegisteredDevices(Principal principal) {
        Collection<CredentialRegistration> registrations = this.webAuthnCredentialRepository.getRegistrationsByUsername(principal.getId());
        return registrations.stream().filter(Objects::nonNull).map(this::mapWebAuthnAccount).collect(Collectors.toList());
    }

    protected MultifactorAuthenticationRegisteredDevice mapWebAuthnAccount(CredentialRegistration acct) {
        Map vendor = Optional.ofNullable(acct.getAttestationMetadata()).orElseGet(Attestation::empty).getVendorProperties().orElseGet(Map::of);
        Map device = Optional.ofNullable(acct.getAttestationMetadata()).orElseGet(Attestation::empty).getDeviceProperties().orElseGet(Map::of);
        return (MultifactorAuthenticationRegisteredDevice)FunctionUtils.doUnchecked(() -> MultifactorAuthenticationRegisteredDevice.builder().id(acct.getCredential().getCredentialId().getBase64Url()).name(acct.getCredentialNickname()).type((String)vendor.get("name")).model((String)device.get("displayName")).lastUsedDateTime(acct.getRegistrationTime().toString()).payload(JacksonCodecs.json().writerWithDefaultPrettyPrinter().writeValueAsString((Object)acct)).source("Web Authn").build());
    }

    @Generated
    public WebAuthnMultifactorAuthenticationDeviceManager(RegistrationStorage webAuthnCredentialRepository) {
        this.webAuthnCredentialRepository = webAuthnCredentialRepository;
    }
}

