/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import com.yubico.webauthn.attestation.DeviceMatcher;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.exception.HexException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionMatcher
implements DeviceMatcher {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionMatcher.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final String SELECTOR_TYPE = "x509Extension";
    private static final String EXTENSION_KEY = "key";
    private static final String EXTENSION_VALUE = "value";
    private static final String EXTENSION_VALUE_TYPE = "type";
    private static final String EXTENSION_VALUE_VALUE = "value";
    private static final String EXTENSION_VALUE_TYPE_HEX = "hex";

    @Override
    public boolean matches(X509Certificate attestationCertificate, JsonNode parameters) {
        String matchKey = parameters.get(EXTENSION_KEY).asText();
        JsonNode matchValue = parameters.get("value");
        byte[] extensionValue = attestationCertificate.getExtensionValue(matchKey);
        if (extensionValue != null) {
            if (matchValue == null) {
                return true;
            }
            try {
                ASN1Primitive value = ASN1Primitive.fromByteArray((byte[])extensionValue);
                if (matchValue.isObject() ? ExtensionMatcher.matchTypedValue(matchKey, matchValue, value) : matchValue.isTextual() && ExtensionMatcher.matchStringValue(matchKey, matchValue, value)) {
                    return true;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to parse extension value as ASN1: {}", (Object)new ByteArray(extensionValue).getHex(), (Object)e);
            }
        }
        return false;
    }

    private static boolean matchStringValue(String matchKey, JsonNode matchValue, ASN1Primitive value) {
        if (value instanceof DEROctetString) {
            String readValue = new String(((ASN1OctetString)value).getOctets(), CHARSET);
            return matchValue.asText().equals(readValue);
        }
        LOGGER.debug("Expected text string value for extension {}, was: {}", (Object)matchKey, (Object)value);
        return false;
    }

    private static boolean matchTypedValue(String matchKey, JsonNode matchValue, ASN1Primitive value) {
        String extensionValueType;
        switch (extensionValueType = matchValue.get(EXTENSION_VALUE_TYPE).textValue()) {
            case "hex": {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown extension value type \"%s\" for extension \"%s\"", extensionValueType, matchKey));
            }
        }
        return ExtensionMatcher.matchHex(matchKey, matchValue, value);
    }

    private static boolean matchHex(String matchKey, JsonNode matchValue, ASN1Primitive value) {
        ASN1Primitive innerValue;
        ByteArray matchBytes;
        String matchValueString = matchValue.get("value").textValue();
        try {
            matchBytes = ByteArray.fromHex((String)matchValueString);
        }
        catch (HexException e) {
            throw new IllegalArgumentException(String.format("Bad hex value in extension %s: %s", matchKey, matchValueString));
        }
        if (value instanceof DEROctetString) {
            DEROctetString instance = (DEROctetString)value;
            try {
                innerValue = ASN1Primitive.fromByteArray((byte[])instance.getOctets());
            }
            catch (IOException e) {
                LOGGER.debug("Failed to parse {} extension value as ASN1: {}", (Object)matchKey, (Object)value);
                return false;
            }
        } else {
            LOGGER.debug("Expected nested bit string value for extension {}, was: {}", (Object)matchKey, (Object)value);
            return false;
        }
        if (innerValue instanceof DEROctetString) {
            DEROctetString octetString = (DEROctetString)innerValue;
            ByteArray readBytes = new ByteArray(octetString.getOctets());
            return matchBytes.equals((Object)readBytes);
        }
        LOGGER.debug("Expected nested bit string value for extension {}, was: {}", (Object)matchKey, (Object)value);
        return false;
    }
}

