/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.core;

import com.github.benmanes.caffeine.cache.Cache;
import com.yubico.core.SessionManager;
import com.yubico.webauthn.data.ByteArray;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class DefaultSessionManager
implements SessionManager {
    private final Cache<ByteArray, ByteArray> sessionIdsToUsers;
    private final Cache<ByteArray, ByteArray> usersToSessionIds;

    @Override
    public ByteArray createSession(@NonNull ByteArray userHandle) {
        if (userHandle == null) {
            throw new NullPointerException("userHandle is marked non-null but is null");
        }
        ByteArray sessionId = (ByteArray)this.usersToSessionIds.get((Object)userHandle, __ -> SessionManager.generateRandom(32));
        this.sessionIdsToUsers.put((Object)sessionId, (Object)userHandle);
        return sessionId;
    }

    @Override
    public Optional<ByteArray> getSession(@NonNull ByteArray token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return Optional.ofNullable((ByteArray)this.sessionIdsToUsers.getIfPresent((Object)token));
    }

    @Generated
    public DefaultSessionManager(Cache<ByteArray, ByteArray> sessionIdsToUsers, Cache<ByteArray, ByteArray> usersToSessionIds) {
        this.sessionIdsToUsers = sessionIdsToUsers;
        this.usersToSessionIds = usersToSessionIds;
    }
}

