/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web.flow.account;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.MultifactorAuthenticationAccountProfileWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class WebAuthnMultifactorAccountProfileWebflowConfigurer
extends MultifactorAuthenticationAccountProfileWebflowConfigurer {
    public WebAuthnMultifactorAccountProfileWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry accountProfileFlowRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, accountProfileFlowRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        super.doInitialize();
        Flow accountFlow = this.getFlow("account");
        ViewState myAccountView = (ViewState)this.getState(accountFlow, "myAccountProfile", ViewState.class);
        myAccountView.getRenderActionList().add((Action)this.createEvaluateAction("webAuthnAccountProfilePrepareAction"));
        SetAction setPrincipalAction = this.createSetAction("viewScope.principal", "conversationScope.authentication.principal");
        ViewState regViewState = this.createViewState(accountFlow, "viewRegistrationWebAuthn", "webauthn/casWebAuthnRegistrationView");
        regViewState.getEntryActionList().addAll(new Action[]{setPrincipalAction, this.createEvaluateAction("populateSpringSecurityContextAction"), this.createEvaluateAction("webAuthnPopulateCsrfTokenAction"), this.createEvaluateAction("webAuthnAccountProfileRegistrationAction"), this.createEvaluateAction("webAuthnStartRegistrationAction")});
        this.createTransitionForState((TransitionableState)regViewState, "submit", "saveRegistration");
        ViewState accountProfileView = (ViewState)accountFlow.getState("myAccountProfile");
        this.createTransitionForState((TransitionableState)accountProfileView, "register", regViewState.getId());
    }
}

