/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web.flow;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.configurer.AbstractCasMultifactorWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.apereo.cas.webauthn.WebAuthnCredential;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class WebAuthnMultifactorWebflowConfigurer
extends AbstractCasMultifactorWebflowConfigurer {
    public static final String FLOW_ID_MFA_WEBAUTHN = "mfa-webauthn";

    public WebAuthnMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<CasMultifactorWebflowCustomizer> mfaFlowCustomizers) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties, Optional.of(flowDefinitionRegistry), mfaFlowCustomizers);
    }

    protected void doInitialize() {
        this.multifactorAuthenticationFlowDefinitionRegistries.forEach(registry -> {
            Flow flow = this.getFlow((FlowDefinitionRegistry)registry, FLOW_ID_MFA_WEBAUTHN);
            this.createFlowVariable(flow, "credential", WebAuthnCredential.class);
            flow.getStartActionList().add((Action)this.createEvaluateAction("initialFlowSetupAction"));
            this.createEndState(flow, "success");
            ActionState initLoginFormState = this.createActionState(flow, "initializeLoginForm", (Action)this.createEvaluateAction("initializeLoginAction"));
            this.createTransitionForState((TransitionableState)initLoginFormState, "success", "accountRegistrationCheck");
            this.setStartState(flow, (TransitionableState)initLoginFormState);
            ActionState acctRegCheckState = this.createActionState(flow, "accountRegistrationCheck", (Action)this.createEvaluateAction("webAuthnCheckAccountRegistrationAction"));
            this.createTransitionForState((TransitionableState)acctRegCheckState, "register", "viewRegistrationWebAuthn");
            this.createTransitionForState((TransitionableState)acctRegCheckState, "success", "viewLoginForm");
            SetAction setPrincipalAction = this.createSetAction("viewScope.principal", "conversationScope.authentication.principal");
            ViewState viewRegState = this.createViewState(flow, "viewRegistrationWebAuthn", "webauthn/casWebAuthnRegistrationView");
            viewRegState.getEntryActionList().addAll(new Action[]{this.createEvaluateAction("populateSpringSecurityContextAction"), this.createEvaluateAction("webAuthnPopulateCsrfTokenAction"), this.createEvaluateAction("webAuthnStartRegistrationAction"), setPrincipalAction});
            this.createTransitionForState((TransitionableState)viewRegState, "submit", "saveRegistration");
            ActionState saveState = this.createActionState(flow, "saveRegistration", new String[]{"webAuthnSaveAccountRegistrationAction"});
            this.createTransitionForState((TransitionableState)saveState, "success", "accountRegistrationCheck");
            this.createTransitionForState((TransitionableState)saveState, "error", "stopWebflow");
            List loginProperties = CollectionUtils.wrapList((Object[])new String[]{"token"});
            BinderConfiguration loginBinder = this.createStateBinderConfiguration(loginProperties);
            ViewState viewLoginFormState = this.createViewState(flow, "viewLoginForm", "webauthn/casWebAuthnLoginView", loginBinder);
            this.createStateModelBinding((TransitionableState)viewLoginFormState, "credential", WebAuthnCredential.class);
            viewLoginFormState.getEntryActionList().addAll(new Action[]{this.createEvaluateAction("webAuthnPopulateCsrfTokenAction"), this.createEvaluateAction("webAuthnStartAuthenticationAction"), setPrincipalAction});
            this.createTransitionForState((TransitionableState)viewLoginFormState, "validate", "realSubmit", Map.of("bind", Boolean.TRUE, "validate", Boolean.TRUE));
            ActionState realSubmitState = this.createActionState(flow, "realSubmit", (Action)this.createEvaluateAction("webAuthnAuthenticationWebflowAction"));
            this.createTransitionForState((TransitionableState)realSubmitState, "success", "success");
            this.createTransitionForState((TransitionableState)realSubmitState, "error", "viewLoginForm");
            this.createViewState(flow, "stopWebflow", "error");
        });
        WebAuthnMultifactorAuthenticationProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn();
        this.registerMultifactorProviderAuthenticationWebflow(this.getLoginFlow(), FLOW_ID_MFA_WEBAUTHN, webAuthn.getId());
        Flow flow = this.getLoginFlow();
        if (flow != null && webAuthn.getCore().isAllowPrimaryAuthentication()) {
            String appId = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)webAuthn.getCore().getApplicationId(), (CharSequence)this.casProperties.getServer().getName());
            SetAction setAppIdAction = this.createSetAction("flowScope.webauthnApplicationId", StringUtils.quote((String)appId));
            flow.getStartActionList().add((Action)setAppIdAction);
            flow.getStartActionList().add((Action)this.createEvaluateAction("webAuthnPopulateCsrfTokenAction"));
            SetAction setPrimaryAuthAction = this.createSetAction("flowScope.webAuthnPrimaryAuthenticationEnabled", "true");
            flow.getStartActionList().add((Action)setPrimaryAuthAction);
            TransitionableState viewLoginFormState = this.getState(flow, "viewLoginForm");
            this.createTransitionForState(viewLoginFormState, "validate", "validateWebAuthnToken");
            ActionState validateAction = this.createActionState(flow, "validateWebAuthnToken", new String[]{"webAuthnValidateSessionCredentialTokenAction"});
            validateAction.getEntryActionList().add((Action)this.createSetAction("flowScope.".concat("mfaProviderId"), StringUtils.quote((String)webAuthn.getId())));
            this.createTransitionForState((TransitionableState)validateAction, "finalize", "realSubmit");
        }
    }
}

