/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.List;
import java.util.Map;
import org.apereo.cas.util.thread.Cleanable;
import org.apereo.inspektr.audit.AuditActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface AuditTrailManager
extends Cleanable {
    public static final Logger LOG = LoggerFactory.getLogger(AuditTrailManager.class);
    public static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);

    public static String toJson(Object arg) {
        try {
            return MAPPER.writeValueAsString(arg);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void record(AuditActionContext var1);

    default public List<? extends AuditActionContext> getAuditRecords(Map<WhereClauseFields, Object> whereClause) {
        return List.of();
    }

    default public void removeAll() {
    }

    default public void setAuditFormat(AuditFormats auditFormat) {
    }

    public static enum AuditFormats {
        DEFAULT{

            @Override
            public String serialize(Object object) {
                return object.toString();
            }
        }
        ,
        JSON{

            @Override
            public String serialize(Object object) {
                return AuditTrailManager.toJson(object);
            }
        };


        public abstract String serialize(Object var1);
    }

    public static enum WhereClauseFields {
        DATE,
        PRINCIPAL,
        COUNT;

    }

    public static enum AuditableFields {
        WHO,
        WHAT,
        ACTION,
        APPLICATION,
        WHEN,
        USER_AGENT,
        CLIENT_IP,
        SERVER_IP,
        GEO_LOCATION,
        DEVICE_FINGERPRINT,
        HEADERS;

    }
}

