/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.delegation.DelegationAutoRedirectTypes;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.DelegatedClientIdentityProviderConfiguration;
import org.apereo.cas.web.flow.DelegatedAuthenticationSingleSignOnEvaluator;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationGenerateClientsAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationGenerateClientsAction.class);
    private final DelegatedAuthenticationSingleSignOnEvaluator singleSignOnEvaluator;

    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        return (Event)FunctionUtils.doUnchecked(() -> {
            this.produceDelegatedAuthenticationClientsForContext(requestContext);
            return this.success();
        });
    }

    protected void produceDelegatedAuthenticationClientsForContext(RequestContext context) throws Throwable {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        Set providers = this.singleSignOnEvaluator.configurationContext().getDelegatedClientIdentityProvidersProducer().produce(context);
        LOGGER.trace("Delegated authentication providers are finalized as [{}]", (Object)providers);
        WebUtils.createCredential((RequestContext)context);
        if (HttpStatus.resolve((int)response.getStatus()).is2xxSuccessful()) {
            this.singleSignOnEvaluator.configurationContext().getDelegatedClientIdentityProviderConfigurationPostProcessor().process(context, providers);
            if (!this.singleSignOnEvaluator.singleSignOnSessionExists(context)) {
                this.handleServerAutoRedirectIfAny(context, providers);
            }
        }
    }

    protected void handleServerAutoRedirectIfAny(RequestContext context, Set<DelegatedClientIdentityProviderConfiguration> providers) {
        providers.stream().filter(provider -> provider.getAutoRedirectType() == DelegationAutoRedirectTypes.SERVER).findFirst().ifPresent(Unchecked.consumer(provider -> {
            LOGGER.debug("Redirecting to [{}]", (Object)provider.getRedirectUrl());
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
            response.sendRedirect(provider.getRedirectUrl());
        }));
    }

    @Generated
    public DelegatedAuthenticationGenerateClientsAction(DelegatedAuthenticationSingleSignOnEvaluator singleSignOnEvaluator) {
        this.singleSignOnEvaluator = singleSignOnEvaluator;
    }

    @Generated
    public DelegatedAuthenticationSingleSignOnEvaluator getSingleSignOnEvaluator() {
        return this.singleSignOnEvaluator;
    }
}

