/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow.account;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.oidc.web.flow.account.AccountOAuth20AccessToken;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryQueryCriteria;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OidcAccountProfileAccessTokenAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAccountProfileAccessTokenAction.class);
    private final TicketRegistry ticketRegistry;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        Ticket tgt = WebUtils.getTicketGrantingTicket((RequestContext)requestContext);
        if (tgt instanceof AuthenticationAwareTicket) {
            AuthenticationAwareTicket aat = (AuthenticationAwareTicket)tgt;
            TicketRegistryQueryCriteria criteria = TicketRegistryQueryCriteria.builder().type("AT").decode(Boolean.TRUE.booleanValue()).principal(aat.getAuthentication().getPrincipal().getId()).build();
            List<AccountOAuth20AccessToken> accessTokens = this.ticketRegistry.query(criteria).stream().map(OAuth20AccessToken.class::cast).map(AccountOAuth20AccessToken::new).toList();
            requestContext.getFlowScope().put("oidcAccessTokens", accessTokens);
        }
        return null;
    }

    @Generated
    public OidcAccountProfileAccessTokenAction(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

