/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class OidcWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public OidcWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow loginFlow = this.getLoginFlow();
        if (loginFlow != null) {
            ViewState state = (ViewState)this.getTransitionableState(loginFlow, "viewLoginForm", ViewState.class);
            state.getEntryActionList().add((Action)this.createEvaluateAction("oidcRegisteredServiceUIAction"));
        }
    }

    public void postInitialization(ConfigurableApplicationContext applicationContext) {
        Flow flow = this.getFlow("account");
        if (flow != null) {
            EvaluateAction prepAction = this.createEvaluateAction("oidcAccountProfileAccessTokensAction");
            ViewState accountView = (ViewState)this.getState(flow, "myAccountProfile", ViewState.class);
            accountView.getRenderActionList().add((Action)prepAction);
        }
    }
}

