/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.jwks;

import io.swagger.v3.oas.annotations.Operation;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;

@Endpoint(id="oidcJwks", enableByDefault=false)
public class OidcJwksRotationEndpoint
extends BaseCasRestActuatorEndpoint {
    private final ObjectProvider<OidcJsonWebKeystoreRotationService> rotationService;

    public OidcJwksRotationEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<OidcJsonWebKeystoreRotationService> rotationService) {
        super(casProperties, applicationContext);
        this.rotationService = rotationService;
    }

    @GetMapping(path={"/rotate"}, produces={"application/json"})
    @Operation(summary="Rotate keys in the keystore forcefully")
    public ResponseEntity<String> handleRotation() throws Throwable {
        JsonWebKeySet rotation = ((OidcJsonWebKeystoreRotationService)this.rotationService.getObject()).rotate();
        return new ResponseEntity((Object)rotation.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(path={"/revoke"}, produces={"application/json"})
    @Operation(summary="Revoke keys in the keystore forcefully")
    public ResponseEntity<String> handleRevocation() throws Throwable {
        JsonWebKeySet rotation = ((OidcJsonWebKeystoreRotationService)this.rotationService.getObject()).revoke();
        return new ResponseEntity((Object)rotation.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY), (HttpStatusCode)HttpStatus.OK);
    }
}

