/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.ciba;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcCibaVerificationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.ticket.OidcCibaRequest;
import org.apereo.cas.oidc.ticket.OidcCibaRequestFactory;
import org.apereo.cas.oidc.token.ciba.CibaTokenDeliveryHandler;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.oidc.web.controllers.ciba.CibaRequestContext;
import org.apereo.cas.oidc.web.controllers.ciba.OidcCibaResponse;
import org.apereo.cas.services.OidcBackchannelTokenDeliveryModes;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.inspektr.audit.annotation.Audit;
import org.jose4j.jwt.JwtClaims;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

public class OidcCibaController
extends BaseOidcController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcCibaController.class);
    protected final List<CibaTokenDeliveryHandler> tokenDeliveryHandlers;

    public OidcCibaController(OidcConfigurationContext configurationContext, List<CibaTokenDeliveryHandler> tokenDeliveryHandlers) {
        super(configurationContext);
        this.tokenDeliveryHandlers = List.copyOf(tokenDeliveryHandlers);
    }

    @GetMapping(value={"/oidc/oidcCiba/{clientId}/{requestId}", "/**/oidcCiba/{clientId}/{requestId}"})
    public Object initializeBackchannelVerificationRequest(@PathVariable(value="clientId") String clientId, @PathVariable(value="requestId") String requestId) throws Throwable {
        try {
            OidcRegisteredService registeredService = this.findRegisteredService(clientId);
            OidcCibaRequest cibaRequest = this.fetchOidcCibaRequest(requestId);
            LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
            model.put("registeredService", registeredService);
            model.put("cibaRequest", cibaRequest);
            Map attributes = cibaRequest.getAuthentication().getAttributes();
            if (attributes.containsKey("binding_message")) {
                Object bindingMessage = ((List)attributes.get("binding_message")).getFirst();
                model.put("bindingMessage", bindingMessage);
            }
            model.put("userCodeRequired", cibaRequest.getAuthentication().containsAttribute("user_code"));
            return new ModelAndView("oidcCibaVerificationView", model);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
    }

    @PostMapping(value={"/oidc/oidcCiba/{clientId}/{requestId}", "/**/oidcCiba/{clientId}/{requestId}"}, produces={"application/json"})
    public ResponseEntity verifyBackchannelVerificationRequest(@RequestParam(value="userCode", required=false) String userCode, @PathVariable(value="clientId") String clientId, @PathVariable(value="requestId") String requestId) throws Throwable {
        try {
            OidcRegisteredService registeredService = this.findRegisteredService(clientId);
            OidcCibaRequest cibaRequest = this.fetchOidcCibaRequest(requestId);
            if (cibaRequest.getAuthentication().containsAttribute("user_code")) {
                List<String> userCodeValues = ((List)cibaRequest.getAuthentication().getAttributes().get("user_code")).stream().map(Object::toString).filter(StringUtils::isNotBlank).toList();
                if (StringUtils.isBlank((CharSequence)userCode) || !userCodeValues.contains(userCode)) {
                    throw new AuthenticationException("Unable to verify provided user code " + userCode);
                }
            }
            for (CibaTokenDeliveryHandler handler : this.tokenDeliveryHandlers) {
                if (!BeanSupplier.isNotProxy((Object)handler) || !handler.supports(registeredService)) continue;
                handler.deliver(registeredService, cibaRequest);
            }
            LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
            model.put("registeredService", registeredService);
            model.put("cibaRequest", cibaRequest);
            return ResponseEntity.ok(model);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
    }

    @PostMapping(value={"/oidc/oidcCiba", "/**/oidcCiba"}, produces={"application/json"})
    @Audit(action="OIDC_CIBA_RESPONSE", actionResolverName="OIDC_CIBA_RESPONSE_ACTION_RESOLVER", resourceResolverName="OIDC_CIBA_RESPONSE_RESOURCE_RESOLVER")
    public ResponseEntity handleBackchannelAuthnRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        JEEContext webContext = new JEEContext(request, response);
        CibaRequestContext cibaRequestContext = this.buildCibaRequestContext((WebContext)webContext);
        int hintCount = StringUtils.isNotBlank((CharSequence)cibaRequestContext.getLoginHint()) ? 1 : 0;
        hintCount += StringUtils.isNotBlank((CharSequence)cibaRequestContext.getLoginHintToken()) ? 1 : 0;
        if ((hintCount += StringUtils.isNotBlank((CharSequence)cibaRequestContext.getIdTokenHint()) ? 1 : 0) > 1) {
            return this.badCibaRequest("More than one hint specified");
        }
        if (cibaRequestContext.getScope().isEmpty() || !cibaRequestContext.getScope().contains(OidcConstants.StandardScopes.OPENID.getScope())) {
            return this.badCibaRequest("Scope must contain %s".formatted(OidcConstants.StandardScopes.OPENID.getScope()));
        }
        OidcRegisteredService registeredService = this.findRegisteredService(cibaRequestContext);
        if (!registeredService.isBackchannelUserCodeParameterSupported() && !((OidcConfigurationContext)this.configurationContext).getDiscoverySettings().isBackchannelUserCodeParameterSupported() && StringUtils.isNotBlank((CharSequence)cibaRequestContext.getUserCode())) {
            return this.badCibaRequest("User code is not supported");
        }
        OidcBackchannelTokenDeliveryModes deliveryMode = OidcBackchannelTokenDeliveryModes.valueOf((String)registeredService.getBackchannelTokenDeliveryMode().toUpperCase(Locale.ENGLISH));
        if ((deliveryMode == OidcBackchannelTokenDeliveryModes.PUSH || deliveryMode == OidcBackchannelTokenDeliveryModes.PING) && StringUtils.isBlank((CharSequence)cibaRequestContext.getClientNotificationToken())) {
            return this.badCibaRequest("Client notification token is required");
        }
        if (StringUtils.isBlank((CharSequence)registeredService.getBackchannelClientNotificationEndpoint()) || !StringUtils.startsWithIgnoreCase((CharSequence)registeredService.getBackchannelClientNotificationEndpoint(), (CharSequence)"https://")) {
            return this.badCibaRequest("Client backchannel notification endpoint is invalid");
        }
        Principal principal = this.determineCibaRequestPrincipal(cibaRequestContext, registeredService);
        if (principal == null) {
            return this.badCibaRequest("Unable to determine subject");
        }
        LOGGER.debug("Resolved CIBA principal to be [{}]", (Object)principal);
        EmailProperties emailProperties = ((OidcConfigurationContext)this.configurationContext).getCasProperties().getAuthn().getOidc().getCiba().getVerification().getMail();
        if (!CollectionUtils.containsAny(principal.getAttributes().keySet(), (Collection)emailProperties.getAttributeName())) {
            return this.badCibaRequest("Principal does not contain required attributes for notification");
        }
        OidcCibaRequest cibaRequest = this.recordCibaRequest(cibaRequestContext.withPrincipal(principal));
        request.setAttribute(CibaRequestContext.class.getName(), (Object)cibaRequestContext);
        request.setAttribute(Principal.class.getName(), (Object)principal);
        ResponseEntity cibaResponse = this.buildCibaResponse(cibaRequest);
        this.scheduleUserVerificationRequest(cibaRequest, cibaRequestContext, registeredService);
        return cibaResponse;
    }

    protected void scheduleUserVerificationRequest(OidcCibaRequest cibaRequestId, CibaRequestContext cibaRequest, OidcRegisteredService registeredService) {
        OidcCibaVerificationProperties verification = ((OidcConfigurationContext)this.configurationContext).getCasProperties().getAuthn().getOidc().getCiba().getVerification();
        long delayInSeconds = Beans.newDuration((String)verification.getDelay()).toSeconds();
        ((OidcConfigurationContext)this.configurationContext).getTaskScheduler().schedule(() -> this.notifyUserForCibaRequestVerification(cibaRequestId, cibaRequest, registeredService), LocalDateTime.now(Clock.systemUTC()).plusSeconds(delayInSeconds).toInstant(ZoneOffset.UTC));
    }

    protected void notifyUserForCibaRequestVerification(OidcCibaRequest cibaRequest, CibaRequestContext cibaRequestContext, OidcRegisteredService registeredService) {
        EmailProperties mail = ((OidcConfigurationContext)this.configurationContext).getCasProperties().getAuthn().getOidc().getCiba().getVerification().getMail();
        Principal principal = cibaRequest.getAuthentication().getPrincipal();
        String verificationUrl = this.buildCibaVerificationUrl(cibaRequest);
        Map<String, OidcCibaRequest> parameters = Map.of("verificationUrl", verificationUrl, "registeredService", registeredService, "cibaRequest", cibaRequest);
        String body = EmailMessageBodyBuilder.builder().properties(mail).parameters(parameters).build().get();
        boolean sent = mail.getAttributeName().stream().map(attributeName -> {
            String resolvedAttribute = SpringExpressionLanguageValueResolver.getInstance().resolve(attributeName);
            EmailMessageRequest emailRequest = EmailMessageRequest.builder().emailProperties(mail).body(body).principal(principal).attribute(resolvedAttribute).build();
            return ((OidcConfigurationContext)this.configurationContext).getCommunicationsManager().email(emailRequest);
        }).anyMatch(EmailCommunicationResult::isSuccess);
        Assert.isTrue((boolean)sent, (String)("Could not send email to " + principal.getId()));
    }

    private String buildCibaVerificationUrl(OidcCibaRequest cibaRequest) {
        return (String)FunctionUtils.doUnchecked(() -> new URIBuilder(((OidcConfigurationContext)this.configurationContext).getCasProperties().getServer().getPrefix()).appendPath("oidc").appendPath("oidcCiba").appendPath(cibaRequest.getClientId()).appendPath(cibaRequest.getEncodedId()).build().toString());
    }

    protected OidcRegisteredService findRegisteredService(CibaRequestContext cibaRequest) {
        return this.findRegisteredService(cibaRequest.getClientId());
    }

    protected OidcRegisteredService findRegisteredService(String clientId) {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)((OidcConfigurationContext)this.configurationContext).getServicesManager(), (String)clientId);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
        return (OidcRegisteredService)registeredService;
    }

    protected CibaRequestContext buildCibaRequestContext(WebContext webContext) {
        ProfileManager manager = new ProfileManager(webContext, ((OidcConfigurationContext)this.getConfigurationContext()).getSessionStore());
        OAuth20RequestParameterResolver requestParameterResolver = ((OidcConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver();
        UserProfile userProfile = (UserProfile)manager.getProfile().orElseThrow();
        String clientId = userProfile.getAttribute("client_id").toString();
        return ((CibaRequestContext.CibaRequestContextBuilder)((CibaRequestContext.CibaRequestContextBuilder)((CibaRequestContext.CibaRequestContextBuilder)((CibaRequestContext.CibaRequestContextBuilder)((CibaRequestContext.CibaRequestContextBuilder)((CibaRequestContext.CibaRequestContextBuilder)((CibaRequestContext.CibaRequestContextBuilder)((CibaRequestContext.CibaRequestContextBuilder)((CibaRequestContext.CibaRequestContextBuilder)((CibaRequestContext.CibaRequestContextBuilder)CibaRequestContext.builder().acrValues(requestParameterResolver.resolveRequestParameters(webContext, "acr_values"))).bindingMessage(requestParameterResolver.resolveRequestParameter(webContext, "binding_message").orElse(null))).clientNotificationToken(requestParameterResolver.resolveRequestParameter(webContext, "client_notification_token").orElse(null))).idTokenHint(requestParameterResolver.resolveRequestParameter(webContext, "id_token_hint").orElse(null))).loginHint(requestParameterResolver.resolveRequestParameter(webContext, "login_hint").orElse(null))).loginHintToken(requestParameterResolver.resolveRequestParameter(webContext, "login_hint_token").orElse(null))).requestedExpiry(requestParameterResolver.resolveRequestParameter(webContext, "requested_expiry", Long.class).orElse(0L))).scope(requestParameterResolver.resolveRequestScopes(webContext))).clientId(clientId)).userCode(requestParameterResolver.resolveRequestParameter(webContext, "user_code").orElse(null))).build();
    }

    protected ResponseEntity buildCibaResponse(OidcCibaRequest cibaRequest) {
        LoggingUtils.protocolMessage((String)"OpenID Connect Backchannel Authentication Response", Map.of("CAS Auth Request ID", cibaRequest.getId(), "Client Auth Request ID", cibaRequest.getEncodedId(), "Client ID", cibaRequest.getClientId(), "Scopes", cibaRequest.getScopes(), "Principal", cibaRequest.getAuthentication().getPrincipal().getId()));
        OidcCibaResponse cibaResponse = new OidcCibaResponse(cibaRequest.getEncodedId(), cibaRequest.getExpirationPolicy().getTimeToLive());
        return ResponseEntity.ok((Object)cibaResponse);
    }

    protected OidcCibaRequest recordCibaRequest(CibaRequestContext cibaRequestContext) throws Throwable {
        LoggingUtils.protocolMessage((String)"OpenID Connect Backchannel Authentication Request", Map.of("Client ID", cibaRequestContext.getClientId(), "Scopes", cibaRequestContext.getScope(), "Binding Message", StringUtils.defaultString((String)cibaRequestContext.getBindingMessage()), "Principal", cibaRequestContext.getPrincipal().getId()));
        OidcCibaRequestFactory cibaFactory = (OidcCibaRequestFactory)((OidcConfigurationContext)this.configurationContext).getTicketFactory().get(OidcCibaRequest.class);
        OidcCibaRequest cibaRequest = cibaFactory.create(cibaRequestContext);
        ((OidcConfigurationContext)this.configurationContext).getTicketRegistry().addTicket((Ticket)cibaRequest);
        return cibaRequest;
    }

    protected ResponseEntity badCibaRequest(String error) {
        Map body = OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)error);
        return ResponseEntity.badRequest().body((Object)body);
    }

    protected Principal determineCibaRequestPrincipal(CibaRequestContext cibaRequest, OidcRegisteredService registeredService) throws Throwable {
        String subject = cibaRequest.getLoginHint();
        if (StringUtils.isNotBlank((CharSequence)cibaRequest.getIdTokenHint())) {
            JwtClaims claims = ((OidcConfigurationContext)this.configurationContext).getIdTokenSigningAndEncryptionService().decode(cibaRequest.getIdTokenHint(), Optional.of(registeredService));
            subject = claims.getSubject();
        }
        if (StringUtils.isNotBlank((CharSequence)cibaRequest.getLoginHintToken())) {
            subject = JwtBuilder.parse((String)cibaRequest.getLoginHint()).getSubject();
        }
        if (StringUtils.isNotBlank((CharSequence)subject)) {
            return ((OidcConfigurationContext)this.configurationContext).getPrincipalResolver().resolve((Credential)new BasicIdentifiableCredential(subject));
        }
        return null;
    }

    private OidcCibaRequest fetchOidcCibaRequest(String requestId) {
        OidcCibaRequestFactory cibaFactory = (OidcCibaRequestFactory)((OidcConfigurationContext)this.configurationContext).getTicketFactory().get(OidcCibaRequest.class);
        String decodedId = cibaFactory.decodeId(requestId);
        OidcCibaRequest cibaRequest = (OidcCibaRequest)((OidcConfigurationContext)this.configurationContext).getTicketRegistry().getTicket(decodedId, OidcCibaRequest.class);
        Assert.notNull((Object)cibaRequest, (String)"CIBA request cannot be found");
        Assert.isTrue((boolean)cibaRequest.getEncodedId().equals(requestId), (String)"CIBA request identifier is invalid");
        return cibaRequest;
    }
}

