/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.OAuth20TicketGrantingTicketAwareSecurityLogic;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAuthenticationAuthorizeSecurityLogic
extends OAuth20TicketGrantingTicketAwareSecurityLogic {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAuthenticationAuthorizeSecurityLogic.class);
    private final OAuth20RequestParameterResolver oauthRequestParameterResolver;

    public OidcAuthenticationAuthorizeSecurityLogic(CasCookieBuilder ticketGrantingTicketCookieGenerator, TicketRegistry ticketRegistry, OAuth20RequestParameterResolver parameterResolver) {
        super(ticketGrantingTicketCookieGenerator, ticketRegistry);
        this.oauthRequestParameterResolver = parameterResolver;
    }

    protected List<UserProfile> loadProfiles(CallContext callContext, ProfileManager manager, List<Client> clients) {
        Set prompts = this.oauthRequestParameterResolver.resolveSupportedPromptValues(callContext.webContext());
        LOGGER.debug("Located OpenID Connect prompts from request as [{}]", (Object)prompts);
        Boolean tooOld = OidcRequestSupport.getOidcMaxAgeFromAuthorizationRequest(callContext.webContext()).map(maxAge -> manager.getProfile(BasicUserProfile.class).stream().anyMatch(profile -> OidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest(callContext.webContext(), profile))).orElse(Boolean.FALSE);
        return tooOld != false || prompts.contains("login") ? new ArrayList<UserProfile>(0) : super.loadProfiles(callContext, manager, clients);
    }
}

