/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.util;

import java.io.Serializable;
import java.security.Key;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.oidc.token.OidcRegisteredServiceJwtCipherExecutor;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.token.cipher.JwtTicketCipherExecutor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalJwtAccessTokenCipherExecutor
extends JwtTicketCipherExecutor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalJwtAccessTokenCipherExecutor.class);
    private JsonWebKey signingWebKey;
    private JsonWebKey encryptionWebKey;
    private final OidcRegisteredServiceJwtCipherExecutor cipherExecutor;

    InternalJwtAccessTokenCipherExecutor(String encryptionKey, String signingKey, OidcRegisteredServiceJwtCipherExecutor cipherExecutor) {
        super(encryptionKey, signingKey, StringUtils.isNotBlank((CharSequence)encryptionKey), StringUtils.isNotBlank((CharSequence)signingKey), 0, 0);
        this.cipherExecutor = cipherExecutor;
    }

    public static JwtTicketCipherExecutor get(String signingKey, String encryptionKey, RegisteredService registeredService, OidcRegisteredServiceJwtCipherExecutor cipherExecutor) {
        InternalJwtAccessTokenCipherExecutor cipher = new InternalJwtAccessTokenCipherExecutor(encryptionKey, signingKey, cipherExecutor);
        Unchecked.consumer(__ -> {
            PublicJsonWebKey jsonWebKey;
            if (EncodingUtils.isJsonWebKey((String)encryptionKey)) {
                jsonWebKey = InternalJwtAccessTokenCipherExecutor.toJsonWebKey(encryptionKey);
                cipher.setEncryptionKey(jsonWebKey.getPublicKey());
                cipher.setEncryptionWebKey((JsonWebKey)jsonWebKey);
            }
            if (EncodingUtils.isJsonWebKey((String)signingKey)) {
                jsonWebKey = InternalJwtAccessTokenCipherExecutor.toJsonWebKey(signingKey);
                cipher.setSigningKey((Key)ObjectUtils.defaultIfNull((Object)jsonWebKey.getPrivateKey(), (Object)jsonWebKey.getKey()));
                cipher.setSigningWebKey((JsonWebKey)jsonWebKey);
            }
        }).accept(cipher);
        if (EncodingUtils.isJsonWebKey((String)encryptionKey) || EncodingUtils.isJsonWebKey((String)signingKey)) {
            cipher.setEncryptionAlgorithm("RSA-OAEP-256");
        }
        cipher.setCommonHeaders(CollectionUtils.wrap((String)RegisteredServiceCipherExecutor.CUSTOM_HEADER_REGISTERED_SERVICE_ID, (Object)registeredService.getId()));
        return cipher;
    }

    private Key getEncryptionKeyForDecryption(RegisteredService registeredService) {
        OAuthRegisteredService svc = (OAuthRegisteredService)registeredService;
        if (svc instanceof OidcRegisteredService) {
            Optional jwks = Objects.requireNonNull((Optional)this.cipherExecutor.getRegisteredServiceJsonWebKeystoreCache().get((Object)new OidcJsonWebKeyCacheKey(svc, OidcJsonWebKeyUsage.ENCRYPTION)));
            if (jwks.isEmpty()) {
                LOGGER.warn("Service [{}] with client id [{}] is configured to encrypt tokens, yet no JSON web key is available", (Object)svc.getServiceId(), (Object)svc.getClientId());
                return null;
            }
            PublicJsonWebKey jsonWebKey = (PublicJsonWebKey)((JsonWebKeySet)jwks.get()).getJsonWebKeys().getFirst();
            LOGGER.debug("Found JSON web key to encrypt the token: [{}]", (Object)jsonWebKey);
            if (jsonWebKey.getPrivateKey() == null) {
                LOGGER.info("JSON web key used to encrypt the token has no associated private key, when operating on service [{}] with client id [{}]. Operations that deal with JWT encryption/decryption may not be functional, until a private key can be loaded for JSON web key [{}]", new Object[]{svc.getServiceId(), svc.getClientId(), jsonWebKey.getKeyId()});
                return null;
            }
            return jsonWebKey.getPrivateKey();
        }
        return null;
    }

    private static PublicJsonWebKey toJsonWebKey(String key) throws Exception {
        Map details = EncodingUtils.parseJsonWebKey((String)key);
        if (details.containsKey("keys")) {
            return (PublicJsonWebKey)new JsonWebKeySet(key).getJsonWebKeys().getFirst();
        }
        return (PublicJsonWebKey)EncodingUtils.newJsonWebKey((String)key);
    }

    protected byte[] sign(byte[] value, Key signingKey) {
        return Optional.ofNullable(this.signingWebKey).map(key -> {
            String kid = key.getKeyId();
            if (StringUtils.isNotBlank((CharSequence)kid)) {
                this.getSigningOpHeaders().put("kid", kid);
            }
            String alg = (String)StringUtils.defaultIfBlank((CharSequence)key.getAlgorithm(), (CharSequence)this.getSigningAlgorithmFor(key.getKey()));
            this.getSigningOpHeaders().put("alg", alg);
            return this.signWith(value, alg, signingKey);
        }).orElseGet(() -> super.sign(value, signingKey));
    }

    protected String decode(Serializable value, Object[] parameters, Key encKey, Key signingKey) {
        if (parameters.length > 0) {
            RegisteredService registeredService = (RegisteredService)parameters[0];
            Key decryptionKey = this.getEncryptionKeyForDecryption(registeredService);
            return super.decode(value, parameters, decryptionKey, signingKey);
        }
        return super.decode(value, parameters, encKey, signingKey);
    }

    @Generated
    public void setSigningWebKey(JsonWebKey signingWebKey) {
        this.signingWebKey = signingWebKey;
    }

    @Generated
    public void setEncryptionWebKey(JsonWebKey encryptionWebKey) {
        this.encryptionWebKey = encryptionWebKey;
    }

    @Generated
    public JsonWebKey getSigningWebKey() {
        return this.signingWebKey;
    }

    @Generated
    public JsonWebKey getEncryptionWebKey() {
        return this.encryptionWebKey;
    }

    @Generated
    public OidcRegisteredServiceJwtCipherExecutor getCipherExecutor() {
        return this.cipherExecutor;
    }
}

